/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.text.timelapse;

import com.perforce.team.core.P4CoreUtils;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.text.PerforceUiTextPlugin;
import com.perforce.team.ui.text.timelapse.Messages;
import com.perforce.team.ui.text.timelapse.TextTimeLapseEditor;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.progress.UIJob;

public abstract class NodeTimeLapseEditor
extends TextTimeLapseEditor {
    public static final String NONE_SELECTED = "<none selected>";
    public static final String SHOW_FOLDING = "com.perforce.team.ui.text.timelapse.SHOW_FOLDING";
    public static final String LINK_EDITOR = "com.perforce.team.ui.text.timelapse.LINK_EDITOR";
    private ITextViewerExtension5 viewer5 = null;
    protected Combo filters = null;
    private String filterKey = null;
    private boolean folding = false;
    private boolean linking = false;

    protected String getFilter() {
        return this.filterKey;
    }

    @Override
    protected void createHeader(Composite parent) {
        super.createHeader(parent);
        this.createCombo(parent);
    }

    protected void configureLinking(ToolBar toolbar, String tooltip) {
        final ToolItem linkItem = new ToolItem(toolbar, 32);
        if (tooltip != null) {
            linkItem.setToolTipText(tooltip);
        }
        Image linkImage = PerforceUiTextPlugin.getImageDescriptor("icons/link.png").createImage();
        P4UIUtils.registerDisposal((Widget)linkItem, (Resource)linkImage);
        linkItem.setImage(linkImage);
        linkItem.setSelection(this.isLinking());
        linkItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NodeTimeLapseEditor.this.linking = linkItem.getSelection();
                PerforceUiTextPlugin.getDefault().getPreferenceStore().setValue(NodeTimeLapseEditor.LINK_EDITOR, NodeTimeLapseEditor.this.linking);
            }
        });
    }

    protected boolean isLinking() {
        return this.linking;
    }

    @Override
    protected void fillToolbar(ToolBar toolbar) {
        super.fillToolbar(toolbar);
        final ToolItem projectionItem = new ToolItem(toolbar, 32);
        Image foldingImage = PerforceUiTextPlugin.getImageDescriptor("icons/folding.png").createImage();
        P4UIUtils.registerDisposal((Widget)projectionItem, (Resource)foldingImage);
        projectionItem.setImage(foldingImage);
        projectionItem.setToolTipText(Messages.NodeTimeLapseEditor_ToggleFolding);
        projectionItem.setSelection(this.folding);
        projectionItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NodeTimeLapseEditor.this.folding = projectionItem.getSelection();
                NodeTimeLapseEditor.this.updateRedrawStatus();
                if (NodeTimeLapseEditor.this.folding) {
                    NodeTimeLapseEditor.this.scheduleProjection();
                } else {
                    NodeTimeLapseEditor.this.scheduleNoProjection();
                }
                NodeTimeLapseEditor.this.redrawRulers();
                PerforceUiTextPlugin.getDefault().getPreferenceStore().setValue(NodeTimeLapseEditor.SHOW_FOLDING, NodeTimeLapseEditor.this.folding);
            }
        });
    }

    protected abstract Collection<String> getFilters();

    protected abstract String getFilterLabel();

    protected abstract String getKey(String var1);

    protected abstract Range getRange(String var1);

    protected abstract void buildTree(IEditorInput var1);

    protected abstract void buildDocument(IEditorInput var1);

    protected void enableProjection() {
        ITextViewer viewer = this.getViewer();
        if (viewer instanceof ProjectionViewer) {
            ((ProjectionViewer)viewer).enableProjection();
        }
    }

    protected void disableProjection() {
        ITextViewer viewer = this.getViewer();
        if (viewer instanceof ProjectionViewer) {
            ((ProjectionViewer)viewer).disableProjection();
        }
    }

    protected void scheduleProjection() {
        if (this.folding && this.getFilter() == null) {
            UIJob job = new UIJob(Messages.NodeTimeLapseEditor_EnablingFolding){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    NodeTimeLapseEditor.this.enableFolding();
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
    }

    protected void disableFolding() {
        ITextViewer viewer = this.getViewer();
        if (viewer instanceof ProjectionViewer) {
            ((ProjectionViewer)viewer).doOperation(20);
        }
        this.disableProjection();
    }

    protected void enableFolding() {
        this.enableProjection();
    }

    protected void scheduleNoProjection() {
        if (this.getFilter() == null) {
            UIJob job = new UIJob(Messages.NodeTimeLapseEditor_DisablingFolding){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    NodeTimeLapseEditor.this.disableFolding();
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
    }

    @Override
    protected void refresh(IEditorInput input) {
        this.buildTree(input);
        this.buildDocument(input);
        this.updateFilterEntries();
        this.filter(false);
    }

    @Override
    protected int convertToModelLine(int widgetLine) {
        if (this.viewer5 != null) {
            widgetLine = this.viewer5.widgetLine2ModelLine(widgetLine);
        }
        return widgetLine;
    }

    @Override
    protected int convertToWidgetLine(int modelLine) {
        if (this.viewer5 != null) {
            modelLine = this.viewer5.modelLine2WidgetLine(modelLine);
        }
        return modelLine;
    }

    protected void updateEditor() {
        super.updateEditor();
        this.addFilterEntries();
    }

    private void addFilterEntries() {
        if (this.filters != null) {
            String previous = this.filters.getText();
            this.filters.removeAll();
            Collection<String> keys = this.getFilters();
            String[] entries = keys.toArray(new String[keys.size()]);
            this.filters.add(NONE_SELECTED);
            String[] stringArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                String entry = stringArray[n2];
                this.filters.add(entry);
                ++n2;
            }
            if (previous.length() > 0) {
                this.filters.setText(previous);
            } else {
                this.filters.select(0);
            }
        }
    }

    protected void updateFilterEntries() {
        this.addFilterEntries();
    }

    protected void showEntireDocument() {
        ITextViewer viewer = this.getViewer();
        viewer.resetVisibleRegion();
        if (this.folding) {
            this.enableProjection();
        } else {
            this.disableProjection();
        }
    }

    protected void filter(boolean newFilter) {
        ITextViewer viewer = this.getViewer();
        if (this.filterKey != null) {
            Range range = this.getRange(this.filterKey);
            if (range != null) {
                viewer.setVisibleRegion(range.offset, range.length);
            } else {
                viewer.setVisibleRegion(0, 0);
            }
        } else {
            this.showEntireDocument();
        }
        viewer.setSelectedRange(0, 0);
        this.redrawRulers();
    }

    protected boolean isFiltering() {
        return this.filterKey != null;
    }

    protected void clearFilter() {
        this.filterKey = null;
        this.filters.select(0);
        this.showEntireDocument();
    }

    @Override
    protected void updateVisibleRange() {
        if (!this.isFiltering()) {
            super.updateVisibleRange();
        } else {
            this.getViewer().getTextWidget().setTopIndex(0);
        }
    }

    protected void showRange(Range range) {
        if (this.isFiltering()) {
            this.clearFilter();
        }
        this.getViewer().getTextWidget().setRedraw(false);
        this.getViewer().revealRange(range.offset, range.length);
        this.getViewer().getTextWidget().setRedraw(true);
        this.redrawRulers();
    }

    protected void selectRange(Range range) {
        this.setRedraw(false);
        this.getViewer().setSelectedRange(range.offset, range.length);
        this.setRedraw(true);
    }

    private void updateRedrawStatus() {
        this.redraw = P4CoreUtils.isWindows() || P4CoreUtils.isLinux() ? this.folding : false;
    }

    @Override
    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        IPreferenceStore store = PerforceUiTextPlugin.getDefault().getPreferenceStore();
        this.linking = store.getBoolean(LINK_EDITOR);
        this.folding = store.getBoolean(SHOW_FOLDING);
        this.updateRedrawStatus();
    }

    @Override
    protected void configureViewer(String fontPrefName) {
        super.configureViewer(fontPrefName);
        ITextViewer viewer = this.getViewer();
        if (viewer instanceof ITextViewerExtension5) {
            this.viewer5 = (ITextViewerExtension5)viewer;
            if (this.folding) {
                this.scheduleProjection();
            } else {
                this.scheduleNoProjection();
            }
        }
    }

    protected void createCombo(Composite parent) {
        Composite filterArea = new Composite(parent, 0);
        GridLayout faLayout = new GridLayout(3, false);
        filterArea.setLayout((Layout)faLayout);
        filterArea.setLayoutData((Object)new GridData(4, 4, true, false));
        Label methodsLabel = new Label(filterArea, 0);
        methodsLabel.setText(this.getFilterLabel());
        final SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = NodeTimeLapseEditor.this.filters.getSelectionIndex();
                if (index >= 0) {
                    boolean filter = false;
                    if (index == 0) {
                        filter = NodeTimeLapseEditor.this.filterKey != null;
                        NodeTimeLapseEditor.this.filterKey = null;
                    } else {
                        String newFilterKey = NodeTimeLapseEditor.this.getKey(NodeTimeLapseEditor.this.filters.getText());
                        filter = newFilterKey != null && !newFilterKey.equals(NodeTimeLapseEditor.this.filterKey);
                        NodeTimeLapseEditor.this.filterKey = newFilterKey;
                    }
                    if (filter) {
                        NodeTimeLapseEditor.this.filter(true);
                    }
                }
            }
        };
        this.filters = new Combo(filterArea, 12);
        this.filters.setLayoutData((Object)new GridData(4, 4, true, false));
        this.filters.addSelectionListener((SelectionListener)selectionAdapter);
        ToolBar filterBar = new ToolBar(filterArea, 0x800000);
        ToolItem clearItem = new ToolItem(filterBar, 8);
        Image clearImage = PerforceUIPlugin.getPlugin().getImageDescriptor("normal/clear.png").createImage();
        P4UIUtils.registerDisposal((Widget)clearItem, (Resource)clearImage);
        clearItem.setImage(clearImage);
        clearItem.setToolTipText(Messages.NodeTimeLapseEditor_ClearFilter);
        clearItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NodeTimeLapseEditor.this.filters.select(0);
                selectionAdapter.widgetSelected(null);
            }
        });
    }

    protected static class Range {
        int offset;
        int length;

        public Range(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }
    }
}

