/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.text.timelapse;

import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4Revision;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.text.PerforceUiTextPlugin;
import com.perforce.team.ui.text.timelapse.IFilterNodeModel;
import com.perforce.team.ui.text.timelapse.Messages;
import com.perforce.team.ui.text.timelapse.NodeOutlinePage;
import com.perforce.team.ui.text.timelapse.NodeTickDecorator;
import com.perforce.team.ui.text.timelapse.NodeTickFormatter;
import com.perforce.team.ui.text.timelapse.NodeTimeLapseEditor;
import com.perforce.team.ui.timelapse.ITickDecorator;
import com.perforce.team.ui.timelapse.ITickFormatter;
import com.perforce.team.ui.timelapse.ITickPositionHandler;
import com.perforce.team.ui.timelapse.TimeLapseSlider;
import java.text.MessageFormat;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public abstract class NodeModelTimeLapseEditor
extends NodeTimeLapseEditor {
    public static final String BUILD = "com.perforce.team.ui.text.timelapse.BUILD";
    public static final String FILTER = "com.perforce.team.ui.text.timelapse.FILTER";
    public static final String TICK_CHANGE_COLOR = "com.perforce.team.ui.text.timelapse.TICK_CHANGE_COLOR";
    private NodeTickFormatter formatter;
    private Color formatterBg = null;
    private NodeTickDecorator decorator;
    private IFilterNodeModel nodeModel;
    private boolean build = false;
    private boolean revFilter = false;
    protected ToolItem buildItem;
    protected ToolItem filterItem;
    protected NodeOutlinePage outlinePage;
    protected Object selected = null;
    protected Object root = null;

    protected NodeOutlinePage createOutlinePage() {
        return null;
    }

    protected void showNode(Object node) {
        this.selected = node;
    }

    @Override
    protected void updateVisibleRange() {
        if (!this.isLinking() && this.outlinePage != null && this.selected != null) {
            if (!this.outlinePage.isDisposed()) {
                this.outlinePage.setSelection((ISelection)StructuredSelection.EMPTY);
            } else {
                this.outlinePage = null;
            }
            this.showNode(null);
        }
        super.updateVisibleRange();
    }

    protected abstract IFilterNodeModel createNodeModel();

    protected abstract String getNodeLabel();

    protected NodeTickDecorator createNodeDecorator() {
        return null;
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter == IContentOutlinePage.class) {
            if (this.outlinePage == null || this.outlinePage.isDisposed()) {
                this.outlinePage = this.createOutlinePage();
                if (this.outlinePage != null) {
                    this.outlinePage.setRevision(this.getRevision());
                    this.outlinePage.addSelectionChangedListener(new ISelectionChangedListener(){

                        public void selectionChanged(SelectionChangedEvent event) {
                            if (NodeModelTimeLapseEditor.this.isLoading()) {
                                return;
                            }
                            if (event.getSelection() instanceof IStructuredSelection) {
                                Object first = ((IStructuredSelection)event.getSelection()).getFirstElement();
                                if (first != null) {
                                    NodeModelTimeLapseEditor.this.showNode(first);
                                    NodeModelTimeLapseEditor.this.updateSliderFilter();
                                } else if (!(NodeModelTimeLapseEditor.this.isFiltering() || NodeModelTimeLapseEditor.this.isSettingInput() || NodeModelTimeLapseEditor.this.outlinePage.isLoading())) {
                                    NodeModelTimeLapseEditor.this.showNode(null);
                                    NodeModelTimeLapseEditor.this.updateSliderFilter();
                                }
                            }
                        }
                    });
                }
            }
            return this.outlinePage;
        }
        return super.getAdapter(adapter);
    }

    protected void installPartitioner(IDocument document) {
    }

    protected abstract IDocument getDocument(IEditorInput var1);

    @Override
    protected void buildDocument(IEditorInput input) {
        IDocument document = this.getDocument(input);
        ITextViewer viewer = this.getViewer();
        this.disableProjection();
        this.setRedraw(false);
        IDocument currDoc = viewer.getDocument();
        if (currDoc != null) {
            currDoc.set(document.get());
        } else {
            currDoc = new Document(document.get());
            this.installPartitioner(currDoc);
            if (viewer instanceof ISourceViewer) {
                ((ISourceViewer)viewer).setDocument(currDoc, (IAnnotationModel)new AnnotationModel());
            } else {
                viewer.setDocument(currDoc);
            }
        }
        this.setRedraw(true);
    }

    @Override
    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        IPreferenceStore store = PerforceUiTextPlugin.getDefault().getPreferenceStore();
        this.setBuild(store.getBoolean(BUILD));
        this.revFilter = store.getBoolean(FILTER);
        this.formatterBg = new Color((Device)P4UIUtils.getDisplay(), PreferenceConverter.getColor((IPreferenceStore)store, (String)TICK_CHANGE_COLOR));
        P4UIUtils.registerDisposal((Widget)this.getControl(), (Resource)this.formatterBg);
    }

    @Override
    public void dispose() {
        if (this.nodeModel != null) {
            this.nodeModel.clear();
        }
        super.dispose();
    }

    @Override
    protected void fillToolbar(ToolBar toolbar) {
        super.fillToolbar(toolbar);
        this.addBuildItem(toolbar);
        this.addFilterItem(toolbar);
    }

    protected void addBuildItem(ToolBar toolbar) {
        this.buildItem = new ToolItem(toolbar, 32);
        Image buildImage = PerforceUiTextPlugin.getImageDescriptor("icons/build.png").createImage();
        P4UIUtils.registerDisposal((Widget)this.buildItem, (Resource)buildImage);
        this.buildItem.setImage(buildImage);
        this.buildItem.setToolTipText(MessageFormat.format(Messages.TextTimeLapseEditor_GenerateHistoryByAnalyzing, this.captilize(this.getNodeLabel())));
        this.buildItem.setSelection(this.isBuild());
        this.buildItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NodeModelTimeLapseEditor.this.setBuild(NodeModelTimeLapseEditor.this.buildItem.getSelection());
                PerforceUiTextPlugin.getDefault().getPreferenceStore().setValue(NodeModelTimeLapseEditor.BUILD, NodeModelTimeLapseEditor.this.isBuild());
                NodeModelTimeLapseEditor.this.filterItem.setEnabled(NodeModelTimeLapseEditor.this.isBuild());
                NodeModelTimeLapseEditor.this.filterItem.setSelection(NodeModelTimeLapseEditor.this.revFilter && NodeModelTimeLapseEditor.this.isBuild());
                NodeModelTimeLapseEditor.this.preserveSelectionLoad();
            }
        });
    }

    private String captilize(String text) {
        if (text.isEmpty()) {
            return text;
        }
        text = text.trim();
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < text.length()) {
            if (i == 0) {
                sb.append(Character.toUpperCase(text.charAt(0)));
            } else {
                sb.append(text.charAt(i));
            }
            ++i;
        }
        return sb.toString();
    }

    protected void addFilterItem(ToolBar toolbar) {
        this.filterItem = new ToolItem(toolbar, 32);
        Image filterImage = PerforceUiTextPlugin.getImageDescriptor("icons/filter.png").createImage();
        P4UIUtils.registerDisposal((Widget)this.filterItem, (Resource)filterImage);
        this.filterItem.setImage(filterImage);
        this.filterItem.setToolTipText(Messages.NodeModelTimeLapseEditor_FilterSliderTickMarksBySelection);
        this.filterItem.setSelection(this.revFilter && this.isBuild());
        this.filterItem.setEnabled(this.isBuild());
        this.filterItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NodeModelTimeLapseEditor.this.revFilter = NodeModelTimeLapseEditor.this.filterItem.getSelection();
                NodeModelTimeLapseEditor.this.formatter.setFilter(NodeModelTimeLapseEditor.this.revFilter);
                NodeModelTimeLapseEditor.this.formatter.filter();
                NodeModelTimeLapseEditor.this.updateSliderFilter();
                PerforceUiTextPlugin.getDefault().getPreferenceStore().setValue(NodeModelTimeLapseEditor.FILTER, NodeModelTimeLapseEditor.this.revFilter);
            }
        });
    }

    protected void updateSliderFilter() {
        TimeLapseSlider slider = this.getSlider();
        if (slider != null && !slider.filter(false)) {
            slider.redraw();
            slider.update();
            slider.updateActions();
        }
    }

    @Override
    protected void buildTree(IEditorInput input) {
        IFilterNodeModel model = this.getModel();
        IP4Revision revision = this.getRevision();
        if (model != null) {
            if (!this.isBuild()) {
                model.clear();
            }
            this.root = model.parseInput(input, revision);
            if (this.root != null && !this.isBuild()) {
                model.findNodes(this.root, revision);
            }
            if (this.decorator != null) {
                this.decorator.setModel(model);
            }
        }
        if (this.outlinePage != null && !this.outlinePage.isDisposed()) {
            this.outlinePage.setRevision(revision);
            this.outlinePage.setModel(model);
            this.outlinePage.setRoot(this.root);
        }
    }

    @Override
    protected void updateFilterEntries() {
        if (!this.isBuild()) {
            super.updateFilterEntries();
        }
    }

    protected Object getRoot() {
        return this.root;
    }

    protected IFilterNodeModel getModel() {
        return this.nodeModel;
    }

    protected NodeTickFormatter getFormatter() {
        return this.formatter;
    }

    protected NodeTickDecorator getDecorator() {
        return this.decorator;
    }

    @Override
    protected Collection<String> getFilters() {
        return this.nodeModel.getFilterLabels();
    }

    @Override
    protected String getKey(String filterText) {
        return this.nodeModel.getFilterKey(filterText);
    }

    protected void build() {
        this.nodeModel.buildAll();
        TimeLapseSlider slider = this.getSlider();
        if (slider != null) {
            slider.setDecorator((ITickDecorator)this.decorator);
            slider.setPositioner((ITickPositionHandler)this.formatter);
            slider.setFormatter((ITickFormatter)this.formatter);
        }
    }

    protected boolean isRevisionFiltering() {
        return this.revFilter;
    }

    protected boolean isBuild() {
        return this.build;
    }

    protected void setBuild(boolean build) {
        this.build = build;
    }

    protected void configureSlider(TimeLapseSlider slider) {
        if (this.isBuild()) {
            slider.setDecorator((ITickDecorator)this.decorator);
            slider.setPositioner((ITickPositionHandler)this.formatter);
            slider.setFormatter((ITickFormatter)this.formatter);
        } else {
            slider.setPositioner(null);
            slider.setFormatter(null);
            super.configureSlider(slider);
        }
    }

    protected void preUpdateEditor() {
        String decorateId;
        super.preUpdateEditor();
        String string = decorateId = this.decorator != null ? this.decorator.getNodeId() : null;
        if (this.decorator != null) {
            this.decorator.dispose();
        }
        this.decorator = this.createNodeDecorator();
        if (this.decorator != null) {
            this.decorator.setNodeId(decorateId);
        }
    }

    @Override
    protected void loadEditor(IP4File file, IProgressMonitor monitor) {
        super.loadEditor(file, monitor);
        if (this.nodeModel != null) {
            this.nodeModel.clear();
        }
        this.nodeModel = this.createNodeModel();
        String formatId = this.formatter != null ? this.formatter.getId() : null;
        this.formatter = new NodeTickFormatter(this.nodeModel);
        this.formatter.setColor(this.formatterBg);
        this.formatter.setFilter(this.revFilter);
        if (this.isBuild()) {
            monitor.setTaskName("Parsing each revision for: " + file.getActionPath());
            this.build();
            this.formatter.setFilter(formatId);
        }
    }

    @Override
    protected void filter(boolean newFilter) {
        if (this.outlinePage != null && newFilter && this.getFilter() != null) {
            this.selected = null;
            this.outlinePage.setSelection((ISelection)StructuredSelection.EMPTY);
        }
        super.filter(newFilter);
        String filter = this.getFilter();
        boolean redraw = true;
        if (newFilter) {
            this.formatter.setFilter(filter);
            if (this.decorator != null) {
                this.decorator.setNodeId(filter);
            }
            boolean bl = redraw = !this.getSlider().filter(false);
        }
        if (redraw) {
            if (newFilter || filter != null) {
                this.getSlider().redraw();
                this.getSlider().update();
            }
            this.getSlider().updateActions();
        }
    }
}

