/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.python.timelapse;

import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.ui.python.timelapse.Messages;
import com.perforce.team.ui.python.timelapse.PythonFoldingProvider;
import com.perforce.team.ui.python.timelapse.PythonNodeModel;
import com.perforce.team.ui.python.timelapse.PythonOutlinePage;
import com.perforce.team.ui.python.timelapse.PythonTickDecorator;
import com.perforce.team.ui.python.timelapse.PythonUtils;
import com.perforce.team.ui.text.timelapse.IFilterNodeModel;
import com.perforce.team.ui.text.timelapse.INodeModel;
import com.perforce.team.ui.text.timelapse.ITextAnnotateModel;
import com.perforce.team.ui.text.timelapse.NodeModelTimeLapseEditor;
import com.perforce.team.ui.text.timelapse.NodeOutlinePage;
import com.perforce.team.ui.text.timelapse.NodeTickDecorator;
import com.perforce.team.ui.text.timelapse.NodeTimeLapseEditor;
import com.perforce.team.ui.text.timelapse.TextAnnotateModel;
import com.perforce.team.ui.timelapse.IRevisionInputCache;
import java.util.Iterator;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ISourceReference;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.ui.editor.ScriptSourceViewer;
import org.eclipse.dltk.python.internal.ui.text.PythonSourceViewerConfiguration;
import org.eclipse.dltk.python.internal.ui.text.PythonTextTools;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.AnnotationRulerColumn;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;

public class PythonTimeLapseEditor
extends NodeModelTimeLapseEditor {
    public static final String ID = "com.perforce.team.ui.python.PythonTimeLapseEditor";
    private ScriptSourceViewer viewer;
    private PythonFoldingProvider provider;

    protected ITextAnnotateModel createTextAnnotateModel(IP4File file) {
        return new TextAnnotateModel(file, "P4_PYTHON_PREFIX");
    }

    protected NodeTickDecorator createNodeDecorator() {
        return new PythonTickDecorator((INodeModel)this.getModel());
    }

    protected IFilterNodeModel createNodeModel() {
        return new PythonNodeModel(this.getRevisions(), (IRevisionInputCache)this);
    }

    protected void enableProjection() {
        super.enableProjection();
        IVerticalRulerColumn column = null;
        CompositeRuler ruler = this.getRuler();
        if (ruler != null) {
            Iterator columnIterator = ruler.getDecoratorIterator();
            while (columnIterator.hasNext()) {
                column = (IVerticalRulerColumn)columnIterator.next();
            }
            if (column != null && column instanceof AnnotationRulerColumn) {
                column.getControl().setBackground(column.getControl().getDisplay().getSystemColor(1));
                column.getControl().redraw();
            }
        }
    }

    protected void fillToolbar(ToolBar toolbar) {
        super.fillToolbar(toolbar);
        this.configureLinking(toolbar, Messages.PythonTimeLapseEditor_LinkWithOutlineViewSelection);
    }

    protected void disableFolding() {
        if (this.provider != null) {
            this.provider.clearModel();
        }
        super.disableFolding();
    }

    public void showNode(Object node) {
        super.showNode(node);
        if (node != null && !(node instanceof IModelElement)) {
            return;
        }
        if (node instanceof IMethod) {
            String id = this.getModel().getHandle(node);
            this.getFormatter().setFilter(id);
            this.getDecorator().setNodeId(id);
        } else {
            this.getFormatter().setFilter(null);
            this.getDecorator().setNodeId(null);
        }
        if (node instanceof ISourceReference) {
            try {
                ISourceRange sourceRange = ((ISourceReference)node).getSourceRange();
                if (sourceRange != null) {
                    this.showRange(new NodeTimeLapseEditor.Range(sourceRange.getOffset(), sourceRange.getLength()));
                }
                int offset = -1;
                int length = 0;
                if (node instanceof IMember && (sourceRange = ((IMember)node).getNameRange()) != null) {
                    offset = sourceRange.getOffset();
                    length = sourceRange.getLength();
                }
                if (offset > -1 && length > 0) {
                    this.selectRange(new NodeTimeLapseEditor.Range(offset, length));
                }
            }
            catch (ModelException e) {
                PerforceProviderPlugin.logError((Throwable)e);
            }
        }
    }

    protected void updateVisibleRange() {
        PythonNodeModel javaModel;
        IModelElement element;
        if (this.isLinking() && !this.isFiltering() && this.selected != null && (element = (javaModel = (PythonNodeModel)this.getModel()).getPythonElement(this.getRevision(), javaModel.getHandle(this.selected))) != null) {
            if (this.outlinePage != null) {
                if (!this.outlinePage.isDisposed()) {
                    this.outlinePage.setSelection((ISelection)new StructuredSelection((Object)element));
                } else {
                    this.outlinePage = null;
                }
            }
            this.showNode(element);
            return;
        }
        super.updateVisibleRange();
    }

    protected void createViewer(Composite parent) {
        CompositeRuler ruler = this.configureRulers(true);
        IPreferenceStore store = PythonUtils.createCombinedPreferenceStore();
        this.viewer = new ScriptSourceViewer(parent, (IVerticalRuler)ruler, null, false, 0x2000300, store){

            public void setTopIndex(int index) {
                if (!PythonTimeLapseEditor.this.updatingDoc) {
                    super.setTopIndex(index);
                }
            }

            public void setSelectedRange(int selectionOffset, int selectionLength) {
                if (!PythonTimeLapseEditor.this.updatingDoc) {
                    super.setSelectedRange(selectionOffset, selectionLength);
                }
            }
        };
        ProjectionSupport support = new ProjectionSupport((ProjectionViewer)this.viewer, (IAnnotationAccess)new DefaultMarkerAnnotationAccess(), this.getSharedTextColors());
        support.install();
        this.provider = new PythonFoldingProvider((ProjectionViewer)this.viewer, support);
        PythonTextTools tools = PythonUtils.getTools();
        if (tools != null) {
            this.viewer.configure((SourceViewerConfiguration)new PythonSourceViewerConfiguration(tools.getColorManager(), store, null, "__python_partitioning"));
        }
        this.configureViewer("org.eclipse.jface.textfont");
        this.viewer.getTextWidget().setBackground(this.getEditorColor("AbstractTextEditor.Color.Background"));
    }

    protected void dispose(IEditorInput input) {
        super.dispose(input);
        PythonUtils.getProvider().disconnect((Object)input);
    }

    protected ITextViewer getViewer() {
        return this.viewer;
    }

    protected String getFilterLabel() {
        return Messages.PythonTimeLapseEditor_Methods;
    }

    protected String getNodeLabel() {
        return "method";
    }

    protected NodeTimeLapseEditor.Range getRange(String filterKey) {
        NodeTimeLapseEditor.Range range = null;
        IModelElement method = ((PythonNodeModel)this.getModel()).getPythonElement(this.getRevision(), filterKey);
        if (method instanceof ISourceReference) {
            try {
                ISourceRange sourceRange = ((ISourceReference)method).getSourceRange();
                if (sourceRange != null) {
                    range = new NodeTimeLapseEditor.Range(sourceRange.getOffset(), sourceRange.getLength());
                }
            }
            catch (ModelException e) {
                PerforceProviderPlugin.logError((Throwable)e);
            }
        }
        return range;
    }

    protected void buildDocument(IEditorInput input) {
        this.provider.install((IModelElement)this.getRoot());
        super.buildDocument(input);
    }

    protected NodeOutlinePage createOutlinePage() {
        return new PythonOutlinePage((IModelElement)this.getRoot(), (INodeModel)this.getModel());
    }

    protected IDocument getDocument(IEditorInput input) {
        return PythonUtils.getProvider().getDocument((Object)input);
    }

    protected void installPartitioner(IDocument document) {
        PythonTextTools tools = PythonUtils.getTools();
        if (tools != null) {
            tools.setupDocumentPartitioner(document, "__python_partitioning");
        }
    }
}

