/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.folder.timelapse;

import com.perforce.p4java.core.file.FileAction;
import com.perforce.p4java.core.file.IFileRevisionData;
import com.perforce.team.core.p4java.IP4Revision;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.decorator.P4Decoration;
import com.perforce.team.ui.decorator.PerforceDecorator;
import com.perforce.team.ui.folder.timelapse.FileEntry;
import com.perforce.team.ui.folder.timelapse.Messages;
import java.text.MessageFormat;
import java.util.HashMap;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;

public class FolderLabelDecorator
implements ILabelDecorator {
    private IP4Revision revision;
    private String fileDecoration = PerforceUIPlugin.getPlugin().getPreferenceStore().getString("com.perforce.team.ui.preferences.FILE_DECORATION_TEXT");

    public void setRevision(IP4Revision revision) {
        this.revision = revision;
    }

    public Image decorateImage(Image image, Object element) {
        return null;
    }

    public String decorateText(String text, Object element) {
        if (this.revision != null & element instanceof FileEntry) {
            FileAction action;
            String actionText;
            FileEntry file = (FileEntry)element;
            int id = this.revision.getChangelist();
            IFileRevisionData data = file.getData(id);
            HashMap<String, String> bindings = new HashMap<String, String>();
            if (data.getRevision() > 0) {
                bindings.put("have", Integer.toString(data.getRevision()));
            }
            String string = actionText = (action = data.getAction()) != null ? action.toString().toLowerCase() : null;
            if (actionText != null) {
                bindings.put("action", actionText);
            }
            bindings.put("name", text);
            StringBuilder decorated = P4Decoration.decorate((String)this.fileDecoration, bindings);
            decorated.append(MessageFormat.format(Messages.FolderLabelDecorator_ChangelistSuffix, file.getData(id).getChangelistId()));
            return PerforceDecorator.removeTrailingWhitespace((StringBuilder)decorated);
        }
        return text;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

