/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.folder.timelapse;

import com.perforce.p4java.core.file.FileAction;
import com.perforce.p4java.core.file.IFileRevisionData;
import com.perforce.p4java.core.file.IRevisionIntegrationData;
import com.perforce.team.core.P4CoreUtils;
import com.perforce.team.core.p4java.IP4Revision;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.folder.timelapse.FileEntry;
import com.perforce.team.ui.folder.timelapse.IEntry;
import com.perforce.team.ui.folder.timelapse.RootEntry;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class FolderEntry
implements IWorkbenchAdapter,
Comparable<IWorkbenchAdapter>,
IEntry {
    private RootEntry root;
    private String name;
    private FolderEntry parent;
    private int first = Integer.MAX_VALUE;
    private Map<Integer, String> moveAdds = new HashMap<Integer, String>();
    private Set<IEntry> children = new TreeSet<IEntry>();

    public FolderEntry(String name, FolderEntry parent) {
        this.name = name;
        this.parent = parent;
        if (this.parent != null) {
            this.parent.add(this);
        }
    }

    public void setRoot(RootEntry root) {
        this.root = root;
        if (root != null) {
            IP4Revision[] iP4RevisionArray = this.getRevisions();
            int n = iP4RevisionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IP4Revision revision = iP4RevisionArray[n2];
                this.moveAdds.put(revision.getChangelist(), null);
                ++n2;
            }
        }
    }

    @Override
    public void complete() {
        for (IEntry child : this.children) {
            child.complete();
        }
        for (IEntry child : this.children) {
            this.first = Math.min(this.first, child.getFirst());
        }
    }

    @Override
    public int getFirst() {
        return this.first;
    }

    public boolean isMoveAdd(int changelist) {
        return this.moveAdds.containsKey(changelist);
    }

    public String getMoveFrom(int changelist) {
        return this.moveAdds.get(changelist);
    }

    public void updateMoveStatus(FileEntry entry, IFileRevisionData data) {
        int id = data.getChangelistId();
        if (this.moveAdds.containsKey(id)) {
            FileAction action = data.getAction();
            if (!FileAction.MOVE_ADD.equals((Object)action)) {
                this.moveAdds.remove(id);
            } else {
                List integs = data.getRevisionIntegrationData();
                if (integs != null) {
                    for (IRevisionIntegrationData integ : integs) {
                        String from;
                        int lastSlash;
                        if (!integ.getHowFrom().equals("moved from") || (lastSlash = (from = integ.getFromFile()).lastIndexOf(47)) < 0 || lastSlash >= from.length() || (lastSlash = (from = from.substring(0, lastSlash)).lastIndexOf(47)) < 0 || lastSlash + 1 >= from.length()) continue;
                        String moveFrom = from.substring(lastSlash + 1);
                        String currMove = this.moveAdds.get(id);
                        if (currMove == null) {
                            this.moveAdds.put(id, moveFrom);
                            continue;
                        }
                        if (currMove.equals(moveFrom)) continue;
                        this.moveAdds.remove(id);
                    }
                }
            }
        }
    }

    public void add(IEntry child) {
        if (child != null && !this.children.contains(child)) {
            this.children.add(child);
        }
    }

    public Object[] getChildren(Object o) {
        return this.children.toArray();
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return PerforceUIPlugin.getDescriptor((String)"perforce/depot_folder.png");
    }

    public String getLabel(Object o) {
        return this.name;
    }

    public Object getParent(Object o) {
        return this.parent;
    }

    @Override
    public int compareTo(IWorkbenchAdapter o) {
        return this.getLabel(this).compareToIgnoreCase(o.getLabel((Object)o));
    }

    @Override
    public IP4Revision[] getRevisions() {
        return this.root.getRevisions();
    }

    public boolean equals(Object obj) {
        return obj instanceof FolderEntry && P4CoreUtils.equals((Object)this.parent, (Object)((FolderEntry)obj).getParent(obj)) && P4CoreUtils.equals((Object)this.name, (Object)((FolderEntry)obj).getLabel(obj)) && super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode() + P4CoreUtils.hashCode((Object)this.name) * 31 + P4CoreUtils.hashCode((Object)this.parent) * 11;
    }
}

