/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.folder.diff.viewer;

import com.perforce.p4java.core.IFileDiff;
import com.perforce.team.core.P4CoreUtils;
import com.perforce.team.core.folder.IP4DiffFile;
import com.perforce.team.ui.changelists.Folder;
import com.perforce.team.ui.folder.diff.editor.SubmittedChangelistWidget;
import com.perforce.team.ui.folder.diff.model.FileDiffContainer;
import com.perforce.team.ui.folder.diff.model.FileDiffElement;
import com.perforce.team.ui.folder.diff.model.GroupedDiffContainer;
import com.perforce.team.ui.folder.diff.viewer.DiffArea;
import com.perforce.team.ui.folder.diff.viewer.DiffViewer;
import com.perforce.team.ui.folder.diff.viewer.SynchronizedSlider;
import com.perforce.team.ui.folder.diff.viewer.TargetViewer;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridLayout;

public class TargetArea
extends DiffArea {
    private SynchronizedSlider slider = null;

    @Override
    protected void loadChangelist(Object element, SubmittedChangelistWidget changelistArea) {
        IP4DiffFile file;
        if (element instanceof FileDiffElement && (file = (IP4DiffFile)P4CoreUtils.convert((Object)element, IP4DiffFile.class)) != null) {
            element = file.getPair();
        }
        super.loadChangelist(element, changelistArea);
    }

    @Override
    protected DiffViewer createViewer() {
        return new TargetViewer();
    }

    @Override
    protected GridLayout createAreaLayout() {
        return GridLayoutFactory.swtDefaults().numColumns(2).margins(0, 0).spacing(0, 5).create();
    }

    @Override
    protected int getUniqueCount(FileDiffContainer container) {
        return container != null ? container.getRightUniqueCount() : 0;
    }

    @Override
    protected GroupedDiffContainer getGroupContainer(FileDiffContainer container) {
        return container != null ? container.getContainer(IFileDiff.Status.RIGHT_ONLY) : null;
    }

    @Override
    public void setContainer(FileDiffContainer container) {
        super.setContainer(container);
        if (this.slider != null) {
            this.slider.refresh();
        }
    }

    @Override
    public void setPair(DiffArea pair) {
        super.setPair(pair);
        if (pair != null) {
            TreeViewer diffViewer = this.getViewer().getViewer();
            TreeViewer pairViewer = pair.getViewer().getViewer();
            this.slider = new SynchronizedSlider(this.getArea());
            this.slider.setTrees(pairViewer.getTree(), diffViewer.getTree());
        }
    }

    public SynchronizedSlider getSlider() {
        return this.slider;
    }

    public void resetSlider() {
        if (this.slider != null) {
            this.slider.scrollToTop();
            this.slider.refresh();
        }
    }

    @Override
    public void setType(Folder.Type type) {
        super.setType(type);
        this.resetSlider();
    }
}

