/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.folder.diff.viewer;

import com.perforce.team.core.P4CoreUtils;
import com.perforce.team.core.folder.IP4DiffFile;
import com.perforce.team.ui.folder.diff.model.FileDiffElement;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class SynchronizedDiffer {
    private TreeViewer sourceViewer;
    private TreeViewer targetViewer;

    public SynchronizedDiffer(TreeViewer sourceViewer, TreeViewer targetViewer) {
        this.sourceViewer = sourceViewer;
        this.targetViewer = targetViewer;
        this.configure();
    }

    private void configure() {
        this.sourceViewer.addTreeListener((ITreeViewerListener)new ExpansionListener(this.targetViewer));
        this.targetViewer.addTreeListener((ITreeViewerListener)new ExpansionListener(this.sourceViewer));
        this.sourceViewer.addFilter((ViewerFilter)new DiffFilter(true));
        this.targetViewer.addFilter((ViewerFilter)new DiffFilter(false));
    }

    public static class DiffFilter
    extends ViewerFilter {
        private boolean source = true;

        public DiffFilter(boolean source) {
            this.source = source;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof FileDiffElement) {
                ICompareInput input = (ICompareInput)P4CoreUtils.convert((Object)element, ICompareInput.class);
                if (this.source) {
                    return input.getLeft() != null;
                }
                return input.getRight() != null;
            }
            return true;
        }
    }

    public static class ExpansionListener
    implements ITreeViewerListener {
        private TreeViewer viewer;

        public ExpansionListener(TreeViewer viewer) {
            this.viewer = viewer;
        }

        public void treeCollapsed(TreeExpansionEvent event) {
            IP4DiffFile pair;
            if (event.getElement() instanceof IP4DiffFile && (pair = ((IP4DiffFile)event.getElement()).getPair()) != null) {
                this.viewer.collapseToLevel((Object)pair, 1);
            }
        }

        public void treeExpanded(TreeExpansionEvent event) {
            IP4DiffFile pair;
            if (event.getElement() instanceof IP4DiffFile && (pair = ((IP4DiffFile)event.getElement()).getPair()) != null) {
                this.viewer.expandToLevel((Object)pair, -1);
            }
        }
    }
}

