/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.folder.diff.model;

import com.perforce.p4java.core.IFileDiff;
import com.perforce.team.core.folder.IP4DiffFile;
import com.perforce.team.core.p4java.P4Resource;
import com.perforce.team.ui.changelists.Folder;
import com.perforce.team.ui.folder.diff.model.FileEntry;
import com.perforce.team.ui.folder.diff.model.IGroupProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.PlatformUI;

public class GroupedDiffContainer {
    public static final Comparator<Object> SORTER = new Comparator<Object>(){

        @Override
        public int compare(Object e1, Object e2) {
            if (e1 instanceof Folder && e2 instanceof IP4DiffFile) {
                return -1;
            }
            if (e1 instanceof IP4DiffFile && e2 instanceof Folder) {
                return 1;
            }
            if (e1 instanceof Folder && e2 instanceof Folder) {
                return ((Folder)e1).getLabel(e1).compareTo(((Folder)e2).getLabel(e2));
            }
            if (e1 instanceof IP4DiffFile && e2 instanceof IP4DiffFile) {
                return ((IP4DiffFile)e1).getRemotePath().compareToIgnoreCase(((IP4DiffFile)e2).getRemotePath());
            }
            return 0;
        }
    };
    private Folder.Type type = null;
    private Folder[] tree;
    private Folder[] compressed;
    private IP4DiffFile[] flat;
    private Set<FileEntry> workingEntries = new LinkedHashSet<FileEntry>();

    public void finish() {
        FileEntry[] entries = this.workingEntries.toArray(new FileEntry[this.workingEntries.size()]);
        TreeSet<Object> flatList = new TreeSet<Object>(SORTER);
        for (FileEntry entry : this.workingEntries) {
            IP4DiffFile diff = entry.getFile();
            if (diff.getDiff().getStatus() == IFileDiff.Status.IDENTICAL) continue;
            flatList.add(diff);
        }
        this.flat = flatList.toArray(new IP4DiffFile[flatList.size()]);
        this.tree = new GroupFolderBuilder((Object[])entries, Folder.Type.TREE).build();
        this.compressed = new GroupFolderBuilder((Object[])entries, Folder.Type.COMPRESSED).build(true);
    }

    public void disposeWorkingEntries() {
        this.workingEntries.clear();
        this.workingEntries = null;
    }

    public void completeUniquePairs(GroupedDiffContainer pair) {
        Object[] compressed = pair.getElements(Folder.Type.COMPRESSED);
        Object[] tree = pair.getElements(Folder.Type.TREE);
        Object[] flat = pair.getElements(Folder.Type.FLAT);
        for (FileEntry entry : this.workingEntries) {
            String path;
            if (entry.getFile().getDiff().getStatus() == IFileDiff.Status.IDENTICAL || (path = entry.getVirtualPairPath()) == null) continue;
            DiffGroup group = (DiffGroup)entry.getProvider();
            Object uniquePair = this.findFolderPair(entry, path, compressed);
            if (uniquePair != null) {
                group.compressedPair = uniquePair;
            }
            if ((uniquePair = this.findFolderPair(entry, path, tree)) != null) {
                group.treePair = uniquePair;
            }
            if ((uniquePair = this.findFilePair(flat, path, true)) == null) continue;
            group.flatPair = uniquePair;
        }
    }

    private Object findFolderPair(FileEntry entry, String path, Object[] roots) {
        Object uniquePair = null;
        int lastSlash = path.lastIndexOf(47);
        if (lastSlash > 0 && lastSlash + 1 < path.length()) {
            String folderPath = path.substring(0, lastSlash);
            String name = path.substring(lastSlash + 1);
            Object[] objectArray = roots;
            int n = roots.length;
            int n2 = 0;
            while (n2 < n) {
                Object root = objectArray[n2];
                if (root instanceof Folder && (uniquePair = this.findFolderPair((Folder)root, name, folderPath)) != null) break;
                ++n2;
            }
        }
        return uniquePair;
    }

    private Object getLastChild(Folder folder) {
        Object last = null;
        Object[] children = folder.getChildren((Object)folder);
        if (children.length > 0) {
            last = children[children.length - 1];
        }
        if (last instanceof Folder) {
            last = this.getLastChild((Folder)last);
        }
        if (last == null) {
            last = folder;
        }
        return last;
    }

    private Object findFilePair(Object[] children, String name, boolean comparePath) {
        Object pair = null;
        Object[] objectArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Object child = objectArray[n2];
            if (child instanceof IP4DiffFile) {
                String compare;
                String string = compare = comparePath ? ((IP4DiffFile)child).getRemotePath() : ((IP4DiffFile)child).getName();
                if (name.compareToIgnoreCase(compare) > 0) {
                    pair = child;
                }
            } else if (child instanceof Folder) {
                pair = this.getLastChild((Folder)child);
            }
            ++n2;
        }
        return pair;
    }

    private Object findFolderPair(Folder folder, String name, String path) {
        Object pair = null;
        String folderPath = folder.getPath();
        if (path.equals(folderPath)) {
            pair = folder;
            Object betterMatch = this.findFilePair(folder.getChildren((Object)folder), name, false);
            if (betterMatch != null) {
                pair = betterMatch;
            }
        } else if (folderPath.startsWith(path)) {
            pair = folder;
        } else if (path.startsWith(String.valueOf(folderPath) + "/")) {
            pair = folder;
            Object betterMatch = null;
            String folderName = path.substring(folderPath.length() + 1);
            int lastSlash = folderName.indexOf(47);
            if (lastSlash != -1) {
                folderName = folderName.substring(0, lastSlash);
            }
            Folder currentFolder = null;
            Object[] objectArray = folder.getChildren((Object)folder);
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                if (child instanceof Folder) {
                    currentFolder = (Folder)child;
                    betterMatch = this.findFolderPair(currentFolder, name, path);
                    if (betterMatch != null) {
                        pair = betterMatch;
                        break;
                    }
                    if (folderName.compareToIgnoreCase(currentFolder.getLabel(child)) > 0) {
                        pair = this.getLastChild(currentFolder);
                    }
                }
                ++n2;
            }
        }
        return pair;
    }

    public void setType(Folder.Type type) {
        this.type = type;
    }

    public Object[] getElements(Folder.Type type) {
        if (type != null) {
            switch (type) {
                case FLAT: {
                    return this.flat;
                }
                case TREE: {
                    return this.tree;
                }
                case COMPRESSED: {
                    return this.compressed;
                }
            }
        }
        return P4Resource.EMPTY;
    }

    public Object[] getElements() {
        return this.getElements(this.type);
    }

    public FileEntry add(IP4DiffFile entry) {
        FileEntry fileEntry = new FileEntry(entry, new DiffGroup());
        this.workingEntries.add(fileEntry);
        return fileEntry;
    }

    private class DiffGroup
    implements IGroupProvider {
        private Object treeParent = null;
        private Object compressedParent = null;
        private Object treePair = null;
        private Object compressedPair = null;
        private Object flatPair = null;

        private DiffGroup() {
        }

        @Override
        public Object getParent(FileEntry entry) {
            Folder.Type parentType = this.getType();
            if (parentType != null) {
                switch (parentType) {
                    case TREE: {
                        return this.treeParent;
                    }
                    case COMPRESSED: {
                        return this.compressedParent;
                    }
                }
            }
            return null;
        }

        @Override
        public Folder.Type getType() {
            return GroupedDiffContainer.this.type;
        }

        @Override
        public Object getUniquePair(FileEntry entry) {
            Folder.Type parentType = this.getType();
            if (parentType != null) {
                switch (parentType) {
                    case TREE: {
                        return this.treePair;
                    }
                    case COMPRESSED: {
                        return this.compressedPair;
                    }
                    case FLAT: {
                        return this.flatPair;
                    }
                }
            }
            return null;
        }
    }

    public static class GroupFolder
    extends Folder {
        private boolean finished = false;
        private boolean project = false;

        public GroupFolder(Folder parent, String path, Folder.Type type) {
            super(parent, path, type);
        }

        public boolean equals(Object obj) {
            return obj instanceof GroupFolder && super.equals(obj);
        }

        public int hashCode() {
            return super.hashCode();
        }

        public void remove(Object child) {
            if (!this.finished) {
                super.remove(child);
            }
        }

        private void replace() {
            GroupFolder parent;
            if (!(this.containsFiles() && this.containsFolders() || (parent = (GroupFolder)((Object)this.getParent((Object)this))) == null)) {
                parent.remove((Object)this);
            }
            ArrayList<Object> validChildren = new ArrayList<Object>();
            Object[] objectArray = this.getChildren((Object)this);
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                if (child instanceof FileEntry) {
                    validChildren.add(((FileEntry)((Object)child)).getFile());
                } else if (child instanceof GroupFolder) {
                    GroupFolder sub = (GroupFolder)((Object)child);
                    sub.replace();
                    if (sub.containsFiles() || sub.containsFolders()) {
                        validChildren.add((Object)sub);
                    }
                }
                ++n2;
            }
            this.finished = true;
            this.children.clear();
            Collections.sort(validChildren, SORTER);
            this.children = validChildren;
        }

        public void add(Object child) {
            if (!this.finished) {
                if (child instanceof FileEntry) {
                    FileEntry entry = (FileEntry)((Object)child);
                    if (!this.project && ".project".equals(entry.getLabel((Object)entry))) {
                        this.project = true;
                    }
                    if (entry.getFile().getDiff().getStatus() != IFileDiff.Status.IDENTICAL) {
                        switch (this.type) {
                            case TREE: {
                                ((DiffGroup)entry.getProvider()).treeParent = (Object)this;
                                break;
                            }
                            case COMPRESSED: {
                                ((DiffGroup)entry.getProvider()).compressedParent = (Object)this;
                            }
                        }
                        super.add(child);
                    }
                } else {
                    super.add(child);
                }
            }
        }

        public boolean canCompress() {
            if (this.isProject()) {
                return false;
            }
            if (this.folderCount == 1 && this.childCount == 0) {
                return !((GroupFolder)((Object)this.children.get(0))).isProject();
            }
            return super.canCompress();
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            if (this.isProject()) {
                return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_PROJECT");
            }
            return super.getImageDescriptor(object);
        }

        public boolean isProject() {
            return this.project;
        }
    }

    private class GroupFolderBuilder
    extends Folder.FolderBuilder {
        public GroupFolderBuilder(Object[] files, Folder.Type type) {
            super(files, type);
        }

        protected Folder createFolder(Folder parent, String path, Folder.Type type) {
            return new GroupFolder(parent, path, type);
        }

        public Folder[] build(boolean compress) {
            Folder[] folders;
            Folder[] folderArray = folders = super.build(compress);
            int n = folders.length;
            int n2 = 0;
            while (n2 < n) {
                Folder folder = folderArray[n2];
                ((GroupFolder)folder).replace();
                ++n2;
            }
            return folders;
        }
    }
}

