/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.folder.diff.editor;

import com.perforce.p4java.core.IChangelist;
import com.perforce.team.core.p4java.IP4Revision;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.folder.diff.editor.Messages;
import com.perforce.team.ui.p4java.actions.ViewChangelistAction;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class SubmittedChangelistWidget {
    public static final String REMOTE_USER = "remote";
    private IP4Revision revision = null;
    private Composite displayArea;
    private Hyperlink changelistLink;
    private StyledText detailsText;
    private SourceViewer descriptionText;

    public SubmittedChangelistWidget(Composite parent, FormToolkit toolkit) {
        this.displayArea = toolkit.createComposite(parent);
        toolkit.adapt((Control)this.displayArea, false, false);
        this.displayArea.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(2).create());
        this.displayArea.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.changelistLink = toolkit.createHyperlink(this.displayArea, "", 0);
        this.changelistLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                if (SubmittedChangelistWidget.this.revision != null) {
                    ViewChangelistAction view = new ViewChangelistAction();
                    view.view(SubmittedChangelistWidget.this.revision.getChangelist(), SubmittedChangelistWidget.this.revision.getConnection(), IChangelist.Type.SUBMITTED);
                }
            }
        });
        this.detailsText = new StyledText(this.displayArea, 0);
        this.detailsText.setEditable(false);
        final Caret caret = new Caret((Canvas)this.detailsText, 0);
        caret.setSize(0, 0);
        this.detailsText.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                caret.dispose();
            }
        });
        this.detailsText.setCaret(caret);
        this.detailsText.setLayoutData((Object)GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).create());
        this.descriptionText = new SourceViewer(this.displayArea, null, 2826);
        this.descriptionText.setDocument((IDocument)new Document());
        this.descriptionText.getTextWidget().setFont(JFaceResources.getFont((String)"org.eclipse.jface.textfont"));
        this.descriptionText.getTextWidget().setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).hint(-1, 80).span(2, 1).create());
        IAdaptable adaptable = new IAdaptable(){

            public Object getAdapter(Class adapter) {
                IP4Revision adaptableRevision = SubmittedChangelistWidget.this.revision;
                return adaptableRevision != null ? Platform.getAdapterManager().getAdapter((Object)adaptableRevision, adapter) : null;
            }
        };
        this.descriptionText.configure((SourceViewerConfiguration)P4UIUtils.createSourceViewerConfiguration((IAdaptable)adaptable));
    }

    public void setRevision(IP4Revision revision) {
        this.revision = revision;
        if (revision != null) {
            this.changelistLink.setText(MessageFormat.format(Messages.SubmittedChangelistWidget_Changelist, Integer.toString(revision.getChangelist())));
            this.changelistLink.setEnabled(!REMOTE_USER.equals(revision.getAuthor()));
            String details = MessageFormat.format(Messages.SubmittedChangelistWidget_Author, revision.getAuthor(), revision.getClient(), P4UIUtils.formatLabelDate((long)revision.getTimestamp()));
            this.detailsText.setText(details);
            this.descriptionText.getDocument().set(revision.getComment());
        } else {
            this.changelistLink.setText("");
            this.detailsText.setText("");
            this.descriptionText.getDocument().set("");
        }
        this.displayArea.layout(true, true);
    }
}

