/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.folder.diff.editor;

import com.perforce.p4java.core.IFileDiff;
import com.perforce.p4java.core.file.FileAction;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.team.core.P4CoreUtils;
import com.perforce.team.core.folder.IP4DiffFile;
import com.perforce.team.core.p4java.IP4Revision;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.decorator.P4Decoration;
import com.perforce.team.ui.decorator.PerforceDecorator;
import com.perforce.team.ui.folder.PerforceUiFolderPlugin;
import com.perforce.team.ui.folder.diff.model.FileDiffElement;
import java.util.HashMap;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorDecorator;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class FileDiffDecorator
extends PerforceDecorator
implements IColorDecorator {
    private Color contentColor;
    private Color uniqueColor;
    private Color diffContentColor;
    private Color diffUniqueColor;

    public FileDiffDecorator(boolean decorateResources) {
        super(decorateResources);
        PerforceUiFolderPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        this.loadColors();
    }

    private void loadColors() {
        if (this.contentColor != null) {
            this.contentColor.dispose();
        }
        if (this.uniqueColor != null) {
            this.uniqueColor.dispose();
        }
        if (this.diffContentColor != null) {
            this.diffContentColor.dispose();
        }
        if (this.diffUniqueColor != null) {
            this.diffUniqueColor.dispose();
        }
        IPreferenceStore store = PerforceUiFolderPlugin.getDefault().getPreferenceStore();
        Display display = P4UIUtils.getDisplay();
        this.contentColor = new Color((Device)display, PreferenceConverter.getColor((IPreferenceStore)store, (String)"CONTENT_COLOR"));
        this.uniqueColor = new Color((Device)display, PreferenceConverter.getColor((IPreferenceStore)store, (String)"UNIQUE_COLOR"));
        this.diffContentColor = new Color((Device)display, PreferenceConverter.getColor((IPreferenceStore)store, (String)"DIFF_CONTENT_COLOR"));
        this.diffUniqueColor = new Color((Device)display, PreferenceConverter.getColor((IPreferenceStore)store, (String)"DIFF_UNIQUE_COLOR"));
    }

    public void dispose() {
        super.dispose();
        this.contentColor.dispose();
        this.uniqueColor.dispose();
        PerforceUiFolderPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }

    public String decorateDiffFile(String text, IP4DiffFile diffFile) {
        HashMap<String, String> bindings = new HashMap<String, String>();
        IFileSpec spec = diffFile.getFile().getP4JFile();
        if (spec != null) {
            FileAction action;
            IP4Revision revision;
            String type;
            int have = spec.getEndRevision();
            if (have > 0) {
                bindings.put("have", Integer.toString(have));
            }
            if ((type = spec.getFileType()) != null) {
                bindings.put("type", type);
            }
            if ((revision = (IP4Revision)P4CoreUtils.convert((Object)diffFile, IP4Revision.class)) != null && (action = revision.getAction()) != null) {
                bindings.put("action", action.toString().toLowerCase());
            }
            bindings.put("name", text);
        }
        StringBuilder decorated = P4Decoration.decorate((String)this.fileDecoration, bindings);
        return FileDiffDecorator.removeTrailingWhitespace((StringBuilder)decorated);
    }

    public Image decorateImage(Image image, Object o) {
        return image;
    }

    public String decorateText(String text, Object o) {
        String decorated = null;
        decorated = o instanceof IP4DiffFile ? this.decorateDiffFile(text, (IP4DiffFile)o) : super.decorateText(text, o);
        return decorated;
    }

    public Color decorateForeground(Object element) {
        return null;
    }

    public Color decorateBackground(Object element) {
        if (element instanceof IP4DiffFile) {
            IP4DiffFile file = (IP4DiffFile)element;
            IFileDiff.Status status = file.getDiff().getStatus();
            if (status == IFileDiff.Status.CONTENT) {
                return this.contentColor;
            }
            if (status == IFileDiff.Status.LEFT_ONLY || status == IFileDiff.Status.RIGHT_ONLY) {
                return this.uniqueColor;
            }
        } else if (element instanceof FileDiffElement) {
            switch (((FileDiffElement)((Object)element)).getElement().getKind()) {
                case 1: 
                case 2: {
                    return this.diffUniqueColor;
                }
                case 3: {
                    return this.diffContentColor;
                }
            }
        }
        return null;
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if ("UNIQUE_COLOR".equals(property) || "CONTENT_COLOR".equals(property) || "DIFF_CONTENT_COLOR".equals(property) || "DIFF_UNIQUE_COLOR".equals(property)) {
            this.loadColors();
            this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this));
        } else {
            super.propertyChange(event);
        }
    }

    public String getName() {
        return String.valueOf(FileDiffDecorator.class.getSimpleName()) + ":" + super.getName();
    }
}

