/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.folder.diff.actions;

import com.perforce.team.core.p4java.IP4Folder;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.ui.P4ConnectionManager;
import com.perforce.team.ui.folder.diff.actions.DiffFoldersAction;
import com.perforce.team.ui.folder.diff.editor.input.ContainerDiffInput;
import com.perforce.team.ui.folder.diff.editor.input.IFolderDiffInput;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;

public class DiffContainersAction
extends DiffFoldersAction {
    private IContainer leftContainer;
    private IP4Folder leftFolder;
    private IContainer rightContainer;
    private IP4Folder rightFolder;

    private IP4Folder[] getContainerFolders(IContainer left, IContainer right) {
        IP4Resource rightResource;
        if (left == null || right == null) {
            return null;
        }
        IP4Resource leftResource = P4ConnectionManager.getManager().getResource((IResource)left);
        if (leftResource instanceof IP4Folder && (rightResource = P4ConnectionManager.getManager().getResource((IResource)right)) instanceof IP4Folder) {
            return new IP4Folder[]{(IP4Folder)leftResource, (IP4Folder)rightResource};
        }
        return null;
    }

    @Override
    protected IP4Folder[] getFolders() {
        List resources = this.getLocalResourceSelection();
        if (resources != null) {
            IP4Folder[] folders;
            if (resources.size() == 1) {
                IResource both = (IResource)resources.get(0);
                if (both instanceof IContainer) {
                    this.rightContainer = this.leftContainer = (IContainer)both;
                }
            } else if (resources.size() == 2) {
                IResource left = (IResource)resources.get(0);
                IResource right = (IResource)resources.get(1);
                if (left instanceof IContainer && right instanceof IContainer) {
                    this.leftContainer = (IContainer)left;
                    this.rightContainer = (IContainer)right;
                }
            }
            if ((folders = this.getContainerFolders(this.leftContainer, this.rightContainer)) != null) {
                this.leftFolder = folders[0];
                this.rightFolder = folders[1];
            }
            return folders;
        }
        return null;
    }

    @Override
    protected IFolderDiffInput generateInput(IP4Folder folder1, IP4Folder folder2) {
        ContainerDiffInput input = new ContainerDiffInput(folder1.getConnection());
        if (folder1 == this.leftFolder) {
            input.setLeftContainer(this.leftContainer);
        }
        if (folder1 == this.rightFolder) {
            input.setRightContainer(this.rightContainer);
        }
        input.addPaths(folder1.getActionPath(), folder2.getActionPath());
        return input;
    }
}

