/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.views;

import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Container;
import com.perforce.team.core.p4java.IP4Job;
import com.perforce.team.core.p4java.IP4Listener;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.IP4SubmittedChangelist;
import com.perforce.team.core.p4java.IP4SubmittedFile;
import com.perforce.team.core.p4java.P4Event;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.core.p4java.P4Runner;
import com.perforce.team.core.p4java.P4Workspace;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.changelists.OpenChangelistDialog;
import com.perforce.team.ui.jobs.JobsWidget;
import com.perforce.team.ui.p4java.actions.EditJobAction;
import com.perforce.team.ui.p4java.actions.ViewChangelistAction;
import com.perforce.team.ui.submitted.ISubmittedChangelistListener;
import com.perforce.team.ui.submitted.OpenEditorAction;
import com.perforce.team.ui.submitted.SubmittedChangelistTable;
import com.perforce.team.ui.views.IPerforceView;
import com.perforce.team.ui.views.Messages;
import com.perforce.team.ui.views.PerforceFilterViewControl;
import com.perforce.team.ui.views.PerforceProjectView;
import com.perforce.team.ui.views.SubmittedDropAdapter;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.progress.UIJob;

public class SubmittedViewControl
extends PerforceFilterViewControl
implements IPropertyChangeListener,
IDoubleClickListener {
    public static final String DISPLAY_DETAILS = "com.perforce.team.ui.submitted.display_details";
    public static final String HIDE_FILTERS = "com.perforce.team.ui.submitted.HIDE_FILTERS";
    private SubmittedChangelistTable submittedTable = null;
    private Action refreshAction;
    private Action showDetailsAction;
    private Action linkWithDepotView;
    private Action openPrefs;
    private Action openJobAction;
    private Action openChangelistAction;
    private Action openByIdAction;
    private boolean link = false;
    private IP4Resource p4Resource = null;
    private ISubmittedChangelistListener listener = new ISubmittedChangelistListener(){

        @Override
        public void changelistsLoaded(IP4SubmittedChangelist[] lists) {
            if (SubmittedViewControl.this.refreshAction != null) {
                SubmittedViewControl.this.refreshAction.setEnabled(true);
            }
            if (SubmittedViewControl.this.openByIdAction != null) {
                SubmittedViewControl.this.openByIdAction.setEnabled(true);
            }
        }
    };
    private IP4Listener resourceListener = new IP4Listener(){

        public void resoureChanged(P4Event event) {
            IP4SubmittedChangelist[] submitted;
            if ((event.getType() == P4Event.EventType.FIXED || event.getType() == P4Event.EventType.UNFIXED) && (submitted = SubmittedViewControl.this.getAffectedLists(event.getJobs())).length > 0) {
                UIJob job = new UIJob(Messages.SubmittedView_UpdateSubmittedChangelistsView){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        Composite control = SubmittedViewControl.this.submittedTable.getControl();
                        if (control != null && !control.isDisposed()) {
                            SubmittedViewControl.this.handleUpdate(submitted);
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.schedule();
            }
        }

        public String getName() {
            return SubmittedViewControl.this.getClass().getSimpleName();
        }
    };

    private IP4SubmittedChangelist[] getAffectedLists(IP4Job[] jobs) {
        ArrayList<IP4SubmittedChangelist> connectionChanges = new ArrayList<IP4SubmittedChangelist>();
        if (this.p4Resource != null) {
            IP4Connection connection = this.p4Resource.getConnection();
            IP4Job[] iP4JobArray = jobs;
            int n = jobs.length;
            int n2 = 0;
            while (n2 < n) {
                IP4Container parent;
                IP4Job job = iP4JobArray[n2];
                if (connection.equals(job.getConnection()) && (parent = job.getParent()) instanceof IP4SubmittedChangelist && !connectionChanges.contains(parent)) {
                    connectionChanges.add((IP4SubmittedChangelist)parent);
                }
                ++n2;
            }
        }
        return connectionChanges.toArray(new IP4SubmittedChangelist[connectionChanges.size()]);
    }

    private void handleUpdate(IP4SubmittedChangelist[] lists) {
        IP4SubmittedChangelist[] iP4SubmittedChangelistArray = lists;
        int n = lists.length;
        int n2 = 0;
        while (n2 < n) {
            IP4SubmittedChangelist list = iP4SubmittedChangelistArray[n2];
            this.submittedTable.refresh(list);
            ++n2;
        }
    }

    public boolean okToUse() {
        return this.submittedTable != null && this.submittedTable.okToUse();
    }

    public SubmittedViewControl(IPerforceView view) {
        super(view);
    }

    @Override
    public void setFocus() {
        Tree control = this.submittedTable.getTree();
        if (control != null) {
            control.setFocus();
        }
    }

    @Override
    public void dispose() {
        P4Workspace.getWorkspace().removeListener(this.resourceListener);
        if (this.submittedTable != null) {
            this.submittedTable.dispose();
        }
        this.removeProjectListeners();
        IPreferenceStore store = SubmittedViewControl.getPreferenceStore();
        store.removePropertyChangeListener((IPropertyChangeListener)this);
    }

    @Override
    public void refresh() {
        if (this.submittedTable != null) {
            this.submittedTable.refresh();
        }
    }

    @Override
    protected String getFilterPreference() {
        return HIDE_FILTERS;
    }

    @Override
    protected String getSelectedName() {
        return Messages.SubmittedView_SubmittedChangelists;
    }

    @Override
    protected void createControl(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.perforce.team.ui.submitted_view");
        this.submittedTable = new SubmittedChangelistTable(PerforceProjectView.getItems("com.perforce.team.ui.submitted.FILE_FOLDER_HISTORY"), PerforceProjectView.getItems("com.perforce.team.ui.submitted.USER_HISTORY"), PerforceProjectView.getItems("com.perforce.team.ui.submitted.WORKSPACE_HISTORY"), true);
        this.setFilterViewer(this.submittedTable);
        this.submittedTable.createPartControl(parent, this.listener);
        this.submittedTable.getViewer().addDoubleClickListener((IDoubleClickListener)this);
        this.submittedTable.getViewer().addDropSupport(23, new Transfer[]{ResourceTransfer.getInstance(), FileTransfer.getInstance(), LocalSelectionTransfer.getTransfer()}, (DropTargetListener)new SubmittedDropAdapter(this));
        this.createMenus();
        this.showNoConnection();
        this.addProjectListeners();
        IPreferenceStore store = SubmittedViewControl.getPreferenceStore();
        store.addPropertyChangeListener((IPropertyChangeListener)this);
        P4Workspace.getWorkspace().addListener(this.resourceListener);
    }

    private Object getSingleObjectSelection() {
        Object selected = null;
        IStructuredSelection selection = (IStructuredSelection)this.submittedTable.getViewer().getSelection();
        if (selection.size() == 1) {
            selected = selection.getFirstElement();
        }
        return selected;
    }

    private void createJobActions() {
        this.openJobAction = new Action(Messages.SubmittedView_EditJob){

            public void run() {
                Object selected = SubmittedViewControl.this.getSingleObjectSelection();
                if (selected instanceof IP4Job) {
                    EditJobAction action = new EditJobAction();
                    action.selectionChanged(null, (ISelection)new StructuredSelection(selected));
                    action.doubleClick(null);
                }
            }
        };
    }

    private void createSubmittedActions() {
        this.openChangelistAction = new Action(Messages.SubmittedView_ViewChangelist){

            public void run() {
                Object selected = SubmittedViewControl.this.getSingleObjectSelection();
                if (selected instanceof IP4SubmittedChangelist) {
                    ViewChangelistAction action = new ViewChangelistAction();
                    action.selectionChanged(null, (ISelection)new StructuredSelection(selected));
                    action.run(null);
                }
            }
        };
        this.openByIdAction = new Action(Messages.SubmittedView_OpenChangelist, PerforceUIPlugin.getDescriptor("perforce/submitted_editor.png")){

            public void run() {
                int id;
                if (SubmittedViewControl.this.p4Connection == null) {
                    return;
                }
                OpenChangelistDialog dialog = new OpenChangelistDialog(SubmittedViewControl.this.displayArea.getShell(), Messages.SubmittedView_OpenSubmittedChangelist);
                if (dialog.open() == 0 && (id = dialog.getId()) > 0) {
                    ViewChangelistAction action = new ViewChangelistAction();
                    action.view(id, SubmittedViewControl.this.p4Connection);
                }
            }
        };
    }

    private void createMenus() {
        this.createJobActions();
        this.createSubmittedActions();
        PerforceUIPlugin plugin = PerforceUIPlugin.getPlugin();
        this.refreshAction = new Action(Messages.SubmittedView_Refresh, plugin.getImageDescriptor("enabled/refresh.png")){

            public void run() {
                if (SubmittedViewControl.this.submittedTable != null) {
                    SubmittedViewControl.this.submittedTable.refresh();
                }
            }
        };
        this.refreshAction.setToolTipText(Messages.SubmittedView_RefreshSubmittedChangelists);
        this.refreshAction.setDisabledImageDescriptor(plugin.getImageDescriptor("disabled/refresh.png"));
        this.refreshAction.setHoverImageDescriptor(plugin.getImageDescriptor("normal/refresh.png"));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this.refreshAction, "com.perforce.team.ui.submitted_refresh");
        this.link = SubmittedViewControl.getPreferenceStore().getBoolean("com.perforce.team.ui.preferences.LINK_SUBMITTED");
        this.linkWithDepotView = new Action(Messages.SubmittedView_LinkWithConnectionsView, 2){

            public void run() {
                SubmittedViewControl.this.link = SubmittedViewControl.this.linkWithDepotView.isChecked();
                SubmittedViewControl.getPreferenceStore().setValue("com.perforce.team.ui.preferences.LINK_SUBMITTED", SubmittedViewControl.this.link);
            }
        };
        this.linkWithDepotView.setImageDescriptor(PerforceUIPlugin.getPlugin().getImageDescriptor("normal/link.png"));
        this.linkWithDepotView.setChecked(this.link);
        this.openPrefs = new Action(Messages.SubmittedView_OpenChangelistPreferences, plugin.getImageDescriptor("views/preferences.png")){

            public void run() {
                P4UIUtils.openPreferencePage("com.perforce.team.ui.dialogs.ChangesPreferencesDialog");
            }
        };
        this.showDetailsAction = new Action(Messages.SubmittedView_ShowChangelistDetails){

            public int getStyle() {
                return 2;
            }
        };
        this.showDetailsAction.setChecked(plugin.getPreferenceStore().getBoolean(DISPLAY_DETAILS));
        this.showDetailsAction.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                SubmittedViewControl.getPreferenceStore().setValue(SubmittedViewControl.DISPLAY_DETAILS, SubmittedViewControl.this.showDetailsAction.isChecked());
                SubmittedViewControl.this.submittedTable.showDisplayDetails(SubmittedViewControl.this.showDetailsAction.isChecked());
            }
        });
        this.submittedTable.showDisplayDetails(this.showDetailsAction.isChecked());
        TreeViewer viewer = this.submittedTable.getViewer();
        MenuManager manager = new MenuManager();
        Menu menu = manager.createContextMenu(viewer.getControl());
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IAction)SubmittedViewControl.this.refreshAction);
                manager.add((IContributionItem)new Separator("additions"));
            }
        });
        manager.setRemoveAllWhenShown(true);
        viewer.getControl().setMenu(menu);
        this.registerContextMenu(manager, (ISelectionProvider)viewer);
        JobsWidget jobsWidget = this.submittedTable.getChangelistWidget().getJobsWidget();
        if (jobsWidget != null) {
            TreeViewer jobViewer = jobsWidget.getViewer();
            MenuManager jobManager = new MenuManager();
            Menu jobMenu = jobManager.createContextMenu(jobViewer.getControl());
            jobViewer.getControl().setMenu(jobMenu);
            this.registerContextMenu(jobManager, (ISelectionProvider)jobViewer);
        }
        TreeViewer fileViewer = this.submittedTable.getChangelistWidget().getFilesWidget().getViewer();
        MenuManager fileManager = new MenuManager();
        Menu fileMenu = fileManager.createContextMenu(fileViewer.getControl());
        fileViewer.getControl().setMenu(fileMenu);
        this.registerContextMenu(fileManager, (ISelectionProvider)fileViewer);
        IActionBars bars = this.getActionBars();
        if (bars != null) {
            IToolBarManager tbm = bars.getToolBarManager();
            tbm.add((IAction)this.refreshAction);
            tbm.add((IAction)this.openByIdAction);
            tbm.add((IAction)this.linkWithDepotView);
            tbm.add((IAction)this.openPrefs);
            tbm.update(false);
            IMenuManager pulldown = bars.getMenuManager();
            pulldown.add((IAction)this.showDetailsAction);
            this.createFilterAction((IContributionManager)pulldown);
            pulldown.update(false);
        }
    }

    @Override
    protected void setViewerInput(IP4Connection connection) {
        if (this.connectionOK(connection)) {
            this.p4Resource = connection;
            this.p4Connection = connection;
            this.updateConnectionLabel();
            this.updateChangelists();
        } else {
            this.showNoConnection();
        }
    }

    private void updateChangelists() {
        this.submittedTable.setResource(this.p4Resource);
        this.submittedTable.clearFilters();
        this.showDisplayArea();
        this.submittedTable.updateChangelists();
    }

    @Override
    protected void showNoConnection() {
        super.showNoConnection();
        this.refreshAction.setEnabled(false);
        this.openByIdAction.setEnabled(false);
        this.submittedTable.getViewer().setInput(null);
        this.p4Resource = null;
        this.submittedTable.setResource(this.p4Resource);
        this.submittedTable.clearDetailsPanel();
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if (property == "pref_retrieve_num_changes" && this.submittedTable != null) {
            this.submittedTable.updateMoreLink();
        }
    }

    public TreeViewer getViewer() {
        if (this.submittedTable != null) {
            return this.submittedTable.getViewer();
        }
        return null;
    }

    public String getChangeDetails() {
        return this.submittedTable.getChangeDetails();
    }

    public String getDateDetails() {
        return this.submittedTable.getDateDetails();
    }

    public String getClientDetails() {
        return this.submittedTable.getClientDetails();
    }

    public String getUserDetail() {
        return this.submittedTable.getUserDetail();
    }

    public String getDescriptionDetail() {
        return this.submittedTable.getDescriptionDetail();
    }

    public void showChangelists(IP4Resource resource) {
        if (!this.okToUse()) {
            return;
        }
        if (resource != null && resource.getConnection() != null && !resource.getConnection().isOffline()) {
            this.p4Resource = resource;
            this.p4Connection = resource.getConnection();
            this.submittedTable.setResource(this.p4Resource);
            this.updateConnectionLabel();
            this.showDisplayArea();
            this.submittedTable.showChangelists(this.p4Resource);
        } else {
            this.p4Resource = null;
            this.submittedTable.setResource(this.p4Resource);
            this.submittedTable.showChangelists(null);
            this.showNoConnection();
        }
    }

    public void scheduleShowChangelists(final IP4Resource resource) {
        UIJob job = new UIJob(Messages.SubmittedView_UpdatingSubmittedChangelists){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                SubmittedViewControl.this.showChangelists(resource);
                return Status.OK_STATUS;
            }
        };
        job.setRule(RULE);
        job.schedule();
    }

    public IP4SubmittedChangelist[] getChangelists() {
        if (this.submittedTable != null) {
            return this.submittedTable.getChangelists();
        }
        return null;
    }

    @Override
    public void selectionChanged(IWorkbenchPart part, final ISelection selection) {
        P4Runner.schedule((IP4Runnable)new P4Runnable(){

            public void run(IProgressMonitor monitor) {
                if (selection instanceof IStructuredSelection) {
                    Object original = ((IStructuredSelection)selection).getFirstElement();
                    Object element = original;
                    if (!(element instanceof IP4Resource)) {
                        element = SubmittedViewControl.this.getP4Resource(element);
                    }
                    if (SubmittedViewControl.this.p4Resource != element && element instanceof IP4Resource) {
                        if (SubmittedViewControl.this.link && original instanceof IP4Resource) {
                            final IP4Resource resourceElement = (IP4Resource)element;
                            PerforceUIPlugin.syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    SubmittedViewControl.this.showChangelists(resourceElement);
                                }
                            });
                        } else {
                            final IP4Connection newConnection = ((IP4Resource)element).getConnection();
                            if (SubmittedViewControl.this.p4Resource != null) {
                                IP4Connection current = SubmittedViewControl.this.p4Resource.getConnection();
                                if (newConnection != null && !newConnection.equals(current)) {
                                    PerforceUIPlugin.syncExec(new Runnable(){

                                        @Override
                                        public void run() {
                                            SubmittedViewControl.this.setViewerInput(newConnection);
                                        }
                                    });
                                }
                            } else {
                                PerforceUIPlugin.syncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        SubmittedViewControl.this.setViewerInput(newConnection);
                                    }
                                });
                            }
                        }
                    }
                }
            }
        }, (ISchedulingRule)RULE);
    }

    public void showDisplayDetails(boolean show) {
        this.submittedTable.showDisplayDetails(show);
    }

    public boolean isLoading() {
        return this.submittedTable != null && this.submittedTable.isLoading();
    }

    @Override
    public void showMore() {
        if (this.submittedTable != null) {
            this.submittedTable.showMore();
        }
    }

    public SubmittedChangelistTable getChangelistTable() {
        return this.submittedTable;
    }

    public void doubleClick(DoubleClickEvent event) {
        Object selected = this.getSingleObjectSelection();
        if (selected instanceof IP4Job) {
            this.openJobAction.run();
        } else if (selected instanceof IP4SubmittedFile) {
            OpenEditorAction open = new OpenEditorAction();
            open.selectionChanged(null, (ISelection)new StructuredSelection(selected));
            open.run(null);
        } else if (selected instanceof IP4SubmittedChangelist) {
            this.openChangelistAction.run();
        }
    }

    public void enableDoubleClick(boolean enable) {
        if (enable) {
            this.submittedTable.getViewer().addDoubleClickListener((IDoubleClickListener)this);
        } else {
            this.submittedTable.getViewer().removeDoubleClickListener((IDoubleClickListener)this);
        }
    }
}

