/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.views;

import com.perforce.team.ui.viewer.IFilterViewer;
import com.perforce.team.ui.views.AbstractPerforceViewControl;
import com.perforce.team.ui.views.HideFilterAction;
import com.perforce.team.ui.views.IFilterView;
import com.perforce.team.ui.views.IPerforceView;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;

public abstract class PerforceFilterViewControl
extends AbstractPerforceViewControl
implements IFilterView {
    private IFilterViewer filterViewer = null;
    private HideFilterAction hideFilters = null;

    public PerforceFilterViewControl(IPerforceView view) {
        super(view);
    }

    protected void createFilterAction(IContributionManager manager) {
        this.hideFilters = new HideFilterAction(this.getFilterPreference(), this);
        if (manager != null) {
            manager.add((IAction)this.hideFilters);
        }
    }

    protected void setFilterViewer(IFilterViewer viewer) {
        this.filterViewer = viewer;
    }

    protected abstract String getFilterPreference();

    @Override
    protected void showDisplayArea(boolean layout) {
        super.showDisplayArea(layout);
        if (layout && this.hideFilters != null) {
            this.showFilters(!this.hideFilters.isChecked());
        }
    }

    @Override
    public void showFilters(boolean show) {
        if (this.filterViewer != null && this.layout) {
            this.filterViewer.showFilters(show, true);
        }
    }
}

