/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.views;

import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.team.core.P4CoreUtils;
import com.perforce.team.core.p4java.IP4Changelist;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4Job;
import com.perforce.team.core.p4java.IP4PendingChangelist;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.IP4ShelveFile;
import com.perforce.team.core.p4java.IP4ShelvedChangelist;
import com.perforce.team.core.p4java.P4Collection;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.core.p4java.P4Runner;
import com.perforce.team.ui.P4ConnectionManager;
import com.perforce.team.ui.views.DragData;
import com.perforce.team.ui.views.Messages;
import com.perforce.team.ui.views.PendingDragAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.ui.part.ResourceTransfer;

public class PendingDropAdapter
extends ViewerDropAdapter {
    private IP4PendingChangelist currentTarget;
    private IP4ShelvedChangelist shelvedTarget;
    private boolean unshelve = false;
    private TransferData currentTransfer;
    private boolean async = true;

    public PendingDropAdapter(Viewer viewer, boolean async) {
        super(viewer);
        this.setScrollExpandEnabled(false);
        this.async = async;
    }

    public PendingDropAdapter(Viewer viewer) {
        this(viewer, true);
    }

    public void drop(DropTargetEvent event) {
        super.drop(event);
        event.detail = 4;
    }

    public boolean validateDrop(Object target, int operation, TransferData transferType) {
        if (transferType != null) {
            this.currentTransfer = transferType;
        }
        this.currentTarget = null;
        this.shelvedTarget = null;
        this.unshelve = false;
        if (target != null) {
            IP4ShelvedChangelist list;
            if (target instanceof IP4PendingChangelist) {
                if (!((IP4PendingChangelist)target).isReadOnly()) {
                    this.currentTarget = (IP4PendingChangelist)target;
                    return true;
                }
            } else if (target instanceof IP4File) {
                IP4File file = (IP4File)target;
                IP4PendingChangelist list2 = file.getChangelist();
                if (list2 != null && !list2.isReadOnly()) {
                    this.currentTarget = list2;
                    return true;
                }
            } else if (target instanceof IP4ShelvedChangelist) {
                if (!((IP4ShelvedChangelist)target).isReadOnly()) {
                    this.shelvedTarget = (IP4ShelvedChangelist)target;
                    return true;
                }
            } else if (target instanceof IP4ShelveFile && (list = ((IP4ShelveFile)target).getChangelist()) != null && !list.isReadOnly()) {
                this.shelvedTarget = list;
                return true;
            }
        }
        return false;
    }

    public boolean performDrop(Object data) {
        if (data == null) {
            return false;
        }
        if (ResourceTransfer.getInstance().isSupportedType(this.currentTransfer)) {
            if (data instanceof IResource[]) {
                return this.doResourceDrop((IResource[])data);
            }
        } else if (FileTransfer.getInstance().isSupportedType(this.currentTransfer)) {
            if (data instanceof String[]) {
                return this.doFileDrop((String[])data);
            }
        } else if (data instanceof IStructuredSelection) {
            return this.doSelectionDrop((IStructuredSelection)data);
        }
        return false;
    }

    private void unshelveDrop(IStructuredSelection selection) {
        ArrayList<IP4ShelveFile> resources = new ArrayList<IP4ShelveFile>();
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof IP4ShelveFile) {
                resources.add((IP4ShelveFile)object);
            }
            ++n2;
        }
        IP4PendingChangelist currentList = this.currentTarget;
        if (currentList != null && !resources.isEmpty()) {
            this.unshelve(resources, currentList);
        }
    }

    private boolean doSelectionDrop(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return false;
        }
        P4Collection collection = P4ConnectionManager.getManager().createP4Collection();
        ArrayList<IResource> resources = new ArrayList<IResource>();
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof IP4File) {
                collection.add((IP4Resource)((IP4File)object));
            } else if (object instanceof IP4Job) {
                collection.add((IP4Resource)((IP4Job)object));
            } else {
                if (object instanceof IP4ShelveFile) {
                    this.unshelve = true;
                    this.unshelveDrop(selection);
                    break;
                }
                if (object instanceof IResource) {
                    resources.add((IResource)object);
                } else if (object instanceof IAdaptable && (object = ((IAdaptable)object).getAdapter(IResource.class)) instanceof IResource) {
                    resources.add((IResource)object);
                }
            }
            ++n2;
        }
        if (!this.unshelve) {
            this.addP4Resources(collection, resources.toArray(new IResource[0]));
            this.dropCollection(collection);
        }
        return true;
    }

    private void addP4Resources(P4Collection collection, IResource[] resources) {
        IFile[] files;
        IFile[] iFileArray = files = P4CoreUtils.getResourceFiles((IResource[])resources);
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            IFile file = iFileArray[n2];
            collection.add(P4ConnectionManager.getManager().getResource((IResource)file));
            ++n2;
        }
    }

    private boolean doResourceDrop(IResource[] resources) {
        if (resources.length == 0) {
            return false;
        }
        IFile[] files = P4CoreUtils.getResourceFiles((IResource[])resources);
        P4Collection collection = new P4Collection();
        IFile[] iFileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            IFile file = iFileArray[n2];
            collection.add(P4ConnectionManager.getManager().getResource((IResource)file));
            ++n2;
        }
        this.dropCollection(collection);
        return true;
    }

    private void shelve(final P4Collection collection, final IP4ShelvedChangelist currentShelve) {
        P4Runnable runnable = new P4Runnable(){

            public void run(IProgressMonitor monitor) {
                monitor.beginTask(Messages.PendingDropAdapter_ShelvingPerforceResources, 1);
                IP4PendingChangelist pending = currentShelve.getConnection().getPendingChangelist(currentShelve.getId(), true);
                if (pending != null) {
                    pending.updateShelvedFiles(collection.members());
                }
            }

            public String getTitle() {
                return Messages.PendingDropAdapter_ShelvingPerforceResources;
            }
        };
        if (this.async) {
            P4Runner.schedule((IP4Runnable)runnable);
        } else {
            runnable.run((IProgressMonitor)new NullProgressMonitor());
        }
    }

    private void unshelve(final List<IP4ShelveFile> collection, final IP4PendingChangelist currentList) {
        P4Runnable runnable = new P4Runnable(){

            public void run(IProgressMonitor monitor) {
                monitor.beginTask(Messages.PendingDropAdapter_UnshelvingPerforceResources, 1);
                int id = currentList.getId();
                P4Collection refreshCollection = new P4Collection();
                for (IP4ShelveFile resource : collection) {
                    if (resource == null || !P4CoreUtils.equals((Object)resource.getConnection(), (Object)currentList.getConnection())) continue;
                    IP4ShelvedChangelist shelved = resource.getChangelist();
                    IFileSpec[] specs = shelved.unshelve(new IP4Resource[]{resource}, id);
                    P4Collection listCollection = P4Collection.getValidCollection((IP4Connection)currentList.getConnection(), Arrays.asList(specs), (IP4Resource.Type)refreshCollection.getType());
                    refreshCollection.addAll(listCollection);
                }
                if (!refreshCollection.isEmpty()) {
                    refreshCollection.refresh();
                    refreshCollection.refreshLocalResources(1);
                }
            }

            public String getTitle() {
                return Messages.PendingDropAdapter_UnshelvingPerforceResources;
            }
        };
        if (this.async) {
            P4Runner.schedule((IP4Runnable)runnable);
        } else {
            runnable.run((IProgressMonitor)new NullProgressMonitor());
        }
    }

    private void open(final P4Collection collection, final IP4PendingChangelist currentList) {
        P4Runnable runnable = new P4Runnable(){

            public void run(IProgressMonitor monitor) {
                monitor.beginTask(Messages.PendingDropAdapter_OpeningPerforceResources, 4);
                collection.add(currentList.getId());
                monitor.worked(1);
                collection.edit(currentList.getId());
                monitor.worked(1);
                collection.reopen(currentList);
                monitor.worked(1);
                collection.fix((IP4Changelist)currentList);
                monitor.worked(1);
                monitor.done();
            }

            public String getTitle() {
                return Messages.PendingDropAdapter_OpeningPerforceResources;
            }
        };
        if (this.async) {
            P4Runner.schedule((IP4Runnable)runnable);
        } else {
            runnable.run((IProgressMonitor)new NullProgressMonitor());
        }
    }

    private void dropCollection(P4Collection collection) {
        if (!this.unshelve && collection != null && !collection.isEmpty()) {
            IP4PendingChangelist currentList = this.currentTarget;
            IP4ShelvedChangelist currentShelve = this.shelvedTarget;
            if (currentList != null) {
                this.open(collection, currentList);
            } else if (currentShelve != null) {
                this.shelve(collection, currentShelve);
            }
        }
    }

    public boolean doFileDrop(String[] files) {
        if (files.length == 0) {
            return false;
        }
        if (DragData.getSource() instanceof PendingDragAdapter) {
            IP4Connection connection = DragData.getConnection();
            P4Collection collection = new P4Collection();
            String[] stringArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                String file = stringArray[n2];
                collection.add((IP4Resource)connection.getFile(file));
                ++n2;
            }
            this.dropCollection(collection);
        }
        DragData.clear();
        return true;
    }
}

