/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.timelapse;

import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.core.p4java.P4Storage;
import com.perforce.team.ui.P4ConnectionManager;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.p4java.actions.P4Action;
import com.perforce.team.ui.p4v.P4VTimeLapseAction;
import com.perforce.team.ui.timelapse.IContextHandler;
import com.perforce.team.ui.timelapse.Messages;
import com.perforce.team.ui.timelapse.TimeLapseInput;
import com.perforce.team.ui.timelapse.TimeLapseRegistry;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;

public class TimeLapseAction
extends P4Action {
    private boolean enableBranchHistory = true;
    private boolean enableChangelistKeys = true;

    public void setEnableBranchHistory(boolean enableBranchHistory) {
        this.enableBranchHistory = enableBranchHistory;
    }

    public void setEnableChangelistKeys(boolean enableChangelistKeys) {
        this.enableChangelistKeys = enableChangelistKeys;
    }

    @Override
    public boolean isEnabledEx() {
        return this.revisionExists(this.getSingleFileSelection());
    }

    private void openEditor(final String id, final IP4File file) {
        PerforceUIPlugin.syncExec(new Runnable(){

            @Override
            public void run() {
                TimeLapseInput input = new TimeLapseInput(file, TimeLapseAction.this.enableBranchHistory, TimeLapseAction.this.enableChangelistKeys);
                try {
                    IDE.openEditor((IWorkbenchPage)PerforceUIPlugin.getActivePage(), (IEditorInput)input, (String)id);
                }
                catch (PartInitException e) {
                    PerforceProviderPlugin.logError((Throwable)e);
                }
            }
        });
    }

    private void showNotFoundMessage() {
        PerforceUIPlugin.syncExec(new Runnable(){

            @Override
            public void run() {
                P4ConnectionManager.getManager().openInformation(P4UIUtils.getDialogShell(), Messages.TimeLapseAction_NoTimelapseTitle, Messages.TimeLapseAction_NoTimelapseMessage);
            }
        });
    }

    private IContentType getStorageType(final IP4File file) {
        int head = file.getHeadRevision();
        if (head <= 1) {
            file.refresh();
        }
        P4Storage storage = new P4Storage(){

            public String getName() {
                return file.getName();
            }

            public InputStream getContents() throws CoreException {
                return file.getHeadContents();
            }
        };
        return P4UIUtils.getContentType((IStorage)storage);
    }

    private IContentType getFileType(IFile localFile) {
        IContentType type = null;
        try {
            localFile.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            PerforceProviderPlugin.logError((Throwable)e);
        }
        if (localFile.exists()) {
            try {
                IContentDescription description = localFile.getContentDescription();
                if (description != null) {
                    type = description.getContentType();
                }
            }
            catch (CoreException e) {
                PerforceProviderPlugin.logError((Throwable)e);
            }
        }
        return type;
    }

    @Override
    protected void runAction() {
        boolean internal = PerforceUIPlugin.getPlugin().getPreferenceStore().getBoolean("com.perforce.team.ui.preferences.USE_INTERNAL_TIMELAPSE");
        if (internal) {
            final IP4File file = this.getSingleFileSelection();
            if (file != null && this.isEnabledEx()) {
                P4Runnable runnable = new P4Runnable(){

                    public String getTitle() {
                        return Messages.TimeLapseAction_OpeningTimelapse;
                    }

                    public void run(IProgressMonitor monitor) {
                        String editorId = null;
                        IContextHandler handler = null;
                        IContentType type = null;
                        IFile localFile = file.getLocalFileForLocation();
                        if (localFile != null) {
                            type = TimeLapseAction.this.getFileType(localFile);
                        }
                        if (type == null) {
                            type = TimeLapseAction.this.getStorageType(file);
                        }
                        if (type != null) {
                            editorId = TimeLapseRegistry.getRegistry().getEditorId(type);
                            handler = TimeLapseRegistry.getRegistry().getHandler(type);
                        }
                        if (editorId == null) {
                            editorId = TimeLapseRegistry.getRegistry().getEditorId("org.eclipse.core.runtime.text", true);
                        }
                        if (editorId != null) {
                            boolean open = true;
                            if (handler != null) {
                                open = handler.timelapseRequested(type, editorId, file);
                            }
                            if (open) {
                                TimeLapseAction.this.openEditor(editorId, file);
                            }
                        } else {
                            TimeLapseAction.this.showNotFoundMessage();
                        }
                    }
                };
                this.runRunnable((IP4Runnable)runnable);
            }
        } else {
            P4VTimeLapseAction external = new P4VTimeLapseAction();
            external.setAsync(this.isAsync());
            external.setCollection(this.getResourceSelection());
            external.run(null);
        }
    }
}

