/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.timelapse;

import com.perforce.p4java.core.file.FileAction;
import com.perforce.team.core.p4java.IP4Revision;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.timelapse.ITickDecorator;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;

public class ActionTickDecorator
implements ITickDecorator {
    private Image addImage;
    private int addXOffset;
    private Image editImage;
    private int editXOffset;
    private Image deleteImage;
    private int deleteXOffset;
    private Image branchImage;
    private int branchXOffset;
    private Image integrateImage;
    private int integrateXOffset;
    private Image addOtherImage;
    private int addOtherXOffset;
    private Image editOtherImage;
    private int editOtherXOffset;
    private Image deleteOtherImage;
    private int deleteOtherXOffset;
    private Image branchOtherImage;
    private int branchOtherXOffset;
    private Image integrateOtherImage;
    private int integrateOtherXOffset;

    public ActionTickDecorator() {
        PerforceUIPlugin plugin = PerforceUIPlugin.getPlugin();
        this.addImage = plugin.getImageDescriptor("decorations/add.png").createImage();
        this.addXOffset = this.addImage.getBounds().width / 2;
        this.editImage = plugin.getImageDescriptor("decorations/edit.png").createImage();
        this.editXOffset = this.editImage.getBounds().width / 2;
        this.deleteImage = plugin.getImageDescriptor("decorations/delete.png").createImage();
        this.deleteXOffset = this.deleteImage.getBounds().width / 2;
        this.branchImage = plugin.getImageDescriptor("decorations/branch.png").createImage();
        this.branchXOffset = this.branchImage.getBounds().width / 2;
        this.integrateImage = plugin.getImageDescriptor("decorations/integrate.png").createImage();
        this.integrateXOffset = this.integrateImage.getBounds().width / 2;
        this.addOtherImage = plugin.getImageDescriptor("decorations/add_other.png").createImage();
        this.addOtherXOffset = this.addOtherImage.getBounds().width / 2;
        this.editOtherImage = plugin.getImageDescriptor("decorations/edit_other.png").createImage();
        this.editOtherXOffset = this.editOtherImage.getBounds().width / 2;
        this.deleteOtherImage = plugin.getImageDescriptor("decorations/delete_other.png").createImage();
        this.deleteOtherXOffset = this.deleteOtherImage.getBounds().width / 2;
        this.branchOtherImage = plugin.getImageDescriptor("decorations/branch_other.png").createImage();
        this.branchOtherXOffset = this.branchOtherImage.getBounds().width / 2;
        this.integrateOtherImage = plugin.getImageDescriptor("decorations/integrate_other.png").createImage();
        this.integrateOtherXOffset = this.integrateOtherImage.getBounds().width / 2;
    }

    protected FileAction getAction(IP4Revision revision) {
        return revision.getAction();
    }

    protected boolean isModifiedByOwner(IP4Revision revision) {
        return revision.isModifiedByOwner();
    }

    @Override
    public void decorate(IP4Revision revision, int x, int y, GC gc) {
        FileAction action = this.getAction(revision);
        if (action != null) {
            boolean owned = this.isModifiedByOwner(revision);
            switch (action) {
                case ADD: 
                case MOVE_ADD: {
                    if (owned) {
                        gc.drawImage(this.addImage, x - this.addXOffset, y);
                        break;
                    }
                    gc.drawImage(this.addOtherImage, x - this.addOtherXOffset, y);
                    break;
                }
                case BRANCH: {
                    if (owned) {
                        gc.drawImage(this.branchImage, x - this.branchXOffset, y);
                        break;
                    }
                    gc.drawImage(this.branchOtherImage, x - this.branchOtherXOffset, y);
                    break;
                }
                case EDIT: {
                    if (owned) {
                        gc.drawImage(this.editImage, x - this.editXOffset, y);
                        break;
                    }
                    gc.drawImage(this.editOtherImage, x - this.editOtherXOffset, y);
                    break;
                }
                case INTEGRATE: {
                    if (owned) {
                        gc.drawImage(this.integrateImage, x - this.integrateXOffset, y);
                        break;
                    }
                    gc.drawImage(this.integrateOtherImage, x - this.integrateOtherXOffset, y);
                    break;
                }
                case DELETE: 
                case MOVE_DELETE: {
                    if (owned) {
                        gc.drawImage(this.deleteImage, x - this.deleteXOffset, y);
                        break;
                    }
                    gc.drawImage(this.deleteOtherImage, x - this.deleteOtherXOffset, y);
                }
            }
        }
    }

    @Override
    public void dispose() {
        if (this.editImage != null) {
            this.editImage.dispose();
        }
        if (this.addImage != null) {
            this.addImage.dispose();
        }
        if (this.deleteImage != null) {
            this.deleteImage.dispose();
        }
        if (this.deleteOtherImage != null) {
            this.deleteOtherImage.dispose();
        }
        if (this.addOtherImage != null) {
            this.addOtherImage.dispose();
        }
        if (this.editOtherImage != null) {
            this.editOtherImage.dispose();
        }
        if (this.integrateImage != null) {
            this.integrateImage.dispose();
        }
        if (this.integrateOtherImage != null) {
            this.integrateOtherImage.dispose();
        }
        if (this.branchImage != null) {
            this.branchImage.dispose();
        }
        if (this.branchOtherImage != null) {
            this.branchOtherImage.dispose();
        }
    }
}

