/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.synchronize;

import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.p4java.synchronize.PerforceSubscriber;
import com.perforce.team.ui.decorator.PerforceDecorator;
import com.perforce.team.ui.synchronize.P4ChangeSetCapability;
import com.perforce.team.ui.synchronize.PerforceSyncActionGroup;
import com.perforce.team.ui.synchronize.RemoveActionGroup;
import com.perforce.team.ui.synchronize.SyncActionGroupRegistry;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.internal.ui.synchronize.ChangeSetCapability;
import org.eclipse.team.internal.ui.synchronize.IChangeSetProvider;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.synchronize.ISynchronizePage;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipantDescriptor;
import org.eclipse.team.ui.synchronize.ISynchronizeScope;
import org.eclipse.team.ui.synchronize.SubscriberParticipant;
import org.eclipse.team.ui.synchronize.SynchronizePageActionGroup;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PartInitException;

public class PerforceSynchronizeParticipant
extends SubscriberParticipant
implements IPropertyChangeListener,
IChangeSetProvider {
    public static final String ID = "com.perforce.synchronize.participant";
    private ChangeSetCapability changeSetCapability;

    public static PerforceSynchronizeParticipant addParticipant(ISynchronizeScope scope) {
        PerforceSynchronizeParticipant addedParticipant = new PerforceSynchronizeParticipant(scope);
        TeamUI.getSynchronizeManager().addSynchronizeParticipants(new ISynchronizeParticipant[]{addedParticipant});
        return addedParticipant;
    }

    public PerforceSynchronizeParticipant() {
        this.setSubscriber((Subscriber)PerforceSubscriber.getSubscriber());
    }

    public PerforceSynchronizeParticipant(ISynchronizeScope scope) {
        super(scope);
        this.setSubscriber((Subscriber)PerforceSubscriber.getSubscriber());
    }

    protected void initializeConfiguration(final ISynchronizePageConfiguration configuration) {
        configuration.addActionContribution((SynchronizePageActionGroup)new RemoveActionGroup());
        configuration.addActionContribution((SynchronizePageActionGroup)new PerforceSyncActionGroup());
        SynchronizePageActionGroup[] synchronizePageActionGroupArray = SyncActionGroupRegistry.getRegistry().generateGroups();
        int n = synchronizePageActionGroupArray.length;
        int n2 = 0;
        while (n2 < n) {
            SynchronizePageActionGroup group = synchronizePageActionGroupArray[n2];
            configuration.addActionContribution(group);
            ++n2;
        }
        super.initializeConfiguration(configuration);
        PerforceDecorator decorator = new PerforceDecorator(true){

            @Override
            public String getName() {
                return String.valueOf(PerforceSynchronizeParticipant.class.getSimpleName()) + ":" + super.getName();
            }
        };
        ILabelProviderListener listener = new ILabelProviderListener(){

            public void labelProviderChanged(LabelProviderChangedEvent event) {
                Viewer viewer;
                ISynchronizePage page;
                if (event.getElements() == null && (page = configuration.getPage()) != null && (viewer = page.getViewer()) != null) {
                    viewer.refresh();
                }
            }
        };
        decorator.addListener(listener);
        configuration.addLabelDecorator((ILabelDecorator)decorator);
        configuration.setSupportedModes(15);
        configuration.setMode(4);
        P4ChangeSetCapability capability = (P4ChangeSetCapability)this.getChangeSetCapability();
        capability.addChangeSetFilter(configuration);
    }

    protected void setSubscriber(Subscriber subscriber) {
        super.setSubscriber(subscriber);
        try {
            ISynchronizeParticipantDescriptor descriptor = this.getDescriptor();
            this.setInitializationData(descriptor);
        }
        catch (CoreException e) {
            PerforceProviderPlugin.logError((Throwable)e);
        }
        if (this.getSecondaryId() == null) {
            this.setSecondaryId(Long.toString(System.currentTimeMillis()));
        }
    }

    protected ISynchronizeParticipantDescriptor getDescriptor() {
        return TeamUI.getSynchronizeManager().getParticipantDescriptor(ID);
    }

    public void init(String secondaryId, IMemento memento) throws PartInitException {
        super.init(secondaryId, memento);
        this.setSubscriber((Subscriber)PerforceSubscriber.getSubscriber());
    }

    public ChangeSetCapability getChangeSetCapability() {
        if (this.changeSetCapability == null) {
            this.changeSetCapability = new P4ChangeSetCapability();
        }
        return this.changeSetCapability;
    }

    protected boolean isViewerContributionsSupported() {
        return true;
    }
}

