/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.swarmreview.restapi;

import com.perforce.team.ui.swarmreview.SSLValidator;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.HttpsURLConnection;

public final class APIConnector {
    private boolean isConnected;
    private HttpURLConnection connection;
    private boolean ignoreSSL;

    private APIConnector() {
    }

    static APIConnector getConnector() {
        return new APIConnector();
    }

    void connect(String serviceURL) throws MalformedURLException, IOException {
        URL url = new URL(serviceURL);
        this.connection = (HttpURLConnection)url.openConnection();
        this.connection.setConnectTimeout(10000);
        try {
            if (this.connection instanceof HttpsURLConnection && this.ignoreSSL) {
                this.connection = (HttpsURLConnection)this.connection;
                SSLValidator.disableSSL((HttpsURLConnection)this.connection);
            }
        }
        catch (KeyManagementException keyManagementException) {
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (KeyStoreException keyStoreException) {
            // empty catch block
        }
    }

    void setIgnoreSSLValidation(boolean ignoreSSL) {
        this.ignoreSSL = ignoreSSL;
    }

    boolean isServiceAvailable() {
        return this.isConnected;
    }

    HttpURLConnection getConnection() {
        return this.connection;
    }
}

