/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.swarmreview.dialogs;

import com.perforce.team.core.p4java.IP4SubmittedChangelist;
import com.perforce.team.core.p4java.P4SubmittedFile;
import com.perforce.team.ui.swarmreview.dialogs.UpdateReviewDialog;
import com.perforce.team.ui.swarmreview.restapi.Result;
import com.perforce.team.ui.views.SubmittedView;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class UpdateSubmittedReviewDialog
extends UpdateReviewDialog<IP4SubmittedChangelist> {
    public UpdateSubmittedReviewDialog(Shell parentShell) {
        super(parentShell);
    }

    @Override
    TableViewer createFilesToBeReviewedGrid(Composite parent) {
        this.checkboxTableViewer = new TableViewer(parent, 67584);
        Table filesTable = this.checkboxTableViewer.getTable();
        filesTable.setHeaderVisible(true);
        GridData gd_table = new GridData(4, 4, true, true);
        gd_table.heightHint = 248;
        filesTable.setLayoutData((Object)gd_table);
        this.setupColumns();
        return this.checkboxTableViewer;
    }

    @Override
    TableViewer createShelvedFilesToBeReviewedGrid(Composite parent) {
        this.shelfTableViewer = new TableViewer(parent, 67584);
        Table shelvedTable = this.shelfTableViewer.getTable();
        shelvedTable.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        shelvedTable.setHeaderVisible(true);
        return this.checkboxTableViewer;
    }

    protected void okPressed() {
        try {
            Object[] checkedFiles = this.getSelectedItems();
            if (checkedFiles == null || checkedFiles.length == 0) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)"Review", (String)"No files selected for review");
            } else {
                Result<Boolean> result = this.controller.requestReview(checkedFiles, null);
                if (result.isSuccessful()) {
                    SubmittedView.getView().refresh();
                }
                MessageDialog.openError((Shell)this.getShell(), (String)"Progress", (String)result.getMessage());
                super.okPressed();
            }
        }
        catch (Exception ex) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)"Update Review", (String)ex.getMessage());
            super.okPressed();
        }
    }

    void setupColumns() {
        String[] titles = new String[]{"File Name", "Revision", "Action", "File Type", "In Folder"};
        int[] bounds = new int[]{200, 80, 80, 80, 800};
        TableViewerColumn col = this.createTableViewerColumn(this.checkboxTableViewer, titles[0], bounds[0], 0);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof P4SubmittedFile) {
                    return ((P4SubmittedFile)element).getFile().getName();
                }
                return null;
            }
        });
        col = this.createTableViewerColumn(this.checkboxTableViewer, titles[1], bounds[1], 1);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof P4SubmittedFile) {
                    return String.valueOf(((P4SubmittedFile)element).getFile().getHeadRevision());
                }
                return null;
            }
        });
        col = this.createTableViewerColumn(this.checkboxTableViewer, titles[2], bounds[2], 2);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof P4SubmittedFile) {
                    return ((P4SubmittedFile)element).getFile().getP4JFile().getAction().toString();
                }
                return null;
            }
        });
        col = this.createTableViewerColumn(this.checkboxTableViewer, titles[3], bounds[3], 3);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof P4SubmittedFile) {
                    return ((P4SubmittedFile)element).getFile().getP4JFile().getFileType();
                }
                return null;
            }
        });
        col = this.createTableViewerColumn(this.checkboxTableViewer, titles[4], bounds[4], 4);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof P4SubmittedFile) {
                    return ((P4SubmittedFile)element).getFile().getP4JFile().getDepotPathString();
                }
                return null;
            }
        });
    }

    @Override
    Object[] getSelectedItems() {
        ArrayList<P4SubmittedFile> tableItems = new ArrayList<P4SubmittedFile>();
        TableItem[] titems = this.checkboxTableViewer.getTable().getItems();
        if (titems != null && titems.length > 0) {
            TableItem[] tableItemArray = titems;
            int n = titems.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                Object data = item.getData();
                if (data instanceof P4SubmittedFile) {
                    tableItems.add((P4SubmittedFile)data);
                }
                ++n2;
            }
        }
        return tableItems.toArray(new P4SubmittedFile[tableItems.size()]);
    }
}

