/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.swarmreview.dialogs;

import com.perforce.team.core.p4java.IP4Changelist;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.ui.shelve.Messages;
import com.perforce.team.ui.swarmreview.ReviewManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public abstract class UpdateReviewDialog<T extends IP4Changelist>
extends Dialog {
    TableViewer checkboxTableViewer;
    TableViewer shelfTableViewer;
    ReviewManager<T> controller;
    private Text textReviewId;
    private TextViewer textViewerReviewDescription;
    private Composite reviewIdSearchComposite;
    private Button revertButton;
    private Button removeButton;
    private boolean revertChecked;
    private boolean removeChecked;
    IP4Resource[] checkedFiles;

    public UpdateReviewDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(1232);
    }

    public void setController(ReviewManager<T> controller) {
        this.controller = controller;
    }

    abstract TableViewer createFilesToBeReviewedGrid(Composite var1);

    abstract TableViewer createShelvedFilesToBeReviewedGrid(Composite var1);

    abstract Object[] getSelectedItems();

    public IP4Resource[] getCheckedFiles() {
        return this.checkedFiles;
    }

    public boolean isRevertChecked() {
        return this.revertChecked;
    }

    public boolean isRemoveChecked() {
        return this.removeChecked;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        Label lblTheFollowingFiles = new Label(container, 0);
        lblTheFollowingFiles.setText("The following files will be sent for review:");
        this.checkboxTableViewer = this.createFilesToBeReviewedGrid(container);
        Object[] shelffiles = this.controller.getShelvedReviewFiles();
        if (shelffiles != null && shelffiles.length > 0) {
            Label lblShelvedFiles = new Label(container, 0);
            lblShelvedFiles.setText("The following shelved files will be part of the review:");
            this.shelfTableViewer = this.createShelvedFilesToBeReviewedGrid(container);
            this.shelfTableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            this.shelfTableViewer.setInput((Object)shelffiles);
        }
        this.createUserSearchPanel(container);
        this.checkboxTableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        Object[] files = this.controller.getReviewFiles();
        this.checkboxTableViewer.setInput((Object)files);
        if (this.checkboxTableViewer instanceof CheckboxTableViewer) {
            ((CheckboxTableViewer)this.checkboxTableViewer).setAllChecked(true);
        }
        this.reviewIdSearchComposite.setEnabled(!this.controller.isUpdateReview());
        this.revertButton = new Button(container, 32);
        this.revertButton.setText(Messages.ConfirmShelveDialog_RevertCheckedOutFiles);
        this.removeButton = new Button(container, 32);
        this.removeButton.setText(Messages.ConfirmShelveDialog_RemoveFilesOpenedForAdd);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!UpdateReviewDialog.this.revertButton.getSelection()) {
                    UpdateReviewDialog.this.removeButton.setEnabled(false);
                    UpdateReviewDialog.this.removeButton.setSelection(false);
                    return;
                }
                UpdateReviewDialog.this.removeButton.setEnabled(true);
                UpdateReviewDialog.this.revertChecked = UpdateReviewDialog.this.revertButton.getSelection();
                UpdateReviewDialog.this.removeChecked = UpdateReviewDialog.this.removeButton.getSelection();
            }
        };
        this.revertButton.addSelectionListener((SelectionListener)listener);
        this.removeButton.addSelectionListener((SelectionListener)listener);
        listener.widgetSelected(null);
        return container;
    }

    private void createUserSearchPanel(Composite parent) {
        this.reviewIdSearchComposite = new Composite(parent, 0);
        this.reviewIdSearchComposite.setLayout((Layout)new GridLayout(3, false));
        GridData gd_composite = new GridData(4, 4, true, true);
        gd_composite.heightHint = 281;
        this.reviewIdSearchComposite.setLayoutData((Object)gd_composite);
        Label lblDescription = new Label(this.reviewIdSearchComposite, 0);
        lblDescription.setText("Update Review:");
        this.textReviewId = new Text(this.reviewIdSearchComposite, 2048);
        GridData gd_text = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_text.widthHint = 116;
        this.textReviewId.setLayoutData((Object)gd_text);
        Button btnViewReviewDescription = new Button(this.reviewIdSearchComposite, 0);
        btnViewReviewDescription.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!UpdateReviewDialog.this.textReviewId.getText().isEmpty()) {
                    String desc = UpdateReviewDialog.this.controller.getChangeListDescriptionFor(UpdateReviewDialog.this.textReviewId.getText());
                    UpdateReviewDialog.this.textViewerReviewDescription.getTextWidget().setText(desc);
                    UpdateReviewDialog.this.updateOKButtonState(UpdateReviewDialog.this.controller.isUpdateReview());
                }
            }
        });
        btnViewReviewDescription.setText("View Review Description");
        Label lblReviewDescription = new Label(this.reviewIdSearchComposite, 0);
        lblReviewDescription.setText("Review Description:");
        this.textViewerReviewDescription = new TextViewer(this.reviewIdSearchComposite, 2048);
        StyledText styledText = this.textViewerReviewDescription.getTextWidget();
        GridData gd_styledText = new GridData(4, 4, true, true, 3, 1);
        gd_styledText.heightHint = 281;
        gd_styledText.widthHint = 448;
        styledText.setLayoutData((Object)gd_styledText);
        this.textViewerReviewDescription.setEditable(false);
        boolean isUpdate = this.controller.isUpdateReview();
        if (isUpdate) {
            this.textViewerReviewDescription.getTextWidget().setVisible(!isUpdate);
            gd_composite.heightHint = 0;
        }
        lblReviewDescription.setVisible(!this.controller.isUpdateReview());
        btnViewReviewDescription.setVisible(!this.controller.isUpdateReview());
        this.textReviewId.setVisible(!this.controller.isUpdateReview());
        lblDescription.setVisible(!this.controller.isUpdateReview());
    }

    private void updateOKButtonState(boolean enabled) {
        this.getButton(0).setEnabled(enabled);
        this.getButton(0).setText("Update Files");
    }

    protected void cancelPressed() {
        this.controller.clearSelectedChangelistData();
        super.cancelPressed();
    }

    TableViewerColumn createTableViewerColumn(TableViewer viewer, String title, int bound, int colNumber) {
        TableViewerColumn viewerColumn = new TableViewerColumn(viewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setWidth(bound);
        column.setResizable(true);
        column.setMoveable(true);
        return viewerColumn;
    }

    public void setFocus(TableViewer viewer) {
        viewer.getControl().setFocus();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.updateOKButtonState(this.controller.isUpdateReview());
    }

    protected Point getInitialSize() {
        return new Point(1167, 692);
    }
}

