/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.submitted;

import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.team.core.P4CoreUtils;
import com.perforce.team.core.p4java.IP4Changelist;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4Job;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.IP4SubmittedChangelist;
import com.perforce.team.core.p4java.IP4SubmittedFile;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.core.p4java.P4Runner;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceLabelProvider;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.changelists.ChangelistDetailsWidget;
import com.perforce.team.ui.changelists.ChangelistFileWidget;
import com.perforce.team.ui.changelists.ChangelistWidget;
import com.perforce.team.ui.dialogs.DialogUtils;
import com.perforce.team.ui.submitted.ISubmittedChangelistListener;
import com.perforce.team.ui.submitted.Messages;
import com.perforce.team.ui.submitted.SubmittedChangelistFileWidget;
import com.perforce.team.ui.swarmreview.ReviewManager;
import com.perforce.team.ui.swarmreview.SubmittedReviewManager;
import com.perforce.team.ui.viewer.FilterViewer;
import com.perforce.team.ui.views.AbstractPerforceViewControl;
import com.perforce.team.ui.views.SessionManager;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILazyTreeContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;
import org.osgi.framework.Bundle;

public class SubmittedChangelistTable
extends FilterViewer
implements ISelectionChangedListener {
    public static final String COLUMN_SIZES = "com.perforce.team.ui.submittedcolumns";
    public static final String FILE_FOLDER_HISTORY = "com.perforce.team.ui.submitted.FILE_FOLDER_HISTORY";
    public static final String USER_HISTORY = "com.perforce.team.ui.submitted.USER_HISTORY";
    public static final String WORKSPACE_HISTORY = "com.perforce.team.ui.submitted.WORKSPACE_HISTORY";
    public static final int MAC_COLUMN0_OFFSET = 17;
    public static final int MAC_COLUMN0_OFFSET_COCOA = 20;
    public static final int MAC_COLUMN_OFFSET = 34;
    public static final int MAC_COLUMN_OFFSET_COCOA = 52;
    public static final int WIN_COLUMN0_OFFSET = 17;
    public static final int WIN_COLUMN_OFFSET = 58;
    public static final int LINUX_COLUMN0_OFFSET = 17;
    public static final int LINUX_COLUMN0_OFFSET_32 = 0;
    public static final int LINUX_COLUMN_OFFSET = 53;
    public static boolean eclipse33OrGreater = false;
    private int column0Offset;
    private int columnOffset;
    private Image loadingImage;
    private Image clearImage;
    private Label folderFileLabel;
    private Combo folderFileCombo;
    private ToolBar folderFileBar;
    private ToolItem folderFileClearItem;
    private Label userLabel;
    private Combo userCombo;
    private ToolBar userBar;
    private ToolItem userClearItem;
    private Label workspaceLabel;
    private Combo workspaceCombo;
    private ToolBar workspaceBar;
    private ToolItem workspaceClearItem;
    private TreeViewer viewer;
    private IP4SubmittedChangelist selectedList = null;
    private IP4SubmittedChangelist[] changeLists = null;
    private ISubmittedChangelistListener callback = null;
    private Composite viewComposite;
    private SashForm sash;
    private boolean displayDetails;
    private boolean enableEdit = false;
    private boolean isLoading = false;
    private IP4Resource p4Resource = null;
    private Object loading = new Object();
    private int retrieveCount = 0;
    private String[] folders = new String[0];
    private String[] users = new String[0];
    private String[] clients = new String[0];
    private ChangelistWidget detailPanel;
    private Link showMore;
    private Comparator<IP4Resource> sorter = new Comparator<IP4Resource>(){

        @Override
        public int compare(IP4Resource e1, IP4Resource e2) {
            if (e1 instanceof IP4SubmittedFile && e2 instanceof IP4Job) {
                return -1;
            }
            if (e1 instanceof IP4Job && e2 instanceof IP4SubmittedFile) {
                return 1;
            }
            if (e1 instanceof IP4SubmittedFile && e2 instanceof IP4SubmittedFile) {
                String a1 = ((IP4SubmittedFile)e1).getActionPath();
                String a2 = ((IP4SubmittedFile)e2).getActionPath();
                if (a1 != null && a2 != null) {
                    return a1.compareTo(a2);
                }
            } else if (e1 instanceof IP4Job && e2 instanceof IP4Job) {
                String id1 = ((IP4Job)e1).getId();
                String id2 = ((IP4Job)e2).getId();
                if (id1 != null && id2 != null) {
                    return id1.compareTo(id2);
                }
            }
            return 0;
        }
    };

    static {
        try {
            Bundle bundle = Platform.getBundle((String)"org.eclipse.jface");
            if (bundle != null) {
                eclipse33OrGreater = bundle.loadClass("org.eclipse.jface.viewers.ILazyTreePathContentProvider") != null;
            }
        }
        catch (Exception e) {
            eclipse33OrGreater = false;
        }
        catch (Error e) {
            eclipse33OrGreater = false;
        }
    }

    public static TableConfig getConfig() {
        TableConfig config = new TableConfig();
        if (P4CoreUtils.isMac()) {
            boolean isCocoa = "cocoa".equals(Platform.getWS());
            if (!isCocoa) {
                config.column0Offset = 17;
                config.columnOffset = 34;
            } else {
                config.redrawOnResize = true;
                config.column0Offset = 20;
                config.columnOffset = 52;
            }
        } else if (P4CoreUtils.isWindows()) {
            config.column0Offset = 17;
            config.columnOffset = 58;
        } else if (P4CoreUtils.isLinux()) {
            config.column0Offset = eclipse33OrGreater ? 17 : 0;
            config.columnOffset = 53;
        }
        return config;
    }

    public SubmittedChangelistTable() {
        this(null, null, null, false);
    }

    public SubmittedChangelistTable(String[] folders, String[] users, String[] clients, boolean enableEdit) {
        if (folders != null) {
            this.folders = folders;
        }
        if (users != null) {
            this.users = users;
        }
        if (clients != null) {
            this.clients = clients;
        }
        this.enableEdit = enableEdit;
    }

    public void dispose() {
        if (this.loadingImage != null && !this.loadingImage.isDisposed()) {
            this.loadingImage.dispose();
        }
        if (this.clearImage != null && !this.clearImage.isDisposed()) {
            this.clearImage.dispose();
            this.clearImage = null;
        }
    }

    public boolean okToUse() {
        return P4UIUtils.okToUse((Viewer)this.viewer);
    }

    public void setResource(IP4Resource resource) {
        this.p4Resource = resource;
    }

    private void createFilterArea(Composite parent) {
        this.filterComposite = new Composite(parent, 0);
        GridLayout fcLayout = new GridLayout(6, false);
        this.filterComposite.setLayout((Layout)fcLayout);
        this.filterComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        this.folderFileLabel = new Label(this.filterComposite, 16384);
        this.folderFileLabel.setText(Messages.SubmittedChangelistTable_FolderFile);
        this.folderFileCombo = new Combo(this.filterComposite, 4);
        String[] stringArray = this.folders;
        int n = this.folders.length;
        int n2 = 0;
        while (n2 < n) {
            String folder = stringArray[n2];
            this.folderFileCombo.add(folder);
            ++n2;
        }
        final SelectionListener comboAdapter = P4UIUtils.createComboSelectionListener(new Runnable(){

            @Override
            public void run() {
                SubmittedChangelistTable.this.updateChangelists();
            }
        });
        this.folderFileCombo.addSelectionListener(comboAdapter);
        GridData ffcData = new GridData(4, 4, true, false);
        ffcData.horizontalSpan = 4;
        this.folderFileCombo.setLayoutData((Object)ffcData);
        this.clearImage = PerforceUIPlugin.getPlugin().getImageDescriptor("normal/clear.png").createImage();
        this.folderFileBar = new ToolBar(this.filterComposite, 0x800000);
        this.folderFileClearItem = new ToolItem(this.folderFileBar, 8);
        this.folderFileClearItem.setImage(this.clearImage);
        this.folderFileClearItem.setToolTipText(Messages.SubmittedChangelistTable_ClearFolderFileFilter);
        this.folderFileClearItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SubmittedChangelistTable.this.folderFileCombo.setText("");
                comboAdapter.widgetSelected(null);
            }
        });
        this.userLabel = new Label(this.filterComposite, 16384);
        this.userLabel.setText(Messages.SubmittedChangelistTable_UserLabel);
        this.userLabel.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        this.userCombo = new Combo(this.filterComposite, 4);
        String[] stringArray2 = this.users;
        int n3 = this.users.length;
        int n4 = 0;
        while (n4 < n3) {
            String user = stringArray2[n4];
            this.userCombo.add(user);
            ++n4;
        }
        this.userCombo.setLayoutData((Object)new GridData(4, 4, true, false));
        this.userCombo.addSelectionListener(comboAdapter);
        this.userBar = new ToolBar(this.filterComposite, 0x800000);
        this.userClearItem = new ToolItem(this.userBar, 8);
        this.userClearItem.setImage(this.clearImage);
        this.userClearItem.setToolTipText(Messages.SubmittedChangelistTable_ClearUserFilter);
        this.userClearItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SubmittedChangelistTable.this.userCombo.setText("");
                comboAdapter.widgetSelected(null);
            }
        });
        this.workspaceLabel = new Label(this.filterComposite, 16384);
        this.workspaceLabel.setText(Messages.SubmittedChangelistTable_WorkspaceLabel);
        this.workspaceCombo = new Combo(this.filterComposite, 4);
        stringArray2 = this.clients;
        n3 = this.clients.length;
        n4 = 0;
        while (n4 < n3) {
            String workspace = stringArray2[n4];
            this.workspaceCombo.add(workspace);
            ++n4;
        }
        this.workspaceCombo.setLayoutData((Object)new GridData(4, 4, true, false));
        this.workspaceCombo.addSelectionListener(comboAdapter);
        this.workspaceBar = new ToolBar(this.filterComposite, 0x800000);
        this.workspaceClearItem = new ToolItem(this.workspaceBar, 8);
        this.workspaceClearItem.setImage(this.clearImage);
        this.workspaceClearItem.setToolTipText(Messages.SubmittedChangelistTable_ClearWorkspaceFilter);
        this.workspaceClearItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SubmittedChangelistTable.this.workspaceCombo.setText("");
                comboAdapter.widgetSelected(null);
            }
        });
    }

    public void createPartControl(Composite parent) {
        this.createPartControl(parent, 0, null);
    }

    public void createPartControl(Composite parent, ISubmittedChangelistListener listener) {
        this.createPartControl(parent, 0, listener);
    }

    public void createPartControl(Composite parent, int tableStyle) {
        this.createPartControl(parent, tableStyle, null);
    }

    public void createPartControl(Composite parent, int tableStyle, ISubmittedChangelistListener listener) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.perforce.team.ui.submitted_view");
        this.callback = listener;
        this.sash = DialogUtils.createSash(parent);
        this.viewComposite = new Composite((Composite)this.sash, 0);
        GridLayout gl = new GridLayout(1, true);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.verticalSpacing = 0;
        this.viewComposite.setLayout((Layout)gl);
        this.viewComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createFilterArea(this.viewComposite);
        Tree table = this.createTable(this.viewComposite, tableStyle);
        this.detailPanel = this.createDetailPanel((Composite)this.sash, table.getBackground());
        this.createImages();
    }

    private void createImages() {
        this.loadingImage = PerforceUIPlugin.getPlugin().getImageDescriptor("perforce/hourglass.png").createImage();
    }

    private ChangelistWidget createDetailPanel(Composite parent, Color background) {
        ChangelistWidget widget = new ChangelistWidget(this.enableEdit){

            @Override
            protected ChangelistFileWidget createFileWidget() {
                return new SubmittedChangelistFileWidget(this.enableEdit);
            }

            @Override
            protected ChangelistDetailsWidget createDetailsWidget() {
                return new ChangelistDetailsWidget(){

                    @Override
                    protected String getDateLabelText() {
                        return Messages.SubmittedChangelistTable_DateSubmitted;
                    }

                    @Override
                    protected String getUserLabelText() {
                        return Messages.SubmittedChangelistTable_SubmittedBy;
                    }
                };
            }
        };
        widget.createControl(parent);
        return widget;
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }

    public void setFocus() {
        Tree control = this.getTree();
        if (control != null) {
            control.setFocus();
        }
    }

    public Tree getTree() {
        Tree control;
        if (this.viewer != null && (control = this.viewer.getTree()) != null && !control.isDisposed()) {
            return control;
        }
        return null;
    }

    private void updateSash() {
        if (this.displayDetails) {
            this.sash.setMaximizedControl(null);
        } else {
            this.sash.setMaximizedControl((Control)this.viewComposite);
        }
    }

    public void showDisplayDetails(boolean show) {
        this.displayDetails = show;
        this.updateSash();
    }

    private void updateMoreButton(boolean layout) {
        if (this.showMore != null && !this.showMore.isDisposed()) {
            int max = this.getMaxChangelists();
            if (max == -1) {
                this.showMore.setText(Messages.SubmittedChangelistTable_ShowMore);
                this.showMore.setEnabled(false);
            } else {
                this.showMore.setText(MessageFormat.format(Messages.SubmittedChangelistTable_ShowNumMore, max));
                this.showMore.setEnabled(true);
            }
            if (layout) {
                this.showMore.getParent().layout(new Control[]{this.showMore});
            }
        }
    }

    private void updateMoreButton() {
        this.updateMoreButton(true);
    }

    private Tree createTable(Composite parent, int style) {
        this.showMore = new Link(parent, 8);
        this.showMore.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SubmittedChangelistTable.this.showMore();
            }
        });
        this.showMore.setLayoutData((Object)new GridData(0x1000008, 4, true, false));
        this.retrieveCount = this.getMaxChangelists();
        this.updateMoreButton(false);
        this.viewer = new TreeViewer(parent, 0x10010800 | style | 4);
        this.viewer.setUseHashlookup(true);
        final Tree tree = this.viewer.getTree();
        tree.setHeaderVisible(true);
        tree.setLinesVisible(false);
        TableConfig config = SubmittedChangelistTable.getConfig();
        this.column0Offset = config.column0Offset;
        this.columnOffset = config.columnOffset;
        Listener paintListener = new Listener(){

            private void draw(Event event, String resource) {
                int offset = 0;
                if (event.index > 0) {
                    offset += tree.getColumn(0).getWidth();
                    int i = 1;
                    while (i < event.index) {
                        offset += tree.getColumn(i).getWidth();
                        ++i;
                    }
                    offset = event.x - offset + SubmittedChangelistTable.this.columnOffset;
                } else {
                    offset = event.x + SubmittedChangelistTable.this.column0Offset;
                }
                event.gc.drawString(resource, offset, event.y, true);
            }

            public void handleEvent(Event event) {
                if (event.item.getData() instanceof IP4SubmittedFile) {
                    IP4File file = ((IP4SubmittedFile)event.item.getData()).getFile();
                    IFileSpec spec = file.getP4JFile();
                    int rev = 0;
                    if (spec != null) {
                        rev = spec.getEndRevision();
                    }
                    this.draw(event, String.valueOf(file.getRemotePath()) + "#" + rev);
                } else if (event.item.getData() instanceof IP4Job) {
                    this.draw(event, ((IP4Job)event.item.getData()).getId());
                }
            }
        };
        tree.addListener(42, paintListener);
        tree.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                SubmittedChangelistTable.this.saveColumnSizes();
            }
        });
        TableLayout layout = new TableLayout();
        tree.setLayout((Layout)layout);
        this.addColumn(tree, 0, Messages.SubmittedChangelistTable_Changelist, 3, config.redrawOnResize);
        this.addColumn(tree, 1, Messages.SubmittedChangelistTable_Date, 5, config.redrawOnResize);
        this.addColumn(tree, 2, Messages.SubmittedChangelistTable_User, 5, config.redrawOnResize);
        this.addColumn(tree, 3, Messages.SubmittedChangelistTable_Workspace, 10, config.redrawOnResize);
        this.addColumn(tree, 4, Messages.SubmittedChangelistTable_Description, 20, config.redrawOnResize);
        Map<String, Integer> columnSizes = this.loadColumnSizes();
        TreeColumn[] treeColumnArray = tree.getColumns();
        int n = treeColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            int size;
            TreeColumn column = treeColumnArray[n2];
            int width = 100;
            if (columnSizes.containsKey(column.getText()) && (size = columnSizes.get(column.getText()).intValue()) > 0) {
                width = size;
            }
            layout.addColumnData((ColumnLayoutData)new ColumnPixelData(width, true));
            ++n2;
        }
        this.viewer.setContentProvider((IContentProvider)new SubmittedLazyContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new SubmittedLabelProvider());
        this.viewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof IP4SubmittedFile && e2 instanceof IP4Job) {
                    return -1;
                }
                if (e1 instanceof IP4Job && e1 instanceof IP4SubmittedFile) {
                    return 1;
                }
                if (e1 instanceof IP4SubmittedFile && e2 instanceof IP4SubmittedFile) {
                    String a1;
                    IP4SubmittedFile f1 = (IP4SubmittedFile)e1;
                    IP4SubmittedFile f2 = (IP4SubmittedFile)e2;
                    if (f1.getFile() != null && f2.getFile() != null && (a1 = f1.getFile().getActionPath()) != null) {
                        return a1.compareTo(f2.getFile().getActionPath());
                    }
                } else if (e1 instanceof IP4Job && e2 instanceof IP4Job) {
                    String id1 = ((IP4Job)e1).getId();
                    String id2 = ((IP4Job)e2).getId();
                    if (id1 != null) {
                        return id1.compareTo(id2);
                    }
                }
                return super.compare(viewer, e1, e2);
            }
        });
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        tree.setLayoutData((Object)gd);
        return tree;
    }

    private TreeColumn addColumn(final Tree tree, int colno, String title, int weight, boolean redrawOnResize) {
        TreeColumn col = new TreeColumn(tree, 0);
        if (redrawOnResize) {
            col.addListener(11, new Listener(){

                public void handleEvent(Event event) {
                    tree.redraw();
                }
            });
        }
        col.setResizable(true);
        col.setText(title);
        return col;
    }

    private Map<String, Integer> loadColumnSizes() {
        return SessionManager.loadColumnSizes(COLUMN_SIZES);
    }

    private void saveColumnSizes() {
        SessionManager.saveColumnPreferences(this.viewer.getTree(), COLUMN_SIZES);
    }

    private void updateDetailsPanel(final IP4Changelist change) {
        this.detailPanel.setInput(change);
        P4Runner.schedule((IP4Runnable)new P4Runnable(){

            public void run(IProgressMonitor monitor) {
                if (change != SubmittedChangelistTable.this.selectedList) {
                    return;
                }
                if (change.needsRefresh()) {
                    change.refresh();
                }
                if (change != SubmittedChangelistTable.this.selectedList) {
                    return;
                }
                SubmittedChangelistTable.this.detailPanel.loadFiles(change);
                UIJob job = new UIJob(Messages.SubmittedChangelistTable_UpdatingSubmittedChangelistJobsAndFiles){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        if (SubmittedChangelistTable.this.okToUse() && change == SubmittedChangelistTable.this.selectedList) {
                            SubmittedChangelistTable.this.detailPanel.setInput(change);
                            SubmittedChangelistTable.this.detailPanel.refreshFiles();
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.schedule();
            }
        });
    }

    public void clearDetailsPanel() {
        this.detailPanel.setInput(null);
    }

    public void clearFilters() {
        this.folderFileCombo.setText("");
        this.userCombo.setText("");
        this.workspaceCombo.setText("");
    }

    public String getChangeDetails() {
        return this.detailPanel.getDetailsWidget().getChangelistText();
    }

    public String getDateDetails() {
        return this.detailPanel.getDetailsWidget().getDateText();
    }

    public String getClientDetails() {
        return this.detailPanel.getDetailsWidget().getWorkspaceText();
    }

    public String getUserDetail() {
        return this.detailPanel.getDetailsWidget().getUserText();
    }

    public String getDescriptionDetail() {
        return this.detailPanel.getDetailsWidget().getDescriptionText();
    }

    private int getMaxChangelists() {
        return AbstractPerforceViewControl.getPreferenceStore().getInt("pref_retrieve_num_changes");
    }

    public void refreshRetrieveCount() {
        this.retrieveCount = this.getMaxChangelists();
    }

    public void updateMoreLink() {
        this.refreshRetrieveCount();
        this.updateMoreButton();
        if (this.selectedList != null) {
            this.updateChangelists();
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        TreeItem parent;
        TreeItem[] items;
        Object selected = ((StructuredSelection)event.getSelection()).getFirstElement();
        IP4SubmittedChangelist change = null;
        if (selected instanceof IP4SubmittedChangelist) {
            change = (IP4SubmittedChangelist)selected;
        } else if ((selected instanceof IP4SubmittedFile || selected instanceof IP4Job) && (items = this.viewer.getTree().getSelection()).length == 1 && (parent = items[0].getParentItem()) != null && parent.getData() instanceof IP4SubmittedChangelist) {
            change = (IP4SubmittedChangelist)parent.getData();
        }
        if (this.selectedList != change) {
            this.selectedList = change;
            if (change != null) {
                this.updateDetailsPanel((IP4Changelist)change);
            } else {
                this.clearDetailsPanel();
            }
        } else if (change == null) {
            this.clearDetailsPanel();
        }
    }

    public void showChangelists(IP4Resource resource) {
        if (resource != null && resource.getConnection() != null && !resource.getConnection().isOffline()) {
            this.retrieveCount = this.getMaxChangelists();
            this.p4Resource = resource;
            if (this.p4Resource != null) {
                String path = this.p4Resource.getActionPath();
                if (path != null) {
                    this.folderFileCombo.setText(path);
                } else {
                    this.folderFileCombo.setText("");
                }
            } else {
                this.folderFileCombo.setText("");
            }
            this.userCombo.setText("");
            this.workspaceCombo.setText("");
            this.updateChangelists();
        } else {
            this.p4Resource = null;
            this.folderFileCombo.setText("");
            this.userCombo.setText("");
            this.workspaceCombo.setText("");
        }
    }

    private void enableFilters(boolean enabled) {
        this.folderFileCombo.setEnabled(enabled);
        this.userCombo.setEnabled(enabled);
        this.workspaceCombo.setEnabled(enabled);
    }

    private boolean checkFilter(String[] paths, String user, String workspace) {
        if (user == null) {
            user = "";
        }
        if (workspace == null) {
            workspace = "";
        }
        if (paths == null) {
            paths = new String[]{""};
        }
        if (paths.length == 1 && paths[0] != null) {
            return paths[0].equals(this.folderFileCombo.getText().trim()) && user.equals(this.userCombo.getText().trim()) && workspace.equals(this.workspaceCombo.getText().trim());
        }
        return false;
    }

    private void updateHistory(String path, String user, String workspace) {
        String item2;
        int n;
        String[] stringArray;
        if (path != null && path.length() > 0) {
            ArrayList<String> paths = new ArrayList<String>();
            paths.add(path);
            stringArray = this.folderFileCombo.getItems();
            n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                item2 = stringArray[n2];
                if (!paths.contains(item2)) {
                    paths.add(item2);
                }
                if (paths.size() == 10) break;
                ++n2;
            }
            this.folderFileCombo.removeAll();
            for (String item2 : paths) {
                this.folderFileCombo.add(item2, this.folderFileCombo.getItemCount());
            }
            this.folderFileCombo.select(0);
            SessionManager.saveHistory(paths, FILE_FOLDER_HISTORY);
        }
        if (user != null && user.length() > 0) {
            ArrayList<String> users = new ArrayList<String>();
            users.add(user);
            stringArray = this.userCombo.getItems();
            n = stringArray.length;
            int n3 = 0;
            while (n3 < n) {
                item2 = stringArray[n3];
                if (!users.contains(item2)) {
                    users.add(item2);
                }
                if (users.size() == 10) break;
                ++n3;
            }
            this.userCombo.removeAll();
            for (String item2 : users) {
                this.userCombo.add(item2, this.userCombo.getItemCount());
            }
            this.userCombo.select(0);
            SessionManager.saveHistory(users, USER_HISTORY);
        }
        if (workspace != null && workspace.length() > 0) {
            ArrayList<String> workspaces = new ArrayList<String>();
            workspaces.add(workspace);
            stringArray = this.workspaceCombo.getItems();
            n = stringArray.length;
            int n4 = 0;
            while (n4 < n) {
                item2 = stringArray[n4];
                if (!workspaces.contains(item2)) {
                    workspaces.add(item2);
                }
                if (workspaces.size() == 10) break;
                ++n4;
            }
            this.workspaceCombo.removeAll();
            for (String item2 : workspaces) {
                this.workspaceCombo.add(item2, this.workspaceCombo.getItemCount());
            }
            this.workspaceCombo.select(0);
            SessionManager.saveHistory(workspaces, WORKSPACE_HISTORY);
        }
    }

    public void updateChangelists() {
        String workspace;
        final IP4Resource currResource = this.p4Resource;
        this.isLoading = true;
        this.updateSash();
        this.viewer.setInput(this.loading);
        String[] paths = null;
        String path = this.folderFileCombo.getText().trim();
        paths = path.length() == 0 ? null : new String[]{path};
        String user = this.userCombo.getText().trim();
        if (user.length() == 0) {
            user = null;
        }
        if ((workspace = this.workspaceCombo.getText().trim()).length() == 0) {
            workspace = null;
        }
        final String[] finalPaths = paths;
        final String finalUser = user;
        final String finalWorkspace = workspace;
        this.enableFilters(false);
        this.updateHistory(path, user, workspace);
        this.updateMoreButton();
        this.viewer.getTree().setItemCount(1);
        P4Runner.schedule((IP4Runnable)new P4Runnable(){

            public String getTitle() {
                return Messages.SubmittedChangelistTable_LoadingSubmittedChangelists;
            }

            public void run(IProgressMonitor monitor) {
                IP4Resource resource = SubmittedChangelistTable.this.p4Resource;
                if (resource == null || currResource != resource) {
                    SubmittedChangelistTable.this.isLoading = false;
                    return;
                }
                final IP4SubmittedChangelist[] newChangelists = resource.getConnection().getSubmittedChangelists(finalPaths, SubmittedChangelistTable.this.retrieveCount, finalUser, finalWorkspace);
                if (newChangelists.length > 0) {
                    ReviewManager<IP4SubmittedChangelist> swarmReviewManager = SubmittedReviewManager.getInstance(resource.getConnection());
                    swarmReviewManager.init(null, true);
                    swarmReviewManager.createCache((IP4Changelist[])newChangelists);
                }
                UIJob job = new UIJob(Messages.SubmittedChangelistTable_UpdatingSubmittedChangelistView){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        if (currResource != SubmittedChangelistTable.this.p4Resource) {
                            return Status.CANCEL_STATUS;
                        }
                        if (SubmittedChangelistTable.this.okToUse() && SubmittedChangelistTable.this.checkFilter(finalPaths, finalUser, finalWorkspace)) {
                            SubmittedChangelistTable.this.changeLists = newChangelists;
                            SubmittedChangelistTable.this.viewer.setInput((Object)SubmittedChangelistTable.this.changeLists);
                            SubmittedChangelistTable.this.viewer.getTree().setItemCount(SubmittedChangelistTable.this.changeLists.length);
                            if (SubmittedChangelistTable.this.callback != null) {
                                SubmittedChangelistTable.this.callback.changelistsLoaded(SubmittedChangelistTable.this.changeLists);
                            }
                            SubmittedChangelistTable.this.updateSash();
                            SubmittedChangelistTable.this.viewer.getTree().update();
                            if (SubmittedChangelistTable.this.changeLists.length > 0) {
                                SubmittedChangelistTable.this.viewer.setSelection((ISelection)new StructuredSelection((Object)SubmittedChangelistTable.this.changeLists[0]));
                                if (SubmittedChangelistTable.this.viewer.getSelection().isEmpty()) {
                                    SubmittedChangelistTable.this.updateDetailsPanel((IP4Changelist)SubmittedChangelistTable.this.changeLists[0]);
                                }
                            }
                            SubmittedChangelistTable.this.enableFilters(true);
                            SubmittedChangelistTable.this.isLoading = false;
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.schedule();
            }
        });
    }

    public void refresh() {
        this.refreshRetrieveCount();
        this.updateMoreButton();
        if (this.p4Resource != null) {
            this.updateChangelists();
        } else {
            this.viewer.refresh();
        }
    }

    public void refresh(IP4SubmittedChangelist list) {
        if (list != null && this.changeLists != null) {
            IP4SubmittedChangelist[] iP4SubmittedChangelistArray = this.changeLists;
            int n = this.changeLists.length;
            int n2 = 0;
            while (n2 < n) {
                IP4SubmittedChangelist current = iP4SubmittedChangelistArray[n2];
                if (list.getId() == current.getId()) {
                    current.markForRefresh();
                    this.viewer.refresh((Object)current);
                    break;
                }
                ++n2;
            }
        }
    }

    public Composite getControl() {
        return this.sash;
    }

    public IP4SubmittedChangelist[] getSelectedChangelists() {
        HashSet<IP4SubmittedChangelist> lists = new HashSet<IP4SubmittedChangelist>();
        ITreeSelection selection = (ITreeSelection)this.viewer.getSelection();
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object selected = objectArray[n2];
            if (selected instanceof IP4SubmittedChangelist) {
                lists.add((IP4SubmittedChangelist)selected);
            }
            ++n2;
        }
        return lists.toArray(new IP4SubmittedChangelist[0]);
    }

    public void showMore() {
        if (this.retrieveCount != -1) {
            this.retrieveCount += this.getMaxChangelists();
        }
        this.updateChangelists();
    }

    public boolean isLoading() {
        return this.isLoading;
    }

    public IP4SubmittedChangelist[] getChangelists() {
        return this.changeLists;
    }

    public ChangelistWidget getChangelistWidget() {
        return this.detailPanel;
    }

    private class SubmittedLabelProvider
    extends PerforceLabelProvider {
        public SubmittedLabelProvider() {
            super(false);
        }

        @Override
        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0 && element == SubmittedChangelistTable.this.loading) {
                return SubmittedChangelistTable.this.loadingImage;
            }
            return super.getColumnImage(element, columnIndex);
        }

        @Override
        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof IP4Changelist) {
                IP4Changelist list = (IP4Changelist)element;
                switch (columnIndex) {
                    case 0: {
                        return Integer.toString(list.getId());
                    }
                    case 1: {
                        return P4UIUtils.formatLabelDate(list.getDate());
                    }
                    case 2: {
                        return list.getUserName();
                    }
                    case 3: {
                        return list.getClientName();
                    }
                    case 4: {
                        return P4CoreUtils.removeWhitespace((String)list.getDescription());
                    }
                }
                return super.getColumnText(element, columnIndex);
            }
            if (columnIndex == 0 && element == SubmittedChangelistTable.this.loading) {
                return Messages.SubmittedChangelistTable_Loading;
            }
            return "";
        }
    }

    private class SubmittedLazyContentProvider
    implements ILazyTreeContentProvider {
        private SubmittedLazyContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object getParent(Object element) {
            return null;
        }

        public void updateChildCount(Object element, int currentChildCount) {
            if (element instanceof IP4Changelist) {
                final IP4Changelist list = (IP4Changelist)element;
                if (list.needsRefresh()) {
                    SubmittedChangelistTable.this.viewer.setChildCount(element, 1);
                    P4Runner.schedule((IP4Runnable)new P4Runnable(){

                        public void run(IProgressMonitor monitor) {
                            list.refresh();
                            UIJob job = new UIJob(Messages.SubmittedChangelistTable_FetchingSubmittedChangelist){

                                public IStatus runInUIThread(IProgressMonitor monitor) {
                                    block3: {
                                        if (SubmittedChangelistTable.this.okToUse()) {
                                            try {
                                                SubmittedChangelistTable.this.viewer.remove((Object)list, new Object[]{SubmittedChangelistTable.this.loading});
                                                SubmittedChangelistTable.this.viewer.setChildCount((Object)list, list.members().length);
                                                SubmittedChangelistTable.this.viewer.expandToLevel((Object)list, 1);
                                            }
                                            catch (SWTException e) {
                                                if (e.code == 24) break block3;
                                                throw e;
                                            }
                                        }
                                    }
                                    return Status.OK_STATUS;
                                }
                            };
                            job.setSystem(true);
                            job.schedule();
                        }
                    });
                } else {
                    int size = list.members().length;
                    if (size != currentChildCount) {
                        SubmittedChangelistTable.this.viewer.setChildCount(element, size);
                    }
                }
            }
        }

        public void updateElement(Object parent, int index) {
            if (parent == SubmittedChangelistTable.this.changeLists && SubmittedChangelistTable.this.changeLists != null) {
                int changeLength = SubmittedChangelistTable.this.changeLists.length;
                if (index >= 0 && index < changeLength) {
                    IP4SubmittedChangelist list = SubmittedChangelistTable.this.changeLists[index];
                    SubmittedChangelistTable.this.viewer.replace(parent, index, (Object)list);
                    if (list.needsRefresh()) {
                        SubmittedChangelistTable.this.viewer.setChildCount((Object)list, 1);
                    } else {
                        SubmittedChangelistTable.this.viewer.setChildCount((Object)list, list.members().length);
                    }
                }
            } else if (parent instanceof IP4Changelist) {
                IP4Changelist list = (IP4Changelist)parent;
                if (list.needsRefresh()) {
                    SubmittedChangelistTable.this.viewer.replace((Object)list, 0, SubmittedChangelistTable.this.loading);
                    if (!eclipse33OrGreater) {
                        this.updateChildCount(list, 1);
                    }
                } else {
                    IP4Resource[] files = list.members();
                    if (!eclipse33OrGreater) {
                        SubmittedChangelistTable.this.viewer.setChildCount((Object)list, files.length);
                    }
                    Arrays.sort(files, SubmittedChangelistTable.this.sorter);
                    if (index >= 0 && index < files.length) {
                        if (files[index] instanceof IP4SubmittedFile) {
                            SubmittedChangelistTable.this.viewer.replace(parent, index, (Object)files[index]);
                        } else if (files[index] instanceof IP4Job) {
                            SubmittedChangelistTable.this.viewer.replace(parent, index, (Object)files[index]);
                        }
                    }
                }
            } else if (parent == SubmittedChangelistTable.this.loading && index == 0) {
                SubmittedChangelistTable.this.viewer.replace(parent, 0, SubmittedChangelistTable.this.loading);
            }
        }
    }

    public static class TableConfig {
        public int column0Offset;
        public int columnOffset;
        public boolean redrawOnResize = false;
    }
}

