/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.streams.wizard;

import com.perforce.p4java.core.IStream;
import com.perforce.p4java.core.IStreamIgnoredMapping;
import com.perforce.p4java.core.IStreamRemappedMapping;
import com.perforce.p4java.core.IStreamSummary;
import com.perforce.p4java.core.IStreamViewMapping;
import com.perforce.p4java.core.ViewMap;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.SWTUtils;
import com.perforce.team.ui.dialogs.FixedWidthScrolledComposite;
import com.perforce.team.ui.streams.StreamUtil;
import com.perforce.team.ui.streams.wizard.AbstractEditStreamWizardPage;
import com.perforce.team.ui.streams.wizard.Messages;
import java.text.MessageFormat;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class AdvancedSettingPage
extends AbstractEditStreamWizardPage {
    private Text ownerText;
    private Text rootFolderText;
    private Text pathsText;
    private Text remappedText;
    private Text ignoredText;
    private Button lockedBtn;
    private Button submitBtn;
    private Label depotPathLabel;

    public AdvancedSettingPage() {
        super(AdvancedSettingPage.class.getName());
        this.setImageDescriptor(PerforceUIPlugin.getPlugin().getImageDescriptor("perforce/stream_wizard.png"));
        this.setTitle(Messages.AdvancedSettingPage_Title);
        this.setDescription(Messages.AdvancedSettingPage_Description);
    }

    public void createControl(Composite parent) {
        IStream sum = this.getStream();
        FixedWidthScrolledComposite scroll = new FixedWidthScrolledComposite(parent, 512);
        scroll.setLayout((Layout)new FillLayout());
        Composite composite = new Composite((Composite)scroll, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
        SWTUtils.createLabel(composite, Messages.AdvancedSettingPage_Owner);
        this.ownerText = SWTUtils.createText(composite);
        if (sum != null && sum.getOwnerName() != null) {
            this.ownerText.setText(sum.getOwnerName());
        }
        SWTUtils.createPlaceholder(composite, 1);
        this.lockedBtn = SWTUtils.createCheckBox(composite, Messages.AdvancedSettingPage_StreamLockedToOwner);
        SWTUtils.createPlaceholder(composite, 1);
        this.submitBtn = SWTUtils.createCheckBox(composite, Messages.AdvancedSettingPage_SubmittingRestrictToOwner);
        if (sum != null) {
            this.lockedBtn.setSelection(sum.getOptions().isLocked());
            this.submitBtn.setSelection(sum.getOptions().isOwnerSubmit());
        }
        SWTUtils.createLabel(composite, Messages.AdvancedSettingPage_RootFolder);
        this.rootFolderText = SWTUtils.createText(composite);
        SWTUtils.createLabel(composite, Messages.AdvancedSettingPage_DepotPath);
        this.depotPathLabel = SWTUtils.createLabel(composite, "");
        if (sum != null && sum.getStream() != null) {
            this.rootFolderText.setText(StreamUtil.getStreamRoot((IStreamSummary)sum));
            this.depotPathLabel.setText(StreamUtil.makeStreamAbsolute(sum.getStream()));
        }
        GridDataFactory.swtDefaults().span(2, 1).applyTo((Control)SWTUtils.createLabel(composite, Messages.AdvancedSettingPage_StreamViewPaths));
        this.pathsText = SWTUtils.createTextArea(composite, 2, 1, 4);
        if (sum != null && sum.getStreamView() != null) {
            this.pathsText.setText(StreamUtil.getStreamViewPaths((ViewMap<IStreamViewMapping>)sum.getStreamView()));
        }
        GridDataFactory.swtDefaults().span(2, 1).applyTo((Control)SWTUtils.createLabel(composite, Messages.AdvancedSettingPage_RemmappedPaths));
        this.remappedText = SWTUtils.createTextArea(composite, 2, 1, 4);
        if (sum != null && sum.getRemappedView() != null) {
            this.remappedText.setText(StreamUtil.getRemmapedPaths((ViewMap<IStreamRemappedMapping>)sum.getRemappedView()));
        }
        GridDataFactory.swtDefaults().span(2, 1).applyTo((Control)SWTUtils.createLabel(composite, Messages.AdvancedSettingPage_IgnoredPaths));
        this.ignoredText = SWTUtils.createTextArea(composite, 2, 1, 4);
        if (sum != null && sum.getIgnoredView() != null) {
            this.ignoredText.setText(StreamUtil.getIgnoredPatterns((ViewMap<IStreamIgnoredMapping>)sum.getIgnoredView()));
        }
        scroll.setContent((Control)composite);
        scroll.setExpandHorizontal(true);
        scroll.setExpandVertical(true);
        scroll.setMinSize(composite.computeSize(-1, -1));
        this.setControl((Control)scroll);
        this.restoreFromSettings();
        this.addListeners();
        scroll.getContent().setEnabled(!this.getWizard().isEditMode() || !this.getWizard().isStreamLocked());
    }

    @Override
    protected void addListeners() {
        WizardDialog dialog = (WizardDialog)this.getWizard().getContainer();
        dialog.addPageChangedListener(new IPageChangedListener(){

            public void pageChanged(PageChangedEvent event) {
                if (event.getSelectedPage() == AdvancedSettingPage.this) {
                    AdvancedSettingPage.this.updatePage();
                }
            }
        });
        this.lockedBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AdvancedSettingPage.this.getStream().getOptions().setLocked(AdvancedSettingPage.this.lockedBtn.getSelection());
                AdvancedSettingPage.this.validateAndUpdate();
            }
        });
        this.submitBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AdvancedSettingPage.this.getStream().getOptions().setOwnerSubmit(AdvancedSettingPage.this.submitBtn.getSelection());
                AdvancedSettingPage.this.validateAndUpdate();
            }
        });
        this.ownerText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AdvancedSettingPage.this.getStream().setOwnerName(AdvancedSettingPage.this.ownerText.getText());
                AdvancedSettingPage.this.validateAndUpdate();
            }
        });
        this.rootFolderText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String streamRoot = AdvancedSettingPage.this.rootFolderText.getText();
                String streamPath = String.valueOf(StreamUtil.getParentDepot((IStreamSummary)AdvancedSettingPage.this.getStream())) + streamRoot;
                if (AdvancedSettingPage.this.getStream().getType() == IStreamSummary.Type.MAINLINE) {
                    streamPath = String.valueOf(StreamUtil.getDepot((IStreamSummary)AdvancedSettingPage.this.getStream())) + "/" + streamRoot;
                }
                AdvancedSettingPage.this.depotPathLabel.setText(StreamUtil.makeStreamAbsolute(streamPath));
                AdvancedSettingPage.this.depotPathLabel.getParent().layout();
                AdvancedSettingPage.this.getStream().setStream(streamPath);
                AdvancedSettingPage.this.validateAndUpdate();
                if (!AdvancedSettingPage.this.getWizard().rootFolderChanged) {
                    AdvancedSettingPage.this.getWizard().rootFolderChanged = true;
                }
            }
        });
        this.pathsText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AdvancedSettingPage.this.getStream().setStreamView(StreamUtil.parseStreamViewMapping(AdvancedSettingPage.this.pathsText.getText()));
                AdvancedSettingPage.this.validateAndUpdate();
            }
        });
        this.remappedText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AdvancedSettingPage.this.getStream().setRemappedView(StreamUtil.parseRemappedMapping(AdvancedSettingPage.this.remappedText.getText()));
                AdvancedSettingPage.this.validateAndUpdate();
            }
        });
        this.ignoredText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AdvancedSettingPage.this.getStream().setIgnoredView(StreamUtil.parseIgnoredMapping(AdvancedSettingPage.this.ignoredText.getText()));
                AdvancedSettingPage.this.validateAndUpdate();
            }
        });
    }

    protected void updatePage() {
        if (this.getStream().getType() == IStreamSummary.Type.VIRTUAL) {
            this.submitBtn.setSelection(false);
            this.submitBtn.setEnabled(false);
            this.submitBtn.setToolTipText(Messages.AdvancedSettingPage_SubmitRestrictionNeedMadeInSourceStream);
        } else {
            this.submitBtn.setEnabled(true);
            this.submitBtn.setToolTipText(null);
        }
        this.rootFolderText.setEnabled(!this.getWizard().isEditMode());
        if (StringUtils.isEmpty((CharSequence)this.rootFolderText.getText()) || !this.getWizard().rootFolderChanged) {
            if (this.getWizard().isEditMode()) {
                this.rootFolderText.setText(StreamUtil.getStreamRoot((IStreamSummary)this.getStream()));
            } else {
                this.rootFolderText.setText(StreamUtil.escapeWhiteSpace(this.getStream().getName()));
            }
            this.getWizard().rootFolderChanged = false;
        }
    }

    @Override
    protected IStatus doValidate() {
        if (this.getWizard().isEditMode() && this.getWizard().isStreamLocked()) {
            return ValidationStatus.warning((String)this.getWizard().getStreamLockMessage());
        }
        IStream stream = this.getStream();
        Assert.isNotNull((Object)stream);
        if (StringUtils.isEmpty((CharSequence)stream.getOwnerName())) {
            return ValidationStatus.error((String)Messages.AdvancedSettingPage_StreamOwnerEmptyError);
        }
        if (StringUtils.isEmpty((CharSequence)stream.getStream())) {
            return ValidationStatus.error((String)Messages.AdvancedSettingPage_StreamRootEmptyError);
        }
        if (stream.getStream() != null && stream.getStream().equals(stream.getParent())) {
            return ValidationStatus.error((String)Messages.AdvancedSettingPage_CannotCreateSelfParentStream);
        }
        if (!StreamUtil.isValidStreamFormat(stream)) {
            return ValidationStatus.error((String)MessageFormat.format(Messages.AdvancedSettingPage_StreamFormatIncorrect, stream.getStream()));
        }
        return super.doValidate();
    }

    protected void validateAndUpdate() {
        StreamUtil.print(this.getStream());
        IStatus status = this.validate();
        this.applyToStatusLine(status);
        this.getWizard().getContainer().updateButtons();
    }
}

