/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.streams;

import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.Policy;
import com.perforce.team.core.Tracing;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Listener;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.P4Event;
import com.perforce.team.ui.P4ConnectionManager;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.streams.StreamsViewControl;
import com.perforce.team.ui.views.IPerforceView;
import com.perforce.team.ui.views.Messages;
import com.perforce.team.ui.views.PerforceProjectView;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.progress.UIJob;

public class StreamsView
extends PerforceProjectView {
    public static final String VIEW_ID = "com.perforce.team.ui.StreamsView";
    private IP4Listener p4Listener = new IP4Listener(){

        public void resoureChanged(final P4Event event) {
            UIJob job = new UIJob(Messages.DepotView_RefreshingDepotViewTree){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    Tracing.printExecTime((boolean)Policy.DEBUG, (String)(String.valueOf(((Object)((Object)StreamsView.this)).getClass().getSimpleName()) + ":resourceChanged()"), (String)event.toString(), (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (StreamsView.this.okToUse()) {
                                switch (event.getType()) {
                                    case REFRESHED: {
                                        IP4Resource[] iP4ResourceArray = event.getResources();
                                        int n = iP4ResourceArray.length;
                                        int n2 = 0;
                                        while (n2 < n) {
                                            IP4Resource r = iP4ResourceArray[n2];
                                            if (r instanceof IP4Connection && r == StreamsView.this.getPerforceViewControl().getConnection()) {
                                                StreamsView.this.getPerforceViewControl().refresh();
                                            }
                                            ++n2;
                                        }
                                        break;
                                    }
                                }
                            }
                        }
                    });
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
        }

        public String getName() {
            return ((Object)((Object)StreamsView.this)).getClass().getSimpleName();
        }
    };

    public static StreamsView findView() {
        return (StreamsView)PerforceUIPlugin.getActivePage().findView(VIEW_ID);
    }

    public static StreamsView showView() {
        try {
            return (StreamsView)PerforceUIPlugin.getActivePage().showView(VIEW_ID);
        }
        catch (PartInitException e) {
            PerforceProviderPlugin.logError((Throwable)e);
            return null;
        }
    }

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        P4ConnectionManager.getManager().addListener(this.p4Listener);
    }

    @Override
    public void dispose() {
        super.dispose();
        P4ConnectionManager.getManager().removeListener(this.p4Listener);
    }

    @Override
    protected StreamsViewControl createViewControl(IPerforceView view) {
        return new StreamsViewControl(view);
    }

    @Override
    public StreamsViewControl getPerforceViewControl() {
        return (StreamsViewControl)super.getPerforceViewControl();
    }

    public void refresh(boolean clearCache, boolean retrieve) {
        this.getPerforceViewControl().refresh(clearCache, retrieve);
    }

    public void expandAll() {
        this.getPerforceViewControl().expandAll();
    }

    public void collapseAll() {
        this.getPerforceViewControl().collapseAll();
    }

    public boolean okToUse() {
        return this.getPerforceViewControl() != null && this.getPerforceViewControl().getTreeViewer() != null && !this.getPerforceViewControl().getTreeViewer().getTree().isDisposed();
    }
}

