/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.streams;

import com.perforce.p4java.core.IDepot;
import com.perforce.p4java.core.IStreamSummary;
import com.perforce.p4java.option.server.GetStreamsOptions;
import com.perforce.team.core.P4JavaEnumHelper;
import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.core.p4java.P4Runner;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.SWTUtils;
import com.perforce.team.ui.streams.Messages;
import com.perforce.team.ui.streams.StreamsFilterModel;
import com.perforce.team.ui.streams.StreamsSuggestProvider;
import com.perforce.team.ui.streams.SuggestBox;
import com.perforce.team.ui.views.PerforceProjectView;
import com.perforce.team.ui.views.SessionManager;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.progress.UIJob;

public class StreamsFilterWidget
extends Composite {
    private static final String PREF_KEY = "prefId";
    private static final int HISTORY_SIZE = 10;
    public static final String STREAMS_NAME_HISTORY = "com.perforce.team.ui.streams.STREAMS_NAME_HISTORY";
    public static final String STREAMS_OWNER_HISTORY = "com.perforce.team.ui.streams.STREAMS_OWNER_HISTORY";
    public static final String STREAMS_PARENT_HISTORY = "com.perforce.team.ui.streams.STREAMS_PARENT_HISTORY";
    private WritableValue filterModel;
    private Combo nameCombo;
    private Combo ownerCombo;
    private Combo typeCombo;
    private SuggestBox parentCombo;
    private Combo depotCombo;
    private Button showUnloadedOnlyBtn;
    private boolean hasParent;
    private SelectionListener comboAdapter = P4UIUtils.createComboSelectionListener(new Runnable(){

        @Override
        public void run() {
            StreamsFilterWidget.this.showUnloadedOnlyBtn.setVisible(IStreamSummary.Type.TASK.name().equalsIgnoreCase(StreamsFilterWidget.this.typeCombo.getText()));
            StreamsFilterWidget.this.updateObservable();
        }
    });
    private StreamsSuggestProvider provider;
    private FocusListener focusAdapter = new FocusListener(){

        public void focusLost(FocusEvent e) {
            if (StreamsFilterWidget.this.autoUpdate) {
                StreamsFilterWidget.this.updateObservable();
            }
        }

        public void focusGained(FocusEvent e) {
        }
    };
    private boolean autoUpdate = false;

    public void enableAutoUpdate(boolean enable) {
        this.autoUpdate = enable;
    }

    public StreamsFilterWidget(Composite parent, int style, WritableValue filterModel, boolean hasParent) {
        super(parent, style);
        this.filterModel = filterModel;
        this.hasParent = hasParent;
        this.createControl();
        this.addListeners();
    }

    private void addListeners() {
        IPreferenceStore store = PerforceUIPlugin.getPlugin().getPreferenceStore();
        store.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                String property = event.getProperty();
                if (property == "pref_display_stream_name_root" && StreamsFilterWidget.this.parentCombo != null) {
                    StreamsFilterWidget.this.parentCombo.refresh();
                }
            }
        });
    }

    public void createControl() {
        GridLayout fcLayout = new GridLayout(6, false);
        this.setLayout((Layout)fcLayout);
        this.setLayoutData(new GridData(4, 4, true, false));
        SWTUtils.createLabel(this, Messages.StreamsFilterWidget_Name);
        this.nameCombo = this.createComboFromHistory(this, STREAMS_NAME_HISTORY);
        GridDataFactory.swtDefaults().span(1, 1).align(4, 0x1000000).indent(10, -1).grab(true, false).applyTo((Control)this.nameCombo);
        this.nameCombo.addSelectionListener(this.comboAdapter);
        this.nameCombo.addFocusListener(this.focusAdapter);
        this.createClearButton(this, (Control)this.nameCombo, this.comboAdapter);
        SWTUtils.createLabel(this, Messages.StreamsFilterWidget_Owner);
        this.ownerCombo = this.createComboFromHistory(this, STREAMS_OWNER_HISTORY);
        GridDataFactory.swtDefaults().span(1, 1).align(4, 0x1000000).grab(true, false).applyTo((Control)this.ownerCombo);
        this.ownerCombo.addSelectionListener(this.comboAdapter);
        this.nameCombo.addFocusListener(this.focusAdapter);
        this.createClearButton(this, (Control)this.ownerCombo, this.comboAdapter);
        SWTUtils.createLabel(this, Messages.StreamsFilterWidget_Type);
        this.typeCombo = new Combo((Composite)this, 4);
        GridDataFactory.swtDefaults().span(1, 1).align(4, 0x1000000).indent(10, -1).grab(true, false).applyTo((Control)this.typeCombo);
        for (IStreamSummary.Type item : P4JavaEnumHelper.filterUnknownValues((Object[])IStreamSummary.Type.values())) {
            this.typeCombo.add(item.name().toLowerCase());
        }
        this.typeCombo.addSelectionListener(this.comboAdapter);
        this.createClearButton(this, (Control)this.typeCombo, this.comboAdapter);
        SWTUtils.createLabel(this, Messages.StreamsFilterWidget_Depot);
        this.depotCombo = new Combo((Composite)this, 4);
        GridDataFactory.swtDefaults().span(1, 1).align(4, 0x1000000).grab(true, false).applyTo((Control)this.depotCombo);
        this.depotCombo.addSelectionListener(this.comboAdapter);
        this.createClearButton(this, (Control)this.depotCombo, this.comboAdapter);
        if (this.hasParent) {
            this.createParentFilter();
        }
        this.showUnloadedOnlyBtn = new Button((Composite)this, 32);
        this.showUnloadedOnlyBtn.setText(Messages.StreamsFilterWidget_ShowUnloadedTaskStreamOnly);
        GridDataFactory.swtDefaults().span(3, 1).align(1, 0x1000000).grab(false, false).applyTo((Control)this.showUnloadedOnlyBtn);
        this.showUnloadedOnlyBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (IStreamSummary.Type.TASK.name().equalsIgnoreCase(StreamsFilterWidget.this.typeCombo.getText())) {
                    StreamsFilterWidget.this.updateObservable();
                }
            }
        });
        this.showUnloadedOnlyBtn.setVisible(false);
    }

    private void createParentFilter() {
        this.provider = new StreamsSuggestProvider(null);
        SWTUtils.createLabel(this, Messages.StreamsFilterWidget_Parent);
        this.parentCombo = new SuggestBox(this, 0, this.provider);
        GridDataFactory.swtDefaults().align(4, 0x1000000).indent(10, -1).grab(true, false).applyTo((Control)this.parentCombo);
        this.createClearButton(this, (Control)this.parentCombo, this.comboAdapter);
        this.parentCombo.getModel().addValueChangeListener(new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                StreamsFilterWidget.this.updateObservable();
            }
        });
    }

    protected void updateObservable() {
        this.saveComboHistory(this.nameCombo);
        this.saveComboHistory(this.ownerCombo);
        StreamsFilterModel newModel = this.computeModel();
        this.filterModel.setValue((Object)newModel);
    }

    public StreamsFilterModel computeModel() {
        SuggestBox.SelectionModel change;
        StreamsFilterModel newModel = new StreamsFilterModel().name(this.nameCombo.getText().trim()).owner(this.ownerCombo.getText().trim()).type(this.typeCombo.getText().trim()).depot(this.depotCombo.getText().trim());
        if (IStreamSummary.Type.TASK.name().equalsIgnoreCase(this.typeCombo.getText())) {
            newModel.showUnloadedOnly(this.showUnloadedOnlyBtn.getSelection());
        } else {
            newModel.showUnloadedOnly(false);
        }
        if (this.hasParent && (change = (SuggestBox.SelectionModel)this.parentCombo.getModel().getValue()) != null) {
            if (change.getSelection() instanceof IStreamSummary) {
                newModel.parent(((IStreamSummary)change.getSelection()).getStream());
            } else {
                newModel.parent(change.getText());
            }
        }
        return newModel;
    }

    public void enableFilters(boolean enabled) {
        this.nameCombo.setEnabled(enabled);
        this.ownerCombo.setEnabled(enabled);
        this.typeCombo.setEnabled(enabled);
        this.depotCombo.setEnabled(enabled);
        if (this.hasParent) {
            this.parentCombo.setEnabled(enabled);
        }
        this.showUnloadedOnlyBtn.setEnabled(enabled);
    }

    private Combo createComboFromHistory(Composite parent, String prefId) {
        String[] items = PerforceProjectView.getItems(prefId);
        Combo combo = new Combo(parent, 4);
        String[] stringArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            combo.add(item);
            ++n2;
        }
        combo.setData(PREF_KEY, (Object)prefId);
        return combo;
    }

    private void saveComboHistory(Combo combo) {
        Object key = combo.getData(PREF_KEY);
        Assert.isTrue((boolean)(key instanceof String));
        Assert.isTrue((!StringUtils.isEmpty((CharSequence)((String)key)) ? 1 : 0) != 0);
        String selection = combo.getText().trim();
        if (!StringUtils.isEmpty((CharSequence)selection)) {
            ArrayList<String> items = new ArrayList<String>();
            items.add(selection);
            String[] stringArray = combo.getItems();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String item = stringArray[n2];
                if (!items.contains(item)) {
                    items.add(item);
                }
                if (items.size() == 10) break;
                ++n2;
            }
            combo.removeAll();
            for (String item : items) {
                combo.add(item);
            }
            combo.select(0);
            SessionManager.saveHistory(items, (String)key);
        }
    }

    private void createClearButton(Composite parent, final Control target, final SelectionListener comboAdapter) {
        Image clearImage = PerforceUIPlugin.getPlugin().getImageDescriptor("normal/clear.png").createImage();
        ToolBar folderFileBar = new ToolBar(parent, 0x800000);
        ToolItem folderFileClearItem = new ToolItem(folderFileBar, 8);
        folderFileClearItem.setImage(clearImage);
        folderFileClearItem.setToolTipText(Messages.StreamsFilterWidget_ClearFilter);
        folderFileClearItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (target instanceof Text) {
                    ((Text)target).setText("");
                } else if (target instanceof Combo) {
                    ((Combo)target).setText("");
                } else if (target instanceof SuggestBox) {
                    ((SuggestBox)target).setTextQuietlyAndUpdateModel("");
                }
                comboAdapter.widgetSelected(null);
            }
        });
    }

    public boolean setFocus() {
        if (this.nameCombo != null) {
            return this.nameCombo.setFocus();
        }
        return super.setFocus();
    }

    public void reset() {
        Control[] controlArray = this.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child instanceof Combo) {
                ((Combo)child).clearSelection();
                ((Combo)child).setText("");
            } else if (child instanceof Text) {
                ((Text)child).setText("");
            }
            ++n2;
        }
    }

    public void setConnection(final IP4Connection conn) {
        this.provider.setConnection(conn);
        P4Runner.schedule((IP4Runnable)new P4Runnable(){

            public String getTitle() {
                return Messages.StreamsFilterWidget_LoadingDepots;
            }

            public void run(IProgressMonitor monitor) {
                try {
                    final List depots = conn.getDepots();
                    GetStreamsOptions opts = new GetStreamsOptions();
                    opts.setFields("Name,Stream");
                    UIJob job = new UIJob(Messages.StreamsFilterWidget_LoadingDepots){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            if (!StreamsFilterWidget.this.depotCombo.isDisposed()) {
                                String depotName = StreamsFilterWidget.this.depotCombo.getText();
                                StreamsFilterWidget.this.depotCombo.clearSelection();
                                StreamsFilterWidget.this.depotCombo.removeAll();
                                for (IDepot depot : depots) {
                                    if (!IDepot.DepotType.STREAM.equals((Object)depot.getDepotType())) continue;
                                    StreamsFilterWidget.this.depotCombo.add(depot.getName());
                                }
                                int selection = StreamsFilterWidget.this.depotCombo.indexOf(depotName);
                                if (selection >= 0) {
                                    StreamsFilterWidget.this.depotCombo.select(selection);
                                }
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    job.schedule();
                }
                catch (Throwable e) {
                    PerforceProviderPlugin.logError((Throwable)e);
                }
            }
        });
    }
}

