/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.streams;

import com.perforce.p4java.core.IStream;
import com.perforce.p4java.core.IStreamIgnoredMapping;
import com.perforce.p4java.core.IStreamRemappedMapping;
import com.perforce.p4java.core.IStreamSummary;
import com.perforce.p4java.core.IStreamViewMapping;
import com.perforce.p4java.core.ViewMap;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.IP4Stream;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.core.p4java.P4Runner;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.SWTUtils;
import com.perforce.team.ui.dialogs.FixedWidthScrolledComposite;
import com.perforce.team.ui.streams.Messages;
import com.perforce.team.ui.streams.StreamUtil;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.progress.UIJob;

public class StreamDetailPanel
extends FixedWidthScrolledComposite {
    private IP4Stream stream;
    private Text nameText;
    private Text rootText;
    private Text modText;
    private Text parentText;
    private Text lastText;
    private Text typeText;
    private Text ownerText;
    private Text descText;
    private Text pathsText;
    private Text remappedText;
    private Text ignoredText;
    private Text viewText;
    private Button fromParentChk;
    private Button toParentChk;
    private Button lockedChk;
    private Button submitFileChk;

    public StreamDetailPanel(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        this.createControl();
        this.setExpandHorizontal(true);
        this.setExpandVertical(true);
    }

    private Composite createControl() {
        Composite parent = new Composite((Composite)this, 0);
        this.setContent((Control)parent);
        int TXT_SINGLE_STYLE = 2060;
        int TXT_MULTI_STYLE = 2826;
        GridLayoutFactory.swtDefaults().numColumns(4).margins(10, 10).applyTo(parent);
        SWTUtils.createLabel(parent, Messages.StreamDetailPanel_Stream);
        this.nameText = SWTUtils.createText(parent, 1, 2060);
        SWTUtils.createLabel(parent, Messages.StreamDetailPanel_StreamRoot);
        this.rootText = SWTUtils.createText(parent, 1, 2060);
        SWTUtils.createLabel(parent, Messages.StreamDetailPanel_DateModified);
        this.modText = SWTUtils.createText(parent, 1, 2060);
        SWTUtils.createLabel(parent, Messages.StreamDetailPanel_Parent);
        this.parentText = SWTUtils.createText(parent, 1, 2060);
        SWTUtils.createLabel(parent, Messages.StreamDetailPanel_LastAccessed);
        this.lastText = SWTUtils.createText(parent, 1, 2060);
        SWTUtils.createLabel(parent, Messages.StreamDetailPanel_Type);
        this.typeText = SWTUtils.createText(parent, 1, 2060);
        SWTUtils.createLabel(parent, Messages.StreamDetailPanel_Owner);
        this.ownerText = SWTUtils.createText(parent, 1, 2060);
        SWTUtils.createLabel(parent, "", 2);
        SWTUtils.createLabel(parent, Messages.StreamDetailPanel_Description);
        this.descText = SWTUtils.createTextArea(parent, 3, 1, 4, 2826);
        SWTUtils.createLabel(parent, Messages.StreamDetailPanel_Options);
        this.createOptions(parent);
        SWTUtils.createLabel(parent, Messages.StreamDetailPanel_Paths);
        this.pathsText = SWTUtils.createTextArea(parent, 3, 1, 4, 2826);
        SWTUtils.createLabel(parent, Messages.StreamDetailPanel_Remapped);
        this.remappedText = SWTUtils.createTextArea(parent, 3, 1, 4, 2826);
        SWTUtils.createLabel(parent, Messages.StreamDetailPanel_Ignored);
        this.ignoredText = SWTUtils.createTextArea(parent, 3, 1, 4, 2826);
        SWTUtils.createLabel(parent, Messages.StreamDetailPanel_ClientView);
        this.viewText = SWTUtils.createTextArea(parent, 3, 1, 4, 2826);
        this.setMinSize(parent.computeSize(-1, -1));
        return parent;
    }

    private void createOptions(Composite composite) {
        Composite parent = new Composite(composite, 0);
        GridDataFactory.fillDefaults().span(3, 1).applyTo((Control)parent);
        GridLayoutFactory.swtDefaults().numColumns(1).applyTo(parent);
        this.submitFileChk = SWTUtils.createCheckBox(parent, Messages.StreamDetailPanel_OptRestictOwner);
        this.lockedChk = SWTUtils.createCheckBox(parent, Messages.StreamDetailPanel_OptLocked);
        this.toParentChk = SWTUtils.createCheckBox(parent, Messages.StreamDetailPanel_OptToParent);
        this.fromParentChk = SWTUtils.createCheckBox(parent, Messages.StreamDetailPanel_OptFromParent);
        parent.setEnabled(false);
    }

    public void setInput(final IP4Stream stream) {
        if (this.stream != stream) {
            this.stream = stream;
            P4Runner.schedule((IP4Runnable)new P4Runnable(){

                public String getTitle() {
                    return MessageFormat.format(Messages.StreamsTreeViewer_LoadingStream, stream == null ? "" : stream.getName());
                }

                public void run(IProgressMonitor monitor) {
                    try {
                        if (stream != null && stream.needsRefresh()) {
                            stream.fetchDetail();
                        }
                        UIJob job = new UIJob(""){

                            public IStatus runInUIThread(IProgressMonitor monitor) {
                                if (!StreamDetailPanel.this.isDisposed()) {
                                    StreamDetailPanel.this.updateControls(stream);
                                }
                                return Status.OK_STATUS;
                            }
                        };
                        job.schedule();
                    }
                    catch (P4JavaException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    private void updateControls(IP4Stream stream) {
        if (stream == null) {
            this.reset();
            return;
        }
        IStreamSummary sum = stream.getStreamSummary();
        if (sum instanceof IStream) {
            IStream s = (IStream)sum;
            this.nameText.setText(s.getName());
            this.rootText.setText(s.getStream());
            this.modText.setText(P4UIUtils.formatLabelDate(s.getUpdated()));
            this.parentText.setText(s.getParent() == null ? "" : s.getParent());
            this.lastText.setText(P4UIUtils.formatLabelDate(s.getAccessed()));
            this.typeText.setText(s.getType().name().toLowerCase());
            this.ownerText.setText(s.getOwnerName());
            this.descText.setText(s.getDescription() == null ? "" : s.getDescription());
            IStreamSummary.IOptions opt = s.getOptions();
            this.updateOptions(opt);
            ViewMap remap = s.getRemappedView();
            this.remappedText.setText(StreamUtil.getRemmapedPaths((ViewMap<IStreamRemappedMapping>)remap));
            ViewMap ignoreView = s.getIgnoredView();
            this.ignoredText.setText(StreamUtil.getIgnoredPatterns((ViewMap<IStreamIgnoredMapping>)ignoreView));
            ViewMap viewMap = s.getStreamView();
            this.pathsText.setText(StreamUtil.getStreamViewPaths((ViewMap<IStreamViewMapping>)viewMap));
            this.viewText.setText(StreamUtil.getStreamClientView(stream));
        } else {
            this.reset();
        }
    }

    private void updateOptions(IStreamSummary.IOptions opt) {
        this.fromParentChk.setSelection(!opt.isNoFromParent());
        this.toParentChk.setSelection(!opt.isNoToParent());
        this.lockedChk.setSelection(opt.isLocked());
        this.submitFileChk.setSelection(opt.isOwnerSubmit());
    }

    private void reset() {
        this.nameText.setText("");
        this.rootText.setText("");
        this.modText.setText("");
        this.parentText.setText("");
        this.lastText.setText("");
        this.typeText.setText("");
        this.ownerText.setText("");
        this.descText.setText("");
        this.remappedText.setText("");
        this.ignoredText.setText("");
        this.pathsText.setText("");
        this.viewText.setText("");
        this.fromParentChk.setSelection(false);
        this.toParentChk.setSelection(false);
        this.lockedChk.setSelection(false);
        this.submitFileChk.setSelection(false);
    }
}

