/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.streams;

import com.perforce.p4java.client.IClientSummary;
import com.perforce.p4java.option.server.GetClientsOptions;
import com.perforce.p4java.option.server.StreamOptions;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.IP4Stream;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.core.p4java.P4Runner;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.streams.AbstractStreamCommandHandler;
import com.perforce.team.ui.streams.Messages;
import com.perforce.team.ui.streams.StreamsView;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;

public class DeleteStreamHandler
extends AbstractStreamCommandHandler
implements IHandler {
    final String OP = Messages.Stream_Delete;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        final IP4Stream stream = this.getSelectedStream();
        if (stream != null) {
            if (this.checkAndPromptActiveProjects(stream, this.OP)) {
                return null;
            }
            final String deleteStream = MessageFormat.format(Messages.DeleteStreamHandler_Delete_stream, stream.getStreamSummary().getStream());
            P4Runner.schedule((IP4Runnable)new P4Runnable(){

                public String getTitle() {
                    return deleteStream;
                }

                public void run(IProgressMonitor monitor) {
                    GetClientsOptions opts = new GetClientsOptions();
                    opts.setStream(stream.getStreamSummary().getStream());
                    final List clients = stream.getConnection().getClients(opts);
                    PerforceUIPlugin.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!clients.isEmpty()) {
                                String pattern = Messages.DeleteStreamHandler_Active_clients;
                                StringBuilder sb = new StringBuilder(MessageFormat.format(pattern, clients.size()));
                                for (IClientSummary c : clients) {
                                    sb.append(c.getName());
                                    sb.append("(");
                                    sb.append(c.getRoot());
                                    sb.append(")");
                                    sb.append("\n");
                                }
                                MessageDialog.openWarning(null, (String)deleteStream, (String)sb.toString());
                                return;
                            }
                            boolean ok = MessageDialog.openQuestion(null, (String)(this).DeleteStreamHandler.this.OP, (String)MessageFormat.format(Messages.StreamOperation_Confirmation, (this).DeleteStreamHandler.this.OP.toLowerCase(), stream.getName()));
                            if (ok) {
                                stream.getConnection().deleteStream(stream.getStreamSummary().getStream(), new StreamOptions());
                                StreamsView.showView().refresh(true, true);
                            }
                        }
                    });
                }
            });
        }
        return null;
    }
}

