/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.streams;

import com.perforce.p4java.client.IClient;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Stream;
import com.perforce.team.ui.P4ConnectionManager;
import com.perforce.team.ui.streams.Messages;
import java.text.MessageFormat;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractStreamCommandHandler
extends AbstractHandler
implements IHandler {
    protected IP4Stream getSelectedStream() {
        Object element;
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        if (selection instanceof StructuredSelection && (element = ((StructuredSelection)selection).getFirstElement()) instanceof IP4Stream) {
            IP4Stream stream = (IP4Stream)element;
            return stream;
        }
        return null;
    }

    protected boolean checkAndPromptActiveProjects(IP4Stream stream, String title) {
        String streamPath = stream.getStreamSummary().getStream();
        IP4Connection[] connections = P4ConnectionManager.getManager().getConnections();
        StringBuilder sb = new StringBuilder();
        int total = 0;
        IP4Connection[] iP4ConnectionArray = connections;
        int n = connections.length;
        int n2 = 0;
        while (n2 < n) {
            IProject[] projects;
            IClient c;
            String cs;
            IP4Connection conn = iP4ConnectionArray[n2];
            if (conn.isConnected() && streamPath.equals(cs = (c = conn.getClient()).getStream()) && (projects = conn.getMappedProjects()).length > 1) {
                IProject[] iProjectArray = projects;
                int n3 = projects.length;
                int n4 = 0;
                while (n4 < n3) {
                    IProject prj = iProjectArray[n4];
                    ++total;
                    sb.append(" ");
                    sb.append(prj.getName());
                    sb.append("\n");
                    ++n4;
                }
            }
            ++n2;
        }
        if (total > 50) {
            MessageDialog.openInformation(null, (String)title, (String)MessageFormat.format(Messages.Stream_ActiveProjects, total, ""));
            return true;
        }
        if (total > 0) {
            MessageDialog.openInformation(null, (String)title, (String)MessageFormat.format(Messages.Stream_ActiveProjects, total, sb.toString()));
            return true;
        }
        return false;
    }

    protected boolean ignoreActiveConnections(IP4Stream stream, String op) {
        String streamPath = stream.getStreamSummary().getStream();
        IP4Connection[] connections = P4ConnectionManager.getManager().getConnections();
        StringBuilder sb = new StringBuilder();
        IP4Connection[] iP4ConnectionArray = connections;
        int n = connections.length;
        int n2 = 0;
        while (n2 < n) {
            IP4Connection conn = iP4ConnectionArray[n2];
            IClient c = conn.getClient();
            String cs = c.getStream();
            if (streamPath.equals(cs)) {
                sb.append(" ");
                sb.append(conn.getName());
                sb.append("\n");
            }
            ++n2;
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
            boolean ignoreAndContinue = MessageDialog.openQuestion(null, (String)op, (String)MessageFormat.format(Messages.StreamOperation_CurrentClientConfirmation, stream.getStreamSummary().getStream(), sb.toString()));
            return ignoreAndContinue;
        }
        return true;
    }
}

