/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.shelve;

import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4PendingChangelist;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4ShelveFile;
import com.perforce.team.core.p4java.P4ShelveFile;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceLabelProvider;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.decorator.OverlayIcon;
import com.perforce.team.ui.dialogs.P4StatusDialog;
import com.perforce.team.ui.shelve.Messages;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public class UpdateShelveDialog
extends P4StatusDialog {
    public static final String SECTION_NAME = "UPDATE_SHELVE_DIALOG";
    private ViewerSorter sorter = new ViewerSorter(){

        public int compare(Viewer viewer, Object e1, Object e2) {
            String path1 = null;
            String path2 = null;
            if (e1 instanceof IP4Resource && e2 instanceof IP4Resource) {
                path1 = ((IP4Resource)e1).getRemotePath();
                path2 = ((IP4Resource)e2).getRemotePath();
            } else if (e1 instanceof ShelveChange && e2 instanceof ShelveChange) {
                ShelveChange sc1 = (ShelveChange)e1;
                ShelveChange sc2 = (ShelveChange)e2;
                if (sc1.file != null) {
                    path1 = sc1.file.getRemotePath();
                }
                if (sc2.file != null) {
                    path2 = sc2.file.getRemotePath();
                }
            }
            if (path1 != null && path2 != null) {
                return path1.compareTo(path2);
            }
            return super.compare(viewer, e1, e2);
        }
    };
    private IP4Resource[] shelved;
    private IP4Resource[] pending;
    private IP4Resource[] selected;
    private ShelveChange[] changes = new ShelveChange[0];
    private Option initialOption;
    private Composite displayArea;
    private Button replaceButton;
    private Button updateButton;
    private Button deleteButton;
    private Image checkImage;
    private Image uncheckImage;
    private Label previewLabel;
    private TableViewer previewViewer;
    private TableViewer pendingViewer;
    private TableViewer deleteViewer;
    private List<IP4Resource> pendingChecked = new ArrayList<IP4Resource>();
    private List<IP4Resource> deleteChecked = new ArrayList<IP4Resource>();
    private Button revertButton;
    private Button removeButton;
    private boolean revertChecked;
    private boolean removeChecked;

    public UpdateShelveDialog(Shell parent, IP4PendingChangelist list, IP4Resource[] selected, IP4Resource[] shelvedFiles, IP4Resource[] pendingFiles, Option option) {
        super(parent);
        this.setTitle(MessageFormat.format(Messages.UpdateShelveDialog_ShelveChangelist, list.getId()));
        this.setModalResizeStyle();
        this.selected = this.getFiles(selected);
        this.shelved = this.getFiles(shelvedFiles);
        this.pending = this.getFiles(pendingFiles);
        this.initialOption = option;
    }

    @Override
    protected String getSectionName() {
        return SECTION_NAME;
    }

    public boolean isRevertChecked() {
        return this.revertChecked;
    }

    public boolean isRemoveChecked() {
        return this.removeChecked;
    }

    private void updatePreview() {
        ShelveChange change;
        IP4File file;
        Object[] objectArray;
        ShelveChange change2;
        IP4Resource resource;
        int n;
        HashMap<String, ShelveChange> shelveChanges = new HashMap<String, ShelveChange>();
        boolean valid = false;
        if (this.replaceButton.getSelection()) {
            valid = true;
            IP4Resource[] iP4ResourceArray = this.shelved;
            n = this.shelved.length;
            int n2 = 0;
            while (n2 < n) {
                resource = iP4ResourceArray[n2];
                change2 = new ShelveChange();
                change2.option = Option.DELETE;
                change2.file = ((IP4ShelveFile)resource).getFile();
                shelveChanges.put(resource.getRemotePath(), change2);
                ++n2;
            }
            iP4ResourceArray = this.pending;
            n = this.pending.length;
            n2 = 0;
            while (n2 < n) {
                resource = iP4ResourceArray[n2];
                change2 = (ShelveChange)shelveChanges.get(resource.getRemotePath());
                if (change2 == null) {
                    change2 = new ShelveChange();
                    change2.file = (IP4File)resource;
                    change2.option = Option.ADD;
                    shelveChanges.put(resource.getRemotePath(), change2);
                } else {
                    change2.option = Option.UPDATE;
                }
                change2.file = (IP4File)resource;
                ++n2;
            }
        } else if (this.updateButton.getSelection()) {
            IP4Resource[] iP4ResourceArray = this.shelved;
            n = this.shelved.length;
            int n3 = 0;
            while (n3 < n) {
                resource = iP4ResourceArray[n3];
                change2 = new ShelveChange();
                change2.file = ((IP4ShelveFile)resource).getFile();
                shelveChanges.put(resource.getRemotePath(), change2);
                ++n3;
            }
            Object[] updates = this.pendingChecked.toArray();
            valid = updates.length > 0;
            objectArray = updates;
            int n4 = updates.length;
            n = 0;
            while (n < n4) {
                IP4Resource update = objectArray[n];
                file = (IP4File)update;
                change = (ShelveChange)shelveChanges.get(file.getRemotePath());
                if (change == null) {
                    change = new ShelveChange();
                    change.file = file;
                    change.option = Option.ADD;
                    shelveChanges.put(file.getRemotePath(), change);
                } else {
                    change.option = Option.UPDATE;
                }
                change.file = file;
                ++n;
            }
        } else if (this.deleteButton.getSelection()) {
            Object[] deletes = this.deleteChecked.toArray();
            valid = deletes.length > 0;
            objectArray = this.shelved;
            int n5 = this.shelved.length;
            n = 0;
            while (n < n5) {
                IP4Resource resource2 = objectArray[n];
                ShelveChange change3 = new ShelveChange();
                change3.file = ((IP4ShelveFile)resource2).getFile();
                shelveChanges.put(resource2.getRemotePath(), change3);
                ++n;
            }
            objectArray = deletes;
            n5 = deletes.length;
            n = 0;
            while (n < n5) {
                IP4Resource delete = objectArray[n];
                file = ((IP4ShelveFile)delete).getFile();
                change = (ShelveChange)shelveChanges.get(file.getRemotePath());
                if (change == null) {
                    change = new ShelveChange();
                    change.file = file;
                    change.option = Option.DELETE;
                    shelveChanges.put(file.getRemotePath(), change);
                } else {
                    change.option = Option.DELETE;
                }
                ++n;
            }
        }
        int nonDeletes = 0;
        this.changes = shelveChanges.values().toArray(new ShelveChange[shelveChanges.size()]);
        objectArray = this.changes;
        int n6 = this.changes.length;
        n = 0;
        while (n < n6) {
            IP4Resource change4 = objectArray[n];
            if (change4.option != Option.DELETE) {
                ++nonDeletes;
            }
            ++n;
        }
        this.previewLabel.setText(MessageFormat.format(Messages.UpdateShelveDialog_ShelvedFilesUpdatePreview, nonDeletes));
        this.previewViewer.setInput((Object)this.changes);
        if (!valid) {
            if (this.deleteButton.getSelection()) {
                this.setErrorMessage(Messages.UpdateShelveDialog_SelecteAtLeastOneFileDelete);
            } else if (this.updateButton.getSelection()) {
                this.setErrorMessage(Messages.UpdateShelveDialog_SelectAtLeastOneFileShelve);
            }
        } else {
            this.setErrorMessage(null);
        }
    }

    public void updateChanges() {
        if (this.replaceButton.getSelection()) {
            ShelveChange replaceChange = new ShelveChange();
            replaceChange.option = Option.REPLACE;
            this.changes = new ShelveChange[]{replaceChange};
        } else if (this.deleteButton.getSelection()) {
            ArrayList<ShelveChange> finalChanges = new ArrayList<ShelveChange>();
            ShelveChange[] shelveChangeArray = this.changes;
            int n = this.changes.length;
            int n2 = 0;
            while (n2 < n) {
                ShelveChange change = shelveChangeArray[n2];
                if (change.option == Option.DELETE) {
                    finalChanges.add(change);
                }
                ++n2;
            }
            this.changes = finalChanges.toArray(new ShelveChange[finalChanges.size()]);
        } else if (this.updateButton.getSelection()) {
            ArrayList<ShelveChange> finalChanges = new ArrayList<ShelveChange>();
            ShelveChange[] shelveChangeArray = this.changes;
            int n = this.changes.length;
            int n3 = 0;
            while (n3 < n) {
                ShelveChange change = shelveChangeArray[n3];
                if (change.option == Option.ADD || change.option == Option.UPDATE) {
                    finalChanges.add(change);
                }
                ++n3;
            }
            this.changes = finalChanges.toArray(new ShelveChange[finalChanges.size()]);
        } else {
            this.changes = new ShelveChange[0];
        }
    }

    protected void okPressed() {
        this.updateChanges();
        super.okPressed();
    }

    public ShelveChange[] getChanges() {
        return this.changes;
    }

    private void syncMovedFiles(TableViewer viewer, Object element, List<IP4Resource> checkedList, boolean isChecked) {
        if (viewer != null && element != null) {
            IP4ShelveFile file;
            String moved;
            IP4File pair = null;
            if (element instanceof IP4File) {
                IP4File file2 = (IP4File)element;
                String moved2 = file2.getMovedFile();
                if (moved2 != null) {
                    pair = file2.getConnection().getFile(moved2);
                }
            } else if (element instanceof IP4ShelveFile && (moved = (file = (IP4ShelveFile)element).getFile().getMovedFile()) != null) {
                IP4Resource[] iP4ResourceArray = this.shelved;
                int n = this.shelved.length;
                int n2 = 0;
                while (n2 < n) {
                    IP4Resource shelve = iP4ResourceArray[n2];
                    if (moved.equals(shelve.getRemotePath())) {
                        pair = shelve;
                        break;
                    }
                    ++n2;
                }
            }
            if (pair != null) {
                if (isChecked) {
                    checkedList.add((IP4Resource)pair);
                } else {
                    checkedList.remove(pair);
                }
                viewer.refresh((Object)pair);
            }
        }
    }

    private void createCheckColumn(final TableViewer viewer, final List<IP4Resource> checkedList, final IP4Resource[] model) {
        final TableColumn checkColumn = new TableColumn(viewer.getTable(), 0);
        checkColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                checkedList.clear();
                if (checkColumn.getImage() == UpdateShelveDialog.this.uncheckImage) {
                    checkedList.addAll(Arrays.asList(model));
                    checkColumn.setImage(UpdateShelveDialog.this.checkImage);
                } else {
                    checkColumn.setImage(UpdateShelveDialog.this.uncheckImage);
                }
                viewer.refresh();
                UpdateShelveDialog.this.updatePreview();
            }
        });
        checkColumn.setImage(this.uncheckImage);
        viewer.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection;
                Object selected;
                if (e.x >= 0 && e.x < checkColumn.getWidth() && (selected = (selection = (IStructuredSelection)viewer.getSelection()).getFirstElement()) instanceof IP4Resource) {
                    boolean isChecked;
                    boolean bl = isChecked = !checkedList.contains(selected);
                    if (isChecked) {
                        checkedList.add((IP4Resource)selected);
                    } else {
                        checkedList.remove(selected);
                    }
                    UpdateShelveDialog.this.syncMovedFiles(viewer, selected, checkedList, isChecked);
                    viewer.refresh(selected);
                    UpdateShelveDialog.this.updatePreview();
                }
            }
        });
    }

    private int computeMaxLength(Table table, IP4Resource[] resources) {
        ShelveLabelProvider provider = new ShelveLabelProvider(null, null);
        int length = 200;
        GC gc = new GC((Drawable)table.getDisplay());
        try {
            gc.setFont(table.getFont());
            IP4Resource[] iP4ResourceArray = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IP4Resource resource = iP4ResourceArray[n2];
                String text = provider.getColumnText(resource, 1);
                if (text != null) {
                    length = Math.max(length, gc.stringExtent((String)text).x);
                }
                ++n2;
            }
        }
        finally {
            gc.dispose();
        }
        return length + 25;
    }

    private void resetDeleteChecked() {
        this.deleteChecked.clear();
        IP4Resource[] iP4ResourceArray = this.shelved;
        int n = this.shelved.length;
        int n2 = 0;
        while (n2 < n) {
            IP4Resource file = iP4ResourceArray[n2];
            IP4Resource[] iP4ResourceArray2 = this.selected;
            int n3 = this.selected.length;
            int n4 = 0;
            while (n4 < n3) {
                IP4Resource select = iP4ResourceArray2[n4];
                if (file.getRemotePath().equals(select.getRemotePath())) {
                    this.deleteChecked.add(file);
                    break;
                }
                ++n4;
            }
            ++n2;
        }
    }

    private void resetPendingChecked() {
        this.pendingChecked.clear();
        IP4Resource[] iP4ResourceArray = this.pending;
        int n = this.pending.length;
        int n2 = 0;
        while (n2 < n) {
            IP4Resource file = iP4ResourceArray[n2];
            IP4Resource[] iP4ResourceArray2 = this.selected;
            int n3 = this.selected.length;
            int n4 = 0;
            while (n4 < n3) {
                IP4Resource select = iP4ResourceArray2[n4];
                if (file.getRemotePath().equals(select.getRemotePath())) {
                    this.pendingChecked.add(file);
                    break;
                }
                ++n4;
            }
            ++n2;
        }
    }

    private void createShelveViewer(Composite parent) {
        this.deleteViewer = new TableViewer(parent, 68356);
        GridData dvData = new GridData(4, 4, true, true);
        dvData.heightHint = P4UIUtils.computePixelHeight(this.deleteViewer.getTable().getFont(), 5);
        dvData.widthHint = 300;
        this.deleteViewer.getTable().setLayoutData((Object)dvData);
        this.deleteViewer.getTable().setHeaderVisible(true);
        this.deleteViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.deleteViewer.setLabelProvider((IBaseLabelProvider)new ShelveLabelProvider(this){

            @Override
            public String getColumnText(Object element, int columnIndex) {
                if (columnIndex == 0) {
                    return "";
                }
                return super.getColumnText(element, 0);
            }

            @Override
            public Image getColumnImage(Object element, int columnIndex) {
                if (columnIndex == 0) {
                    if (deleteChecked.contains(element)) {
                        return checkImage;
                    }
                    return uncheckImage;
                }
                return super.getColumnImage(element, 0);
            }
        });
        int width = this.computeMaxLength(this.deleteViewer.getTable(), this.shelved);
        this.resetDeleteChecked();
        this.deleteViewer.setInput((Object)this.shelved);
        this.createCheckColumn(this.deleteViewer, this.deleteChecked, this.shelved);
        TableColumn deleteColumn = new TableColumn(this.deleteViewer.getTable(), 0);
        deleteColumn.setText(MessageFormat.format(Messages.UpdateShelveDialog_ShelvedFiles, this.shelved.length));
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnPixelData(30));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnPixelData(width));
        this.deleteViewer.getTable().setLayout((Layout)tableLayout);
        this.deleteViewer.setSorter(this.sorter);
    }

    private void createPendingViewer(Composite parent) {
        this.pendingViewer = new TableViewer(parent, 68356);
        GridData pvData = new GridData(4, 4, true, true);
        pvData.heightHint = P4UIUtils.computePixelHeight(this.pendingViewer.getTable().getFont(), 5);
        pvData.widthHint = 300;
        this.pendingViewer.getTable().setLayoutData((Object)pvData);
        this.pendingViewer.getTable().setHeaderVisible(true);
        this.pendingViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.pendingViewer.setLabelProvider((IBaseLabelProvider)new ShelveLabelProvider(this){

            @Override
            public String getColumnText(Object element, int columnIndex) {
                if (columnIndex == 0) {
                    return "";
                }
                return super.getColumnText(element, 0);
            }

            @Override
            public Image getColumnImage(Object element, int columnIndex) {
                if (columnIndex == 0) {
                    if (pendingChecked.contains(element)) {
                        return checkImage;
                    }
                    return uncheckImage;
                }
                return super.getColumnImage(element, 0);
            }
        });
        int width = this.computeMaxLength(this.pendingViewer.getTable(), this.pending);
        this.resetPendingChecked();
        this.pendingViewer.setInput((Object)this.pending);
        this.createCheckColumn(this.pendingViewer, this.pendingChecked, this.pending);
        TableColumn pendingColumn = new TableColumn(this.pendingViewer.getTable(), 0);
        pendingColumn.setText(MessageFormat.format(Messages.UpdateShelveDialog_PendingFiles, this.pending.length));
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnPixelData(30));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnPixelData(width));
        this.pendingViewer.getTable().setLayout((Layout)tableLayout);
        this.pendingViewer.setSorter(this.sorter);
    }

    private void createPreviewViewer(Composite parent) {
        GridData plData = new GridData(4, 4, true, false);
        plData.verticalIndent = 15;
        this.previewLabel = new Label(parent, 0);
        this.previewLabel.setLayoutData((Object)plData);
        this.previewViewer = new TableViewer(parent, 67588);
        GridData vData = new GridData(4, 4, true, true);
        vData.heightHint = P4UIUtils.computePixelHeight(this.previewViewer.getTable().getFont(), 5);
        this.previewViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.previewViewer.setLabelProvider((IBaseLabelProvider)new ShelveChangeLabelProvider());
        this.previewViewer.getTable().setLayoutData((Object)vData);
        this.previewViewer.setSorter(this.sorter);
    }

    protected Control createDialogArea(Composite parent) {
        Composite c;
        block9: {
            block8: {
                c = (Composite)super.createDialogArea(parent);
                this.displayArea = new Composite(c, 0);
                this.displayArea.setLayout((Layout)new GridLayout(1, true));
                this.displayArea.setLayoutData((Object)new GridData(4, 4, true, true));
                this.checkImage = PerforceUIPlugin.getDescriptor("normal/checked.png").createImage();
                P4UIUtils.registerDisposal((Widget)this.displayArea, (Resource)this.checkImage);
                this.uncheckImage = PerforceUIPlugin.getDescriptor("normal/unchecked.png").createImage();
                P4UIUtils.registerDisposal((Widget)this.displayArea, (Resource)this.uncheckImage);
                SelectionAdapter optionListener = new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        UpdateShelveDialog.this.pendingViewer.getTable().setEnabled(UpdateShelveDialog.this.updateButton.getSelection());
                        UpdateShelveDialog.this.deleteViewer.getTable().setEnabled(UpdateShelveDialog.this.deleteButton.getSelection());
                        UpdateShelveDialog.this.updatePreview();
                    }
                };
                Composite topArea = new Composite(this.displayArea, 0);
                GridLayout taLayout = new GridLayout(2, true);
                taLayout.verticalSpacing = 2;
                taLayout.marginHeight = 0;
                taLayout.marginWidth = 0;
                topArea.setLayout((Layout)taLayout);
                topArea.setLayoutData((Object)new GridData(4, 4, true, true));
                this.createPendingViewer(topArea);
                this.createShelveViewer(topArea);
                this.updateButton = new Button(this.displayArea, 16);
                this.updateButton.setText(Messages.UpdateShelveDialog_ShelveSelectedFiles);
                this.updateButton.addSelectionListener((SelectionListener)optionListener);
                this.replaceButton = new Button(this.displayArea, 16);
                this.replaceButton.setText(Messages.UpdateShelveDialog_ReplaceShelvedFiles);
                this.replaceButton.addSelectionListener((SelectionListener)optionListener);
                this.replaceButton.setEnabled(this.pending.length > 0);
                this.deleteButton = new Button(this.displayArea, 16);
                this.deleteButton.setText(Messages.UpdateShelveDialog_DeleteSelectedShelvedFiles);
                this.deleteButton.addSelectionListener((SelectionListener)optionListener);
                if (this.initialOption == null) break block8;
                switch (this.initialOption) {
                    case UPDATE: 
                    case ADD: 
                    case UNCHANGED: {
                        this.updateButton.setSelection(true);
                        break;
                    }
                    case DELETE: {
                        this.deleteButton.setSelection(true);
                        break;
                    }
                    case REPLACE: {
                        if (this.replaceButton.isEnabled()) {
                            this.replaceButton.setSelection(true);
                            break;
                        } else {
                            break;
                        }
                    }
                }
                break block9;
            }
            this.updateButton.setSelection(true);
        }
        if (!this.updateButton.getSelection()) {
            this.pendingViewer.getTable().setEnabled(false);
        }
        if (!this.deleteButton.getSelection()) {
            this.deleteViewer.getTable().setEnabled(false);
        }
        Composite bottomArea = new Composite(this.displayArea, 0);
        GridLayout baLayout = new GridLayout(1, true);
        baLayout.marginHeight = 0;
        baLayout.marginWidth = 0;
        baLayout.verticalSpacing = 2;
        bottomArea.setLayout((Layout)baLayout);
        bottomArea.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createPreviewViewer(bottomArea);
        this.revertButton = new Button(this.displayArea, 32);
        this.revertButton.setText(Messages.ConfirmShelveDialog_RevertCheckedOutFiles);
        this.removeButton = new Button(this.displayArea, 32);
        this.removeButton.setText(Messages.ConfirmShelveDialog_RemoveFilesOpenedForAdd);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!UpdateShelveDialog.this.revertButton.getSelection()) {
                    UpdateShelveDialog.this.removeButton.setEnabled(false);
                    UpdateShelveDialog.this.removeButton.setSelection(false);
                    return;
                }
                UpdateShelveDialog.this.removeButton.setEnabled(true);
                UpdateShelveDialog.this.revertChecked = UpdateShelveDialog.this.revertButton.getSelection();
                UpdateShelveDialog.this.removeChecked = UpdateShelveDialog.this.removeButton.getSelection();
            }
        };
        this.revertButton.addSelectionListener((SelectionListener)listener);
        this.removeButton.addSelectionListener((SelectionListener)listener);
        listener.widgetSelected(null);
        this.updatePreview();
        return c;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okStatusButton = this.createButton(parent, 0, Messages.UpdateShelveDialog_Update, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    public static enum Option {
        UPDATE,
        ADD,
        DELETE,
        UNCHANGED,
        REPLACE;

    }

    public static class ShelveChange {
        public IP4File file;
        public Option option = Option.UNCHANGED;
    }

    private class ShelveChangeLabelProvider
    extends ShelveLabelProvider {
        private Map<OverlayIcon, Image> changeImages;

        private ShelveChangeLabelProvider() {
            this.changeImages = new HashMap<OverlayIcon, Image>();
        }

        private Image decorateChange(Image base, String descriptorPath) {
            Image decorated = null;
            Rectangle imageBounds = base.getBounds();
            ImageDescriptor[] descriptor = new ImageDescriptor[]{PerforceUIPlugin.getDescriptor(descriptorPath)};
            ImageData descData = descriptor[0].getImageData();
            int width = imageBounds.width + descData.width;
            int height = Math.max(imageBounds.height, descData.height);
            OverlayIcon icon = new OverlayIcon(base, descriptor, new int[]{1}, width, height, descData.width, 0);
            decorated = this.changeImages.get((Object)icon);
            if (decorated == null) {
                decorated = icon.createImage();
                this.changeImages.put(icon, decorated);
            }
            return decorated;
        }

        @Override
        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof ShelveChange) {
                element = ((ShelveChange)element).file;
            }
            return super.getColumnText(element, columnIndex);
        }

        @Override
        public Image getColumnImage(Object element, int columnIndex) {
            if (element instanceof ShelveChange) {
                ShelveChange change = (ShelveChange)element;
                Image image = super.getColumnImage(change.file, columnIndex);
                switch (change.option) {
                    case UPDATE: {
                        image = this.decorateChange(image, "normal/shelve_update.png");
                        break;
                    }
                    case ADD: {
                        image = this.decorateChange(image, "normal/shelve_add.png");
                        break;
                    }
                    case DELETE: {
                        image = this.decorateChange(image, "normal/shelve_delete.png");
                        break;
                    }
                    case UNCHANGED: {
                        image = this.decorateChange(image, "normal/empty.png");
                        break;
                    }
                }
                return image;
            }
            return null;
        }

        @Override
        public void dispose() {
            super.dispose();
            for (Image image : this.changeImages.values()) {
                image.dispose();
            }
        }
    }

    private class ShelveLabelProvider
    extends PerforceLabelProvider {
        private ShelveLabelProvider() {
        }

        @Override
        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof P4ShelveFile) {
                element = ((P4ShelveFile)element).getFile();
            }
            if (element instanceof IP4Resource) {
                String path = ((IP4Resource)element).getActionPath(IP4Resource.Type.REMOTE);
                String decorated = this.decorator.getLabelDecorator().decorateText(path, element);
                if (decorated != null) {
                    path = decorated;
                }
                return path;
            }
            return super.getColumnText(element, columnIndex);
        }

        @Override
        public Image getColumnImage(Object element, int columnIndex) {
            if (element instanceof P4ShelveFile) {
                element = ((P4ShelveFile)element).getFile();
            }
            return super.getColumnImage(element, columnIndex);
        }

        /* synthetic */ ShelveLabelProvider(ShelveLabelProvider shelveLabelProvider, ShelveLabelProvider shelveLabelProvider2) {
            this();
        }
    }
}

