/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.shelve;

import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4PendingChangelist;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.IP4ShelveFile;
import com.perforce.team.core.p4java.IP4ShelvedChangelist;
import com.perforce.team.core.p4java.P4Collection;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.ui.P4ConnectionManager;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.p4java.actions.P4Action;
import com.perforce.team.ui.shelve.Messages;
import com.perforce.team.ui.shelve.UnshelveDialog;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;

public class UnshelveAction
extends P4Action {
    @Override
    protected boolean isEnabledEx() {
        boolean enabled = false;
        if (this.getSelection() != null) {
            Object[] objectArray = this.getSelection().toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object select = objectArray[n2];
                if (select instanceof IP4ShelvedChangelist) {
                    IP4ShelvedChangelist shelveList = (IP4ShelvedChangelist)select;
                    if (shelveList.needsRefresh()) {
                        shelveList.refresh();
                    }
                    enabled = shelveList.members().length > 0;
                } else if (select instanceof IP4ShelveFile) {
                    enabled = true;
                }
                if (enabled) break;
                ++n2;
            }
        }
        return enabled;
    }

    @Override
    protected void runAction() {
        final ArrayList<IP4Resource> resources = new ArrayList<IP4Resource>();
        if (this.getSelection() != null) {
            Object[] objectArray = this.getSelection().toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object select = objectArray[n2];
                if (select instanceof IP4Resource) {
                    resources.add((IP4Resource)select);
                }
                ++n2;
            }
        }
        if (!resources.isEmpty()) {
            P4Runnable runnable = new P4Runnable(){

                public String getTitle() {
                    return Messages.UnshelveAction_Unshelving;
                }

                public void run(IProgressMonitor monitor) {
                    IP4ShelvedChangelist list;
                    HashMap<IP4ShelvedChangelist, List<IP4Resource>> listMappings = new HashMap<IP4ShelvedChangelist, List<IP4Resource>>();
                    for (IP4Resource resource : resources) {
                        if (!(resource instanceof IP4ShelveFile)) continue;
                        list = ((IP4ShelveFile)resource).getChangelist();
                        ArrayList<IP4Resource> listFiles = (ArrayList<IP4Resource>)listMappings.get(list);
                        if (listFiles == null) {
                            listFiles = new ArrayList<IP4Resource>();
                            listMappings.put(list, listFiles);
                        }
                        listFiles.add(resource);
                    }
                    for (IP4Resource resource : resources) {
                        if (!(resource instanceof IP4ShelvedChangelist)) continue;
                        list = (IP4ShelvedChangelist)resource;
                        list.refresh();
                        listMappings.put(list, Arrays.asList(list.members()));
                    }
                    monitor.beginTask(Messages.UnshelveAction_Unshelving, listMappings.size() + 1);
                    P4Collection refreshCollection = UnshelveAction.this.createCollection();
                    for (Map.Entry entry : listMappings.entrySet()) {
                        IP4ShelvedChangelist list2 = (IP4ShelvedChangelist)entry.getKey();
                        List files = (List)entry.getValue();
                        monitor.subTask(MessageFormat.format(Messages.UnshelveAction_ChangelistNum, list2.getId()));
                        IFileSpec[] specs = UnshelveAction.this.unshelve(list2, files.toArray(new IP4Resource[files.size()]), monitor);
                        P4Collection listCollection = P4Collection.getValidCollection((IP4Connection)list2.getConnection(), Arrays.asList(specs), (IP4Resource.Type)refreshCollection.getType());
                        refreshCollection.addAll(listCollection);
                        monitor.worked(1);
                    }
                    monitor.subTask(Messages.UnshelveAction_RefreshingUnshelvedFiles);
                    if (!refreshCollection.isEmpty()) {
                        refreshCollection.refresh();
                        refreshCollection.refreshLocalResources(1);
                    }
                    monitor.worked(1);
                    monitor.done();
                }
            };
            this.runRunnable((IP4Runnable)runnable);
        }
    }

    private int createChangelist(IP4Connection connection, String description) {
        IP4PendingChangelist newPending = connection.createChangelist(description, null);
        return newPending != null ? newPending.getId() : -1;
    }

    private void revert(IP4Resource[] resources, IProgressMonitor monitor) {
        monitor.subTask(Messages.UnshelveAction_RevertingFiles);
        P4Collection collection = this.createCollection();
        IP4Resource[] iP4ResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            String path;
            IP4Resource resource = iP4ResourceArray[n2];
            if (resource instanceof IP4File && (path = resource.getRemotePath()) != null) {
                resource = resource.getConnection().getFile(resource.getRemotePath());
                collection.add(resource);
            }
            ++n2;
        }
        if (!collection.isEmpty()) {
            collection.revert();
        }
    }

    private IFileSpec[] unshelve(final IP4ShelvedChangelist list, IP4Resource[] files, IProgressMonitor monitor) {
        if (files != null && files.length > 0) {
            final int[] id = new int[]{-1};
            final IP4Connection connection = list.getConnection();
            IP4PendingChangelist activeList = connection.getActivePendingChangelist();
            if (activeList != null) {
                id[0] = activeList.getId();
            }
            final boolean[] active = new boolean[1];
            final boolean[] overwrite = new boolean[1];
            final boolean[] revert = new boolean[1];
            final String[] comment = new String[1];
            ArrayList<IP4Resource> p4Files = new ArrayList<IP4Resource>();
            IP4Resource[] iP4ResourceArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                IP4Resource resource = iP4ResourceArray[n2];
                if (resource instanceof IP4ShelveFile) {
                    resource = ((IP4ShelveFile)resource).getFile();
                }
                p4Files.add(resource);
                ++n2;
            }
            final IP4Resource[][] selected = new IP4Resource[][]{(IP4Resource[])p4Files.toArray(new IP4File[p4Files.size()])};
            if (id[0] < 0) {
                PerforceUIPlugin.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        UnshelveDialog dialog = new UnshelveDialog(P4UIUtils.getDialogShell(), selected[0], connection, list.getId(), MessageFormat.format(Messages.UnshelveAction_UnshelvingFilesFromChangelist, list.getId()));
                        if (dialog.open() == 0) {
                            id[0] = dialog.getSelectedChangeId();
                            active[0] = dialog.useSelected();
                            selected[0] = dialog.getSelectedFiles();
                            overwrite[0] = dialog.isForceWritable();
                            revert[0] = dialog.isRevert();
                            comment[0] = dialog.getDescription();
                        } else {
                            selected[0] = null;
                        }
                    }
                });
            }
            if (selected[0] != null) {
                if (revert[0]) {
                    this.revert(selected[0], monitor);
                }
                if (id[0] == -2) {
                    monitor.subTask(Messages.UnshelveAction_CreatingNewPendingChangelist);
                    id[0] = this.createChangelist(connection, comment[0]);
                }
                if (id[0] >= 0) {
                    if (active[0]) {
                        connection.setActivePendingChangelist(id[0]);
                    }
                    monitor.subTask(Messages.UnshelveAction_UnshelvingFiles);
                    return list.unshelve(selected[0], id[0], overwrite[0]);
                }
            }
        } else {
            PerforceUIPlugin.syncExec(new Runnable(){

                @Override
                public void run() {
                    P4ConnectionManager.getManager().openInformation(P4UIUtils.getDialogShell(), Messages.UnshelveAction_NoShelvedFiles, MessageFormat.format(Messages.UnshelveAction_ChangelistContainsNoShelvedFiles, list.getId()));
                }
            });
        }
        return new IFileSpec[0];
    }
}

