/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.shelve;

import com.perforce.team.core.p4java.IP4PendingChangelist;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.IP4ShelvedChangelist;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.ui.p4java.actions.P4Action;
import com.perforce.team.ui.shelve.Messages;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;

public class DeleteShelveAction
extends P4Action {
    @Override
    public boolean isEnabledEx() {
        IP4Resource resource = this.getSingleOnlineResourceSelection();
        return resource != null && !resource.isReadOnly();
    }

    @Override
    protected void runAction() {
        IP4Resource resource = this.getSingleOnlineResourceSelection();
        if (resource instanceof IP4ShelvedChangelist && !resource.isReadOnly()) {
            final IP4ShelvedChangelist list = (IP4ShelvedChangelist)resource;
            P4Runnable runnable = new P4Runnable(){

                public void run(IProgressMonitor monitor) {
                    IP4PendingChangelist pending = list.getConnection().getPendingChangelist(list.getId(), true);
                    if (pending != null) {
                        pending.deleteShelved();
                        if (pending.needsRefresh()) {
                            pending.refresh();
                        }
                    }
                }

                public String getTitle() {
                    return MessageFormat.format(Messages.DeleteShelveAction_DeletingShelvedChangelist, list.getId());
                }
            };
            this.runRunnable((IP4Runnable)runnable);
        }
    }
}

