/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.shelve;

import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4PendingChangelist;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.changelists.DescriptionViewer;
import com.perforce.team.ui.dialogs.FileListViewer;
import com.perforce.team.ui.dialogs.P4StatusDialog;
import com.perforce.team.ui.shelve.Messages;
import java.text.MessageFormat;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ConfirmShelveDialog
extends P4StatusDialog {
    public static final String NEW_SHELVED_CHANGELIST_DESCRIPTION = Messages.ConfirmShelveDialog_NewShelvedChangelistDescription;
    private IP4PendingChangelist list;
    private IP4File[] files;
    private FileListViewer viewer;
    private DescriptionViewer descriptionViewer;
    private IP4File[] selectedFiles;
    private String description;
    private Button revertButton;
    private Button removeButton;
    private Label countLabel;
    private boolean revertChecked;
    private boolean removeChecked;

    public ConfirmShelveDialog(Shell parent, IP4PendingChangelist list, IP4File[] files) {
        super(parent);
        String changeString = list.isDefault() ? Messages.ConfirmShelveDialog_DefaultChangelist : MessageFormat.format(Messages.ConfirmShelveDialog_ChangelistNum, list.getId());
        this.setTitle(MessageFormat.format(Messages.ConfirmShelveDialog_ShelveFilesFromChangelist, files.length, changeString));
        this.setModalResizeStyle();
        this.list = list;
        this.files = files;
    }

    public int getChangelist() {
        return this.list.isDefault() ? -2 : this.list.getId();
    }

    public IP4File[] getSelectedFiles() {
        return this.selectedFiles;
    }

    private void updateCount() {
        int count = this.viewer.getCheckedElements().length;
        int max = this.viewer.getTable().getItemCount();
        this.countLabel.setText(MessageFormat.format(Messages.ConfirmShelveDialog_FilesSelected, count, max));
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isRevertChecked() {
        return this.revertChecked;
    }

    public boolean isRemoveChecked() {
        return this.removeChecked;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(dialogArea, 0);
        GridLayout cLayout = new GridLayout(1, true);
        cLayout.marginHeight = 0;
        cLayout.marginWidth = 0;
        cLayout.verticalSpacing = 2;
        composite.setLayout((Layout)cLayout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.countLabel = new Label(composite, 16384);
        GridData clData = new GridData(4, 4, true, false);
        clData.verticalIndent = 5;
        clData.horizontalSpan = 2;
        this.countLabel.setLayoutData((Object)clData);
        this.viewer = new FileListViewer(composite, this.files, this.files, false);
        ((GridData)this.viewer.getTable().getLayoutData()).horizontalSpan = 2;
        this.viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ConfirmShelveDialog.this.updateCount();
                ConfirmShelveDialog.this.validate();
            }
        });
        Label descriptionLabel = new Label(composite, 0);
        descriptionLabel.setText(Messages.ConfirmShelveDialog_Description);
        this.description = NEW_SHELVED_CHANGELIST_DESCRIPTION;
        this.descriptionViewer = new DescriptionViewer((IP4Resource)this.list.getConnection());
        this.descriptionViewer.createControl(composite, this.description);
        this.descriptionViewer.getDocument().addDocumentListener(new IDocumentListener(){

            public void documentChanged(DocumentEvent event) {
                ConfirmShelveDialog.this.description = ConfirmShelveDialog.this.descriptionViewer.getDocument().get();
                ConfirmShelveDialog.this.validate();
            }

            public void documentAboutToBeChanged(DocumentEvent event) {
            }
        });
        StyledText styledText = this.descriptionViewer.getViewer().getTextWidget();
        ((GridData)styledText.getLayoutData()).heightHint = P4UIUtils.computePixelHeight(styledText.getFont(), 5);
        this.descriptionViewer.setFocus();
        this.validate();
        this.revertButton = new Button(composite, 32);
        this.revertButton.setText(Messages.ConfirmShelveDialog_RevertCheckedOutFiles);
        this.removeButton = new Button(composite, 32);
        this.removeButton.setText(Messages.ConfirmShelveDialog_RemoveFilesOpenedForAdd);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!ConfirmShelveDialog.this.revertButton.getSelection()) {
                    ConfirmShelveDialog.this.removeButton.setEnabled(false);
                    ConfirmShelveDialog.this.removeButton.setSelection(false);
                    return;
                }
                ConfirmShelveDialog.this.removeButton.setEnabled(true);
                ConfirmShelveDialog.this.revertChecked = ConfirmShelveDialog.this.revertButton.getSelection();
                ConfirmShelveDialog.this.removeChecked = ConfirmShelveDialog.this.removeButton.getSelection();
            }
        };
        this.revertButton.addSelectionListener((SelectionListener)listener);
        this.removeButton.addSelectionListener((SelectionListener)listener);
        listener.widgetSelected(null);
        return dialogArea;
    }

    private void validate() {
        String errorMessage = null;
        if (this.viewer.getCheckedElements().length == 0) {
            errorMessage = Messages.ConfirmShelveDialog_MustSelectAtLeastOneFile;
        }
        if (errorMessage == null && this.description.length() == 0) {
            errorMessage = Messages.ConfirmShelveDialog_EnterChangelistDescription;
        }
        if (errorMessage != null) {
            this.setErrorMessage(errorMessage);
        } else {
            this.setInfoMessage(Messages.ConfirmShelveDialog_SelectedFilesWillBeReopenedBeforeShelving);
        }
    }

    public void updateSelection() {
        Object[] elements = this.viewer.getCheckedElements();
        this.selectedFiles = new IP4File[elements.length];
        System.arraycopy(elements, 0, this.selectedFiles, 0, this.selectedFiles.length);
    }

    protected void okPressed() {
        this.updateSelection();
        super.okPressed();
    }
}

