/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.server;

import com.perforce.p4java.server.IServerInfo;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.ui.dialogs.DialogUtils;
import com.perforce.team.ui.dialogs.PerforceDialog;
import com.perforce.team.ui.p4java.actions.EditClientAction;
import com.perforce.team.ui.server.Messages;
import java.text.MessageFormat;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ServerInfoDialog
extends PerforceDialog {
    private static final int NUM_CHARS = 80;
    private IP4Connection connection;
    private Composite displayArea;
    private Group serverArea;
    private Link editClientLink;
    private Text addressText;
    private Text rootText;
    private Text dateText;
    private Text uptimeText;
    private Text versionText;
    private Text licenseText;
    private Group clientArea;

    public static void showServerInfo(Shell shell, IP4Connection connection) {
        ServerInfoDialog.showServerInfo(shell, connection, true);
    }

    public static ServerInfoDialog showServerInfo(Shell shell, IP4Connection connection, boolean block) {
        ServerInfoDialog dialog = new ServerInfoDialog(shell, connection);
        dialog.setBlockOnOpen(block);
        dialog.open();
        return dialog;
    }

    public ServerInfoDialog(Shell parent, IP4Connection connection) {
        super(parent, Messages.ServerInfoDialog_ConnectionInformation);
        this.connection = connection;
        if (this.connection.getAddress() != null) {
            this.title = MessageFormat.format(Messages.ServerInfoDialog_ConnectionInformationFor, this.connection.getAddress());
        }
        this.setModalResizeStyle();
    }

    protected Control createDialogArea(Composite parent) {
        Composite c = (Composite)super.createDialogArea(parent);
        this.displayArea = new Composite(c, 0);
        GridData daData = new GridData(4, 4, true, true);
        this.displayArea.setLayoutData((Object)daData);
        this.displayArea.setLayout((Layout)new GridLayout(1, true));
        GridData textData = new GridData();
        textData.grabExcessHorizontalSpace = true;
        textData.horizontalAlignment = 4;
        GC gc = new GC((Drawable)c);
        gc.setFont(c.getFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        textData.widthHint = Dialog.convertWidthInCharsToPixels((FontMetrics)fontMetrics, (int)80);
        GridLayout groupLayout = new GridLayout(2, false);
        this.createClientArea(groupLayout, textData);
        this.createServerArea(groupLayout, textData);
        return c;
    }

    private void createClientArea(GridLayout groupLayout, GridData textData) {
        this.clientArea = new Group(this.displayArea, 0);
        this.clientArea.setText(Messages.ServerInfoDialog_ClientInformation);
        this.clientArea.setLayout((Layout)groupLayout);
        this.clientArea.setLayoutData((Object)new GridData(4, 4, true, false));
        this.editClientLink = new Link((Composite)this.clientArea, 0);
        this.editClientLink.setText(Messages.ServerInfoDialog_EditClient);
        this.editClientLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditClientAction edit = new EditClientAction();
                edit.selectionChanged(null, (ISelection)new StructuredSelection((Object)ServerInfoDialog.this.connection));
                ServerInfoDialog.this.close();
                edit.run(null);
            }
        });
        GridData eclData = new GridData(0x1000008, 4, true, false);
        eclData.horizontalSpan = 2;
        this.editClientLink.setLayoutData((Object)eclData);
        this.addField(this.clientArea, Messages.ServerInfoDialog_ClientName, this.connection.getClientName(), textData);
        this.addField(this.clientArea, Messages.ServerInfoDialog_ClientHost, this.connection.getServerInfoClientHost(), textData);
        this.addField(this.clientArea, Messages.ServerInfoDialog_ClientRoot, this.connection.getClientRoot(), textData);
        this.addField(this.clientArea, Messages.ServerInfoDialog_ClientAddress, this.connection.getServerInfoClientAddress(), textData);
    }

    private void createServerArea(GridLayout groupLayout, GridData textData) {
        this.serverArea = new Group(this.displayArea, 0);
        this.serverArea.setText(Messages.ServerInfoDialog_ServerInformation);
        this.serverArea.setLayout((Layout)groupLayout);
        this.serverArea.setLayoutData((Object)new GridData(4, 4, true, false));
        this.addressText = this.addField(this.serverArea, Messages.ServerInfoDialog_ServerAddress, this.connection.getAddress(), textData);
        this.rootText = this.addField(this.serverArea, Messages.ServerInfoDialog_ServerRoot, this.connection.getRoot(), textData);
        this.dateText = this.addField(this.serverArea, Messages.ServerInfoDialog_ServerDate, this.connection.getDate(), textData);
        this.uptimeText = this.addField(this.serverArea, Messages.ServerInfoDialog_ServerUptime, this.connection.getUptime(), textData);
        this.versionText = this.addField(this.serverArea, Messages.ServerInfoDialog_ServerVersion, this.connection.getVersion(), textData);
        this.licenseText = this.addField(this.serverArea, Messages.ServerInfoDialog_ServerLicense, this.connection.getLicense(), textData);
        IServerInfo info = this.connection.getServerInfo();
        if (info == null) {
            return;
        }
        this.addField(this.serverArea, Messages.ServerInfoDialog_ServerEncryption, info.isServerEncrypted() ? "encrypted" : null, textData);
        this.addField(this.serverArea, Messages.ServerInfoDialog_BrokerVersion, info.getBrokerVersion(), textData);
        this.addField(this.serverArea, Messages.ServerInfoDialog_BrokerAddress, info.getBrokerAddress(), textData);
        this.addField(this.serverArea, Messages.ServerInfoDialog_BrokerEncryption, info.isBrokerEncrypted() ? "encrypted" : null, textData);
        this.addField(this.serverArea, Messages.ServerInfoDialog_SandboxVersion, info.getSandboxVersion(), textData);
        this.addField(this.serverArea, Messages.ServerInfoDialog_SandboxPort, info.getSandboxPort(), textData);
    }

    private Text addField(Group area, String labelText, String value, GridData textData) {
        if (value == null) {
            return null;
        }
        this.createLabel((Composite)area, labelText);
        Text text = DialogUtils.createSelectableLabel((Composite)area, textData);
        text.setText(value);
        return text;
    }

    public String getAddress() {
        return this.addressText.getText();
    }

    public String getVersion() {
        return this.versionText.getText();
    }

    public String getLicense() {
        return this.licenseText.getText();
    }

    public String getUptime() {
        return this.uptimeText.getText();
    }

    public String getRoot() {
        return this.rootText.getText();
    }

    public String getDate() {
        return this.dateText.getText();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }
}

