/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.project;

import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.ui.BaseErrorProvider;
import com.perforce.team.ui.project.Messages;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ShareProjectsWidget
extends BaseErrorProvider {
    private IP4Connection connection = null;
    private IProject[] projects = null;
    private IProject[] unmanaged = null;
    private Composite displayArea;
    private CheckboxTableViewer projectViewer;
    private Button selectAll;
    private Button deselectAll;

    public ShareProjectsWidget(IP4Connection connection) {
        this.connection = connection;
    }

    public IProject[] getProjects() {
        return this.projects;
    }

    public void validateCreate() {
        if (this.unmanaged.length == 0) {
            this.errorMessage = Messages.ShareProjectsWidget_NoUnsharedProjectsInWorkspace;
            super.validate();
        }
    }

    @Override
    public void validate() {
        Object[] checked = this.projectViewer.getCheckedElements();
        this.errorMessage = checked.length == 0 ? Messages.ShareProjectsWidget_MustSelectAtLeastOneProject : null;
        super.validate();
    }

    public void createControl(Composite parent) {
        this.displayArea = new Composite(parent, 0);
        GridLayout daLayout = new GridLayout(1, true);
        this.displayArea.setLayout((Layout)daLayout);
        this.displayArea.setLayoutData((Object)new GridData(4, 4, true, true));
        Label connectionLabel = new Label(this.displayArea, 16384);
        connectionLabel.setText(MessageFormat.format(Messages.ShareProjectsWidget_Connection, this.connection.getName()));
        this.projectViewer = CheckboxTableViewer.newCheckList((Composite)this.displayArea, (int)68356);
        GridData pvData = new GridData(4, 4, true, true);
        pvData.heightHint = 100;
        pvData.widthHint = 400;
        this.projectViewer.getTable().setLayoutData((Object)pvData);
        this.projectViewer.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Object[] checked = ShareProjectsWidget.this.projectViewer.getCheckedElements();
                ShareProjectsWidget.this.projects = new IProject[checked.length];
                System.arraycopy(checked, 0, ShareProjectsWidget.this.projects, 0, checked.length);
            }
        });
        this.projectViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.projectViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        ArrayList<IProject> unmanagedProject = new ArrayList<IProject>();
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.isAccessible() && !RepositoryProvider.isShared((IProject)project)) {
                unmanagedProject.add(project);
            }
            ++n2;
        }
        this.unmanaged = unmanagedProject.toArray(new IProject[unmanagedProject.size()]);
        this.projectViewer.setInput((Object)this.unmanaged);
        Composite buttons = new Composite(this.displayArea, 0);
        GridLayout bLayout = new GridLayout(2, false);
        buttons.setLayout((Layout)bLayout);
        buttons.setLayoutData((Object)new GridData(4, 4, true, false));
        this.selectAll = new Button(buttons, 8);
        this.selectAll.setLayoutData((Object)new GridData(0x1000008, 4, true, false));
        this.selectAll.setText(Messages.ShareProjectsWidget_SelectAll);
        this.selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ShareProjectsWidget.this.projectViewer.setAllChecked(true);
                ShareProjectsWidget.this.validate();
            }
        });
        this.deselectAll = new Button(buttons, 8);
        this.deselectAll.setText(Messages.ShareProjectsWidget_DeselectAll);
        this.deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ShareProjectsWidget.this.projectViewer.setAllChecked(false);
                ShareProjectsWidget.this.validate();
            }
        });
        if (this.unmanaged.length == 0) {
            this.selectAll.setEnabled(false);
            this.deselectAll.setEnabled(false);
        }
        this.projectViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ShareProjectsWidget.this.validate();
            }
        });
    }
}

