/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.project;

import com.perforce.team.ui.dialogs.P4StatusDialog;
import com.perforce.team.ui.project.Messages;
import java.text.MessageFormat;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ProjectNameDialog
extends P4StatusDialog {
    private String projectName = null;
    private boolean showInUseMessage = true;

    public ProjectNameDialog(Shell parent, String projectName, String title, boolean showInUseMessage) {
        super(parent);
        this.setTitle(title);
        this.setModalResizeStyle();
        this.projectName = projectName;
        this.showInUseMessage = showInUseMessage;
    }

    public ProjectNameDialog(Shell parent, String projectName) {
        this(parent, projectName, Messages.ProjectNameDialog_ProjectNameInUse, true);
    }

    public String getEnteredName() {
        return this.projectName;
    }

    private String getExistsMessage(String name) {
        return MessageFormat.format(Messages.ProjectNameDialog_ProjectAlreadyExists, name);
    }

    private void validate() {
        if (this.projectName != null) {
            Path path = new Path(this.projectName);
            if (path.isValidSegment(this.projectName)) {
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.projectName);
                if (project != null && project.exists()) {
                    this.setErrorMessage(this.getExistsMessage(this.projectName));
                    return;
                }
            } else {
                this.setErrorMessage(Messages.ProjectNameDialog_ProjectNameInvalid);
                return;
            }
        }
        this.setErrorMessage(null);
    }

    protected Control createDialogArea(Composite parent) {
        Composite c = (Composite)super.createDialogArea(parent);
        Composite displayArea = new Composite(parent, 0);
        displayArea.setLayout((Layout)new GridLayout(2, false));
        displayArea.setLayoutData((Object)new GridData(4, 4, true, true));
        if (this.projectName != null && this.showInUseMessage) {
            Label originalLabel = new Label(displayArea, 0);
            GridData olData = new GridData(4, 4, true, false);
            olData.horizontalSpan = 2;
            originalLabel.setLayoutData((Object)olData);
            originalLabel.setText(MessageFormat.format(Messages.ProjectNameDialog_ProjectAlreadyExists2, this.projectName));
        }
        Label projectLabel = new Label(displayArea, 0);
        projectLabel.setText(Messages.ProjectNameDialog_ProjectName);
        final Text projectText = new Text(displayArea, 2052);
        GridData ptData = new GridData(4, 4, true, false);
        ptData.widthHint = 200;
        projectText.setLayoutData((Object)ptData);
        if (this.projectName != null) {
            projectText.setText(this.projectName);
            projectText.selectAll();
            projectText.setFocus();
        }
        projectText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ProjectNameDialog.this.projectName = projectText.getText().trim();
                ProjectNameDialog.this.validate();
            }
        });
        this.validate();
        return c;
    }
}

