/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.preferences.decorators;

import com.perforce.p4java.core.file.FileAction;
import com.perforce.team.core.ConnectionParameters;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.decorator.IconCache;
import com.perforce.team.ui.decorator.PerforceDecorator;
import com.perforce.team.ui.preferences.IPreferenceConstants;
import com.perforce.team.ui.preferences.decorators.Messages;
import com.perforce.team.ui.preferences.decorators.PreviewConnection;
import com.perforce.team.ui.preferences.decorators.PreviewP4File;
import com.perforce.team.ui.preferences.decorators.VariablesDialog;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class LabelPreviewPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "com.perforce.team.ui.dialogs.DecorationsPreferencesDialog";
    private static final String[] ICON_POSITIONS = new String[]{Messages.LabelPreviewPreferencePage_None, Messages.LabelPreviewPreferencePage_TopLeft, Messages.LabelPreviewPreferencePage_TopRight, Messages.LabelPreviewPreferencePage_BottomLeft, Messages.LabelPreviewPreferencePage_BottomRight};
    private Composite displayArea;
    private Link labelDecoratorsLink;
    private TabFolder labelTabs;
    private TabItem generalTab;
    private Composite generalArea;
    private Button showChangelistInSyncButton;
    private TabItem iconTab;
    private Composite iconArea;
    private Combo sharedProjectsCombo;
    private Combo openFilesCombo;
    private Combo syncedFilesCombo;
    private Combo notSyncedFilesCombo;
    private Combo lockedFilesCombo;
    private Combo unresolvedFilesCombo;
    private Combo openElsewhereFilesCombo;
    private Combo ignoredFilesCombo;
    private Combo localFilesCombo;
    private Combo streamSandboxCombo;
    private Combo streamSandboxProjectCombo;
    private Button unmanagedFilesButton;
    private TabItem textTab;
    private Composite textArea;
    private Button ignoreButton;
    private Text ignoreText;
    private Text projectText;
    private Button projectVariablesButton;
    private Text connectText;
    private Button connectVariablesButton;
    private Text fileText;
    private Button fileVariablesButton;
    private Text outgoingChangeText;
    private Text unaddedChangeText;
    private TreeViewer previewTree;
    private IP4Connection onlineConnection;
    private IP4Connection offlineConnection;
    private IP4Connection onlineSandboxConnection;
    private IP4Connection offlineSandboxConnection;
    private Project onlineProject;
    private Project offlineProject;
    private Project sandboxProject;
    private Project offlineSandboxProject;
    private Folder ignoredFolder;
    private PreviewP4File addedFile;
    private PreviewP4File editedFile;
    private PreviewP4File deletedFile;
    private PreviewP4File unresolvedFile;
    private PreviewP4File lockedFile;
    private PreviewP4File syncedFile;
    private PreviewP4File notSyncedFile;
    private PreviewP4File addedElsewhereFile;
    private PreviewP4File editedElsewhereFile;
    private PreviewP4File deletedElsewhereFile;
    private PreviewP4File ignoredFile;
    private PreviewP4File unmanagedFile;
    private PreviewP4File localOnly;
    private PreviewP4File branchFile;
    private PreviewP4File branchElsewhereFile;
    private PreviewP4File integrateFile;
    private PreviewP4File integrateElsewhereFile;
    private SelectionAdapter comboAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            LabelPreviewPreferencePage.this.cache.clear();
            LabelPreviewPreferencePage.this.cache.setLockLocation(LabelPreviewPreferencePage.this.getPosition(LabelPreviewPreferencePage.this.lockedFilesCombo));
            LabelPreviewPreferencePage.this.cache.setMarkUnmanaged(LabelPreviewPreferencePage.this.unmanagedFilesButton.getSelection());
            LabelPreviewPreferencePage.this.cache.setNotSyncLocation(LabelPreviewPreferencePage.this.getPosition(LabelPreviewPreferencePage.this.notSyncedFilesCombo));
            LabelPreviewPreferencePage.this.cache.setOpenLocation(LabelPreviewPreferencePage.this.getPosition(LabelPreviewPreferencePage.this.openFilesCombo));
            LabelPreviewPreferencePage.this.cache.setOtherLocation(LabelPreviewPreferencePage.this.getPosition(LabelPreviewPreferencePage.this.openElsewhereFilesCombo));
            LabelPreviewPreferencePage.this.cache.setSyncLocation(LabelPreviewPreferencePage.this.getPosition(LabelPreviewPreferencePage.this.syncedFilesCombo));
            LabelPreviewPreferencePage.this.cache.setUnresolvedLocation(LabelPreviewPreferencePage.this.getPosition(LabelPreviewPreferencePage.this.unresolvedFilesCombo));
            LabelPreviewPreferencePage.this.cache.setProjectLocation(LabelPreviewPreferencePage.this.getPosition(LabelPreviewPreferencePage.this.sharedProjectsCombo));
            LabelPreviewPreferencePage.this.cache.setIgnoredLocation(LabelPreviewPreferencePage.this.getPosition(LabelPreviewPreferencePage.this.ignoredFilesCombo));
            LabelPreviewPreferencePage.this.cache.setLocalLocation(LabelPreviewPreferencePage.this.getPosition(LabelPreviewPreferencePage.this.localFilesCombo));
            LabelPreviewPreferencePage.this.cache.setStreamAndSandboxLocation(LabelPreviewPreferencePage.this.getPosition(LabelPreviewPreferencePage.this.streamSandboxCombo));
            LabelPreviewPreferencePage.this.cache.setStreamAndSandboxProjectLocation(LabelPreviewPreferencePage.this.getPosition(LabelPreviewPreferencePage.this.streamSandboxProjectCombo));
            LabelPreviewPreferencePage.this.decorator.decorateIgnored(LabelPreviewPreferencePage.this.ignoreButton.getSelection());
            LabelPreviewPreferencePage.this.previewTree.refresh();
        }
    };
    private ModifyListener textListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            LabelPreviewPreferencePage.this.decorator.setConnectionDecoration(LabelPreviewPreferencePage.this.connectText.getText());
            LabelPreviewPreferencePage.this.decorator.setProjectDecoration(LabelPreviewPreferencePage.this.projectText.getText());
            LabelPreviewPreferencePage.this.decorator.setFileDecoration(LabelPreviewPreferencePage.this.fileText.getText());
            LabelPreviewPreferencePage.this.decorator.setOutgoingDecoration(LabelPreviewPreferencePage.this.outgoingChangeText.getText());
            LabelPreviewPreferencePage.this.decorator.setUnaddedDecoration(LabelPreviewPreferencePage.this.unaddedChangeText.getText());
            LabelPreviewPreferencePage.this.decorator.setIgnoredDecoration(LabelPreviewPreferencePage.this.ignoreText.getText());
            LabelPreviewPreferencePage.this.decorator.decorateIgnored(LabelPreviewPreferencePage.this.ignoreButton.getSelection());
            LabelPreviewPreferencePage.this.previewTree.refresh();
        }
    };
    private ITreeContentProvider provider = new ITreeContentProvider(){

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            return new Object[]{LabelPreviewPreferencePage.this.unmanagedFile, LabelPreviewPreferencePage.this.onlineProject, LabelPreviewPreferencePage.this.offlineProject, LabelPreviewPreferencePage.this.sandboxProject, LabelPreviewPreferencePage.this.onlineConnection, LabelPreviewPreferencePage.this.offlineConnection, LabelPreviewPreferencePage.this.onlineSandboxConnection, LabelPreviewPreferencePage.this.offlineSandboxConnection};
        }

        public boolean hasChildren(Object element) {
            return element == LabelPreviewPreferencePage.this.onlineProject;
        }

        public Object getParent(Object element) {
            if (element instanceof IProject) {
                return null;
            }
            return LabelPreviewPreferencePage.this.onlineProject;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement == LabelPreviewPreferencePage.this.onlineProject) {
                return new Object[]{LabelPreviewPreferencePage.this.addedFile, LabelPreviewPreferencePage.this.editedFile, LabelPreviewPreferencePage.this.deletedFile, LabelPreviewPreferencePage.this.branchFile, LabelPreviewPreferencePage.this.integrateFile, LabelPreviewPreferencePage.this.unresolvedFile, LabelPreviewPreferencePage.this.lockedFile, LabelPreviewPreferencePage.this.syncedFile, LabelPreviewPreferencePage.this.notSyncedFile, LabelPreviewPreferencePage.this.addedElsewhereFile, LabelPreviewPreferencePage.this.editedElsewhereFile, LabelPreviewPreferencePage.this.deletedElsewhereFile, LabelPreviewPreferencePage.this.branchElsewhereFile, LabelPreviewPreferencePage.this.integrateElsewhereFile, LabelPreviewPreferencePage.this.ignoredFolder, LabelPreviewPreferencePage.this.ignoredFile, LabelPreviewPreferencePage.this.localOnly};
            }
            return new Object[0];
        }
    };
    private PageDecorator decorator = null;
    private PageCache cache = new PageCache();

    protected Control createContents(Composite parent) {
        this.displayArea = new Composite(parent, 0);
        GridLayout daLayout = new GridLayout(1, true);
        this.displayArea.setLayout((Layout)daLayout);
        GridData daData = new GridData(4, 4, true, true);
        this.displayArea.setLayoutData((Object)daData);
        this.labelDecoratorsLink = new Link(this.displayArea, 0);
        this.labelDecoratorsLink.setText(Messages.LabelPreviewPreferencePage_ToEnablePerforceDecoration);
        this.labelDecoratorsLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                P4UIUtils.openPreferencePage("org.eclipse.ui.preferencePages.Decorators");
            }
        });
        this.labelTabs = new TabFolder(this.displayArea, 128);
        this.labelTabs.setLayoutData((Object)new GridData(4, 4, true, false));
        this.createIconTab(this.labelTabs);
        this.createTextTab(this.labelTabs);
        this.createGeneralTab(this.labelTabs);
        Label previewLabel = new Label(this.displayArea, 16384);
        previewLabel.setText(Messages.LabelPreviewPreferencePage_Preview);
        this.previewTree = new TreeViewer(this.displayArea, 66308);
        this.previewTree.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        this.previewTree.setContentProvider((IContentProvider)this.provider);
        this.decorator = new PageDecorator(this.cache);
        this.previewTree.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new WorkbenchLabelProvider(), (ILabelDecorator)this.decorator));
        this.previewTree.setInput((Object)new Object[]{this.onlineProject, this.offlineProject, this.sandboxProject});
        this.previewTree.expandAll();
        return this.displayArea;
    }

    private void createGeneralTab(TabFolder parent) {
        this.generalTab = new TabItem(parent, 0);
        this.generalTab.setText(Messages.LabelPreviewPreferencePage_General);
        this.generalArea = new Composite((Composite)parent, 0);
        this.generalTab.setControl((Control)this.generalArea);
        GridLayout gaLayout = new GridLayout(1, true);
        this.generalArea.setLayout((Layout)gaLayout);
        GridData gaData = new GridData(4, 4, true, true);
        this.generalArea.setLayoutData((Object)gaData);
        this.showChangelistInSyncButton = new Button(this.generalArea, 32);
        this.showChangelistInSyncButton.setText(Messages.LabelPreviewPreferencePage_ShowCurrentChangelistInSyncView);
        this.showChangelistInSyncButton.setSelection(this.getPreferenceStore().getBoolean("com.perforce.team.ui.preferences.SHOW_CHANGELIST_IN_SYNC_VIEW"));
    }

    private void createIconTab(TabFolder parent) {
        this.iconTab = new TabItem(parent, 0);
        this.iconTab.setText(Messages.LabelPreviewPreferencePage_IconDecorations);
        this.iconArea = new Composite((Composite)parent, 0);
        this.iconTab.setControl((Control)this.iconArea);
        GridLayout iaLayout = new GridLayout(2, false);
        this.iconArea.setLayout((Layout)iaLayout);
        GridData iaData = new GridData(4, 4, true, true);
        this.iconArea.setLayoutData((Object)iaData);
        Label sharedProjectsLabel = new Label(this.iconArea, 32);
        sharedProjectsLabel.setText(Messages.LabelPreviewPreferencePage_IndicatorForSharedProjects);
        this.sharedProjectsCombo = new Combo(this.iconArea, 12);
        this.addComboOptions(this.sharedProjectsCombo);
        Label openFilesLabel = new Label(this.iconArea, 32);
        openFilesLabel.setText(Messages.LabelPreviewPreferencePage_IndicatorForOpenForAddEditDelete);
        this.openFilesCombo = new Combo(this.iconArea, 12);
        this.addComboOptions(this.openFilesCombo);
        Label syncedFilesLabel = new Label(this.iconArea, 32);
        syncedFilesLabel.setText(Messages.LabelPreviewPreferencePage_IndicatorForSyncedToHead);
        this.syncedFilesCombo = new Combo(this.iconArea, 12);
        this.addComboOptions(this.syncedFilesCombo);
        Label notSyncedFilesLabel = new Label(this.iconArea, 32);
        notSyncedFilesLabel.setText(Messages.LabelPreviewPreferencePage_IndicatorForNotSyncedToHead);
        this.notSyncedFilesCombo = new Combo(this.iconArea, 12);
        this.addComboOptions(this.notSyncedFilesCombo);
        Label lockedFilesLabel = new Label(this.iconArea, 32);
        lockedFilesLabel.setText(Messages.LabelPreviewPreferencePage_IndicatorForLocked);
        this.lockedFilesCombo = new Combo(this.iconArea, 12);
        this.addComboOptions(this.lockedFilesCombo);
        Label unresolvedFilesLabel = new Label(this.iconArea, 32);
        unresolvedFilesLabel.setText(Messages.LabelPreviewPreferencePage_IndicatorForUnresolved);
        this.unresolvedFilesCombo = new Combo(this.iconArea, 12);
        this.addComboOptions(this.unresolvedFilesCombo);
        Label openElsewhereFilesLabel = new Label(this.iconArea, 32);
        openElsewhereFilesLabel.setText(Messages.LabelPreviewPreferencePage_IndicatorForOpenedByOther);
        this.openElsewhereFilesCombo = new Combo(this.iconArea, 12);
        this.addComboOptions(this.openElsewhereFilesCombo);
        Label ignoredFilesLabel = new Label(this.iconArea, 32);
        ignoredFilesLabel.setText(Messages.LabelPreviewPreferencePage_IndicatorForIgnoredResources);
        this.ignoredFilesCombo = new Combo(this.iconArea, 12);
        this.addComboOptions(this.ignoredFilesCombo);
        Label localFilesLabel = new Label(this.iconArea, 32);
        localFilesLabel.setText(Messages.LabelPreviewPreferencePage_IndicatorForNotUnderVersionControl);
        this.localFilesCombo = new Combo(this.iconArea, 12);
        this.addComboOptions(this.localFilesCombo);
        Label streamSandBoxLabel = new Label(this.iconArea, 32);
        streamSandBoxLabel.setText(Messages.LabelPreviewPreferencePage_IndicatorForStreamAndSandboxConnection);
        this.streamSandboxCombo = new Combo(this.iconArea, 12);
        this.addComboOptions(this.streamSandboxCombo);
        Label streamSandBoxProjectLabel = new Label(this.iconArea, 32);
        streamSandBoxProjectLabel.setText(Messages.LabelPreviewPreferencePage_IndicatorForStreamAndSandboxProject);
        this.streamSandboxProjectCombo = new Combo(this.iconArea, 12);
        this.addComboOptions(this.streamSandboxProjectCombo);
        this.unmanagedFilesButton = new Button(this.iconArea, 32);
        this.unmanagedFilesButton.setText(Messages.LabelPreviewPreferencePage_DisplayIconForFilesNotManagedByEclipse);
        GridData ufbData = new GridData(4, 4, true, false);
        ufbData.horizontalSpan = 2;
        this.unmanagedFilesButton.setLayoutData((Object)ufbData);
        this.unmanagedFilesButton.setSelection(this.getPreferenceStore().getBoolean("pref_mark_unmanaged"));
        this.unmanagedFilesButton.addSelectionListener((SelectionListener)this.comboAdapter);
        this.setPosition(this.openFilesCombo, this.getPreferenceStore().getInt("pref_file_open_icon"));
        this.setPosition(this.notSyncedFilesCombo, this.getPreferenceStore().getInt("pref_file_sync_icon"));
        this.setPosition(this.syncedFilesCombo, this.getPreferenceStore().getInt("pref_file_sync2_icon"));
        this.setPosition(this.unresolvedFilesCombo, this.getPreferenceStore().getInt("pref_file_unresolved_icon"));
        this.setPosition(this.lockedFilesCombo, this.getPreferenceStore().getInt("pref_file_lock_icon"));
        this.setPosition(this.openElsewhereFilesCombo, this.getPreferenceStore().getInt("pref_file_other_icon"));
        this.setPosition(this.sharedProjectsCombo, this.getPreferenceStore().getInt("pref_project_icon"));
        this.setPosition(this.ignoredFilesCombo, this.getPreferenceStore().getInt("pref_ignored_icon"));
        this.setPosition(this.localFilesCombo, this.getPreferenceStore().getInt("pref_local_only_icon"));
        this.setPosition(this.streamSandboxCombo, this.getPreferenceStore().getInt("pref_stream_sandbox_icon"));
        this.setPosition(this.streamSandboxProjectCombo, this.getPreferenceStore().getInt("pref_stream_sandbox_project_icon"));
    }

    private void createTextTab(TabFolder parent) {
        this.textTab = new TabItem(parent, 0);
        this.textTab.setText(Messages.LabelPreviewPreferencePage_TextDecorations);
        this.textArea = new Composite((Composite)parent, 0);
        this.textTab.setControl((Control)this.textArea);
        GridLayout iaLayout = new GridLayout(3, false);
        this.textArea.setLayout((Layout)iaLayout);
        GridData iaData = new GridData(4, 4, true, true);
        this.textArea.setLayoutData((Object)iaData);
        Label fileLabel = new Label(this.textArea, 16384);
        fileLabel.setText(Messages.LabelPreviewPreferencePage_FileDecoration);
        this.fileText = new Text(this.textArea, 2052);
        this.fileText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.fileText.setText(this.getPreferenceStore().getString("com.perforce.team.ui.preferences.FILE_DECORATION_TEXT"));
        this.fileText.addModifyListener(this.textListener);
        this.fileVariablesButton = new Button(this.textArea, 8);
        this.fileVariablesButton.setText(Messages.LabelPreviewPreferencePage_AddVariables);
        this.fileVariablesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String[] vars = new String[]{"{action}", "{have}", "{head}", "{head_change}", "{name}", "{not_under_version_control}", "{outgoing_change_flag}", "{type}"};
                String[] descs = new String[]{IPreferenceConstants.ACTION_DESCRIPTION, IPreferenceConstants.HAVE_DESCRIPTION, IPreferenceConstants.HEAD_DESCRIPTION, IPreferenceConstants.HEAD_CHANGE_DESCRIPTION, IPreferenceConstants.NAME_DESCRIPTION, IPreferenceConstants.UNADDED_CHANGE_DESCRIPTION, IPreferenceConstants.OUTGOING_CHANGE_DESCRIPTION, IPreferenceConstants.TYPE_DESCRIPTION};
                VariablesDialog dialog = new VariablesDialog(LabelPreviewPreferencePage.this.fileVariablesButton.getShell(), vars, descs);
                if (dialog.open() == 0) {
                    String[] selected = dialog.getSelectedVariables();
                    StringBuffer newVariables = new StringBuffer();
                    String[] stringArray = selected;
                    int n = selected.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String var = stringArray[n2];
                        newVariables.append(var);
                        ++n2;
                    }
                    LabelPreviewPreferencePage.this.fileText.insert(newVariables.toString());
                }
            }
        });
        Label projectLabel = new Label(this.textArea, 16384);
        projectLabel.setText(Messages.LabelPreviewPreferencePage_ProjectDecoration);
        this.projectText = new Text(this.textArea, 2052);
        this.projectText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.projectText.setText(this.getPreferenceStore().getString("com.perforce.team.ui.preferences.PROJECT_DECORATION_TEXT"));
        this.projectText.addModifyListener(this.textListener);
        this.projectVariablesButton = new Button(this.textArea, 8);
        this.projectVariablesButton.setText(Messages.LabelPreviewPreferencePage_AddVariables);
        this.projectVariablesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String[] vars = new String[]{"{charset}", "{client}", "{name}", "{offline}", "{sandbox}", "{stream_name}", "{stream_root}", "{server}", "{user}"};
                String[] descs = new String[]{IPreferenceConstants.CHARSET_DESCRIPTION, IPreferenceConstants.CLIENT_DESCRIPTION, IPreferenceConstants.NAME_DESCRIPTION, IPreferenceConstants.OFFLINE_DESCRIPTION, IPreferenceConstants.SANDBOX_DESCRIPTION, IPreferenceConstants.STREAM_NAME_DESCRIPTION, IPreferenceConstants.STREAM_ROOT_DESCRIPTION, IPreferenceConstants.SERVER_DESCRIPTION, IPreferenceConstants.USER_DESCRIPTION};
                VariablesDialog dialog = new VariablesDialog(LabelPreviewPreferencePage.this.projectVariablesButton.getShell(), vars, descs);
                if (dialog.open() == 0) {
                    String[] selected = dialog.getSelectedVariables();
                    StringBuffer newVariables = new StringBuffer();
                    String[] stringArray = selected;
                    int n = selected.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String var = stringArray[n2];
                        newVariables.append(var);
                        ++n2;
                    }
                    LabelPreviewPreferencePage.this.projectText.insert(newVariables.toString());
                }
            }
        });
        Label connectLabel = new Label(this.textArea, 16384);
        connectLabel.setText(Messages.LabelPreviewPreferencePage_ConnectionDecoration);
        this.connectText = new Text(this.textArea, 2052);
        this.connectText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.connectText.setText(this.getPreferenceStore().getString("com.perforce.team.ui.preferences.CONNECTION_DECORATION_TEXT"));
        this.connectText.addModifyListener(this.textListener);
        this.connectVariablesButton = new Button(this.textArea, 8);
        this.connectVariablesButton.setText(Messages.LabelPreviewPreferencePage_AddVariables);
        this.connectVariablesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String[] vars = new String[]{"{offline}", "{stream_name}", "{stream_root}", "{sandbox}"};
                String[] descs = new String[]{IPreferenceConstants.OFFLINE_DESCRIPTION, IPreferenceConstants.STREAM_NAME_DESCRIPTION, IPreferenceConstants.STREAM_ROOT_DESCRIPTION, IPreferenceConstants.SANDBOX_DESCRIPTION};
                VariablesDialog dialog = new VariablesDialog(LabelPreviewPreferencePage.this.connectVariablesButton.getShell(), vars, descs);
                if (dialog.open() == 0) {
                    String[] selected = dialog.getSelectedVariables();
                    StringBuffer newVariables = new StringBuffer();
                    String[] stringArray = selected;
                    int n = selected.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String var = stringArray[n2];
                        newVariables.append(var);
                        ++n2;
                    }
                    LabelPreviewPreferencePage.this.connectText.insert(newVariables.toString());
                }
            }
        });
        Composite bottom = new Composite(this.textArea, 0);
        GridData bData = new GridData(4, 4, true, true);
        bData.horizontalSpan = 3;
        bottom.setLayoutData((Object)bData);
        GridLayout bLayout = new GridLayout(2, false);
        bLayout.marginTop = 15;
        bLayout.marginWidth = 0;
        bLayout.marginHeight = 0;
        bottom.setLayout((Layout)bLayout);
        this.ignoreButton = new Button(bottom, 32);
        this.ignoreButton.setText(Messages.LabelPreviewPreferencePage_DecorateIgnoredResources);
        this.ignoreButton.setSelection(this.getPreferenceStore().getBoolean("pref_ignored_text"));
        this.ignoreButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LabelPreviewPreferencePage.this.ignoreText.setEnabled(LabelPreviewPreferencePage.this.ignoreButton.getSelection());
            }
        });
        this.ignoreButton.addSelectionListener((SelectionListener)this.comboAdapter);
        this.ignoreText = new Text(bottom, 2052);
        this.ignoreText.setEnabled(this.ignoreButton.getSelection());
        this.ignoreText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.ignoreText.setText(this.getPreferenceStore().getString("com.perforce.team.ui.preferences.IGNORED_DECORATION"));
        this.ignoreText.addModifyListener(this.textListener);
        Label outgoingChangeLabel = new Label(bottom, 16384);
        outgoingChangeLabel.setText(Messages.LabelPreviewPreferencePage_OutgoingChangeFlag);
        this.outgoingChangeText = new Text(bottom, 2052);
        this.outgoingChangeText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.outgoingChangeText.setText(this.getPreferenceStore().getString("com.perforce.team.ui.preferences.OUTGOING_CHANGE_DECORATION"));
        this.outgoingChangeText.addModifyListener(this.textListener);
        Label unaddedChangeLabel = new Label(bottom, 16384);
        unaddedChangeLabel.setText(Messages.LabelPreviewPreferencePage_NotUnderVersionControlDecoration);
        this.unaddedChangeText = new Text(bottom, 2052);
        this.unaddedChangeText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.unaddedChangeText.setText(this.getPreferenceStore().getString("com.perforce.team.ui.preferences.UNADDED_CHANGE_DECORATION"));
        this.unaddedChangeText.addModifyListener(this.textListener);
    }

    private void addComboOptions(Combo combo) {
        String[] stringArray = ICON_POSITIONS;
        int n = ICON_POSITIONS.length;
        int n2 = 0;
        while (n2 < n) {
            String option = stringArray[n2];
            combo.add(option);
            ++n2;
        }
        combo.addSelectionListener((SelectionListener)this.comboAdapter);
    }

    private void setPosition(Combo list, int position) {
        if ((position & 1) != 0) {
            list.select(1);
        } else if ((position & 2) != 0) {
            list.select(2);
        } else if ((position & 4) != 0) {
            list.select(3);
        } else if ((position & 8) != 0) {
            list.select(4);
        } else {
            list.select(0);
        }
    }

    private int getPosition(Combo list) {
        int idx = list.getSelectionIndex();
        if (idx == 1) {
            return 1;
        }
        if (idx == 2) {
            return 2;
        }
        if (idx == 3) {
            return 4;
        }
        if (idx == 4) {
            return 8;
        }
        return 0;
    }

    private void setupResources() {
        ConnectionParameters onlineParams = new ConnectionParameters();
        onlineParams.setUser("user1");
        onlineParams.setClient("client1");
        onlineParams.setPort("localhost:1666");
        onlineParams.setCharset("utf8");
        this.onlineConnection = new PreviewConnection(onlineParams, false, false, Messages.PreviewConnection_StreamRoot, Messages.PreviewConnection_StreamName);
        this.onlineProject = new Project(Messages.LabelPreviewPreferencePage_OnlineProject, this.onlineConnection);
        ConnectionParameters offlineParams = new ConnectionParameters();
        offlineParams.setUser("user2");
        offlineParams.setClient("client2");
        offlineParams.setPort("server:1666");
        this.offlineConnection = new PreviewConnection(offlineParams, true, false, Messages.PreviewConnection_StreamRoot, Messages.PreviewConnection_StreamName);
        this.offlineProject = new Project(Messages.LabelPreviewPreferencePage_OfflineProject, this.offlineConnection);
        ConnectionParameters sandboxParams = new ConnectionParameters();
        sandboxParams.setUser("user3");
        sandboxParams.setClient("sandbox_client");
        sandboxParams.setPort("server:1666");
        this.onlineSandboxConnection = new PreviewConnection(sandboxParams, false, true, Messages.LabelPreviewPreferencePage_SandboxStreamRoot, Messages.LabelPreviewPreferencePage_SandboxStreamName);
        this.sandboxProject = new Project(Messages.LabelPreviewPreferencePage_SandboxProject, this.onlineSandboxConnection);
        ConnectionParameters offlineSandboxParams = new ConnectionParameters();
        offlineSandboxParams.setUser("user4");
        offlineSandboxParams.setClient("sandbox_client");
        offlineSandboxParams.setPort("server:1666");
        this.offlineSandboxConnection = new PreviewConnection(offlineSandboxParams, true, true, Messages.LabelPreviewPreferencePage_SandboxStreamRoot, Messages.LabelPreviewPreferencePage_SandboxStreamName);
        this.offlineSandboxProject = new Project(Messages.LabelPreviewPreferencePage_SandboxProject, this.offlineSandboxConnection);
        this.ignoredFolder = new Folder(Messages.LabelPreviewPreferencePage_IgnoredFolder, this.onlineConnection);
        this.addedFile = new PreviewP4File();
        this.addedFile.setAction(FileAction.ADD);
        this.addedFile.setName("added.txt");
        this.addedFile.setHeadType("text");
        this.addedFile.setOpenedByOwner(true);
        this.editedFile = new PreviewP4File();
        this.editedFile.setSynced(true);
        this.editedFile.setAction(FileAction.EDIT);
        this.editedFile.setName("edited.h");
        this.editedFile.setHeadType("text");
        this.editedFile.setHaveRevision(3);
        this.editedFile.setHeadRevision(3);
        this.editedFile.setOpenedByOwner(true);
        this.deletedFile = new PreviewP4File();
        this.deletedFile.setSynced(true);
        this.deletedFile.setName("deleted.png");
        this.deletedFile.setHeadType("ubinary");
        this.deletedFile.setAction(FileAction.DELETE);
        this.deletedFile.setHaveRevision(2);
        this.deletedFile.setHeadRevision(2);
        this.deletedFile.setOpenedByOwner(true);
        this.unresolvedFile = new PreviewP4File();
        this.unresolvedFile.setName("unresolved.zip");
        this.unresolvedFile.setAction(FileAction.EDIT);
        this.unresolvedFile.setHeadRevision(2);
        this.unresolvedFile.setHaveRevision(2);
        this.unresolvedFile.setSynced(true);
        this.unresolvedFile.setUnresolved(true);
        this.unresolvedFile.setHeadType("binary");
        this.lockedFile = new PreviewP4File();
        this.lockedFile.setName("locked.txt");
        this.lockedFile.setLocked(true);
        this.lockedFile.setSynced(true);
        this.lockedFile.setHaveRevision(1);
        this.lockedFile.setHeadRevision(1);
        this.lockedFile.setHeadType("text");
        this.lockedFile.setAction(FileAction.EDIT);
        this.syncedFile = new PreviewP4File();
        this.syncedFile.setName("Synced.java");
        this.syncedFile.setHeadType("text");
        this.syncedFile.setSynced(true);
        this.syncedFile.setHaveRevision(18);
        this.syncedFile.setHeadRevision(18);
        this.notSyncedFile = new PreviewP4File();
        this.notSyncedFile.setName("NotSynced.java");
        this.notSyncedFile.setHeadType("text");
        this.notSyncedFile.setSynced(false);
        this.notSyncedFile.setHaveRevision(5);
        this.notSyncedFile.setHeadRevision(8);
        this.addedElsewhereFile = new PreviewP4File();
        this.addedElsewhereFile.setName("added_elsewhere.xml");
        this.addedElsewhereFile.setAction(FileAction.ADD);
        this.addedElsewhereFile.setOpenedByOwner(false);
        this.addedElsewhereFile.setHeadType("text");
        this.editedElsewhereFile = new PreviewP4File();
        this.editedElsewhereFile.setName("edited_elsewhere.xml");
        this.editedElsewhereFile.setAction(FileAction.EDIT);
        this.editedElsewhereFile.setOpenedByOwner(false);
        this.editedElsewhereFile.setHeadType("text");
        this.deletedElsewhereFile = new PreviewP4File();
        this.deletedElsewhereFile.setName("deleted_elsewhere.xml");
        this.deletedElsewhereFile.setAction(FileAction.DELETE);
        this.deletedElsewhereFile.setOpenedByOwner(false);
        this.deletedElsewhereFile.setHeadType("text");
        this.branchFile = new PreviewP4File();
        this.branchFile.setName("branch.txt");
        this.branchFile.setHeadType("text");
        this.branchFile.setOpenedByOwner(true);
        this.branchFile.setAction(FileAction.BRANCH);
        this.branchElsewhereFile = new PreviewP4File();
        this.branchElsewhereFile.setName("branched_elsewhere.txt");
        this.branchElsewhereFile.setHeadType("text");
        this.branchElsewhereFile.setOpenedByOwner(false);
        this.branchElsewhereFile.setAction(FileAction.BRANCH);
        this.integrateFile = new PreviewP4File();
        this.integrateFile.setName("integrate.properties");
        this.integrateFile.setHeadType("text");
        this.integrateFile.setOpenedByOwner(true);
        this.integrateFile.setAction(FileAction.INTEGRATE);
        this.integrateElsewhereFile = new PreviewP4File();
        this.integrateElsewhereFile.setName("integrated_elsewhere.properties");
        this.integrateElsewhereFile.setHeadType("text");
        this.integrateElsewhereFile.setOpenedByOwner(false);
        this.integrateElsewhereFile.setAction(FileAction.INTEGRATE);
        this.ignoredFile = new PreviewP4File();
        this.ignoredFile.setName("ignored.txt");
        this.unmanagedFile = new PreviewP4File();
        this.unmanagedFile.setName("not_in_Eclipse.txt");
        this.unmanagedFile.setUnmanaged(true);
        this.unmanagedFile.setHaveRevision(1);
        this.unmanagedFile.setHeadRevision(1);
        this.unmanagedFile.setAction(FileAction.EDIT);
        this.unmanagedFile.setSynced(true);
        this.unmanagedFile.setOpenedByOwner(true);
        this.localOnly = new PreviewP4File();
        this.localOnly.setName("not_in_depot.log");
        this.localOnly.setFileSpec(null);
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(PerforceUIPlugin.getPlugin().getPreferenceStore());
        this.setupResources();
    }

    protected void performDefaults() {
        super.performDefaults();
        IPreferenceStore store = this.getPreferenceStore();
        this.setPosition(this.openFilesCombo, store.getDefaultInt("pref_file_open_icon"));
        this.setPosition(this.notSyncedFilesCombo, store.getDefaultInt("pref_file_sync_icon"));
        this.setPosition(this.syncedFilesCombo, store.getDefaultInt("pref_file_sync2_icon"));
        this.setPosition(this.unresolvedFilesCombo, store.getDefaultInt("pref_file_unresolved_icon"));
        this.setPosition(this.lockedFilesCombo, store.getDefaultInt("pref_file_lock_icon"));
        this.setPosition(this.openElsewhereFilesCombo, store.getDefaultInt("pref_file_other_icon"));
        this.setPosition(this.sharedProjectsCombo, store.getDefaultInt("pref_project_icon"));
        this.setPosition(this.ignoredFilesCombo, store.getDefaultInt("pref_ignored_icon"));
        this.setPosition(this.localFilesCombo, store.getDefaultInt("pref_local_only_icon"));
        this.setPosition(this.streamSandboxCombo, store.getDefaultInt("pref_stream_sandbox_icon"));
        this.setPosition(this.streamSandboxProjectCombo, store.getDefaultInt("pref_stream_sandbox_project_icon"));
        this.ignoreButton.setSelection(store.getDefaultBoolean("pref_ignored_text"));
        this.ignoreText.setText(store.getDefaultString("com.perforce.team.ui.preferences.IGNORED_DECORATION"));
        this.outgoingChangeText.setText(store.getDefaultString("com.perforce.team.ui.preferences.OUTGOING_CHANGE_DECORATION"));
        this.unaddedChangeText.setText(store.getDefaultString("com.perforce.team.ui.preferences.UNADDED_CHANGE_DECORATION"));
        this.connectText.setText(store.getDefaultString("com.perforce.team.ui.preferences.CONNECTION_DECORATION_TEXT"));
        this.projectText.setText(store.getDefaultString("com.perforce.team.ui.preferences.PROJECT_DECORATION_TEXT"));
        this.fileText.setText(store.getDefaultString("com.perforce.team.ui.preferences.FILE_DECORATION_TEXT"));
        this.showChangelistInSyncButton.setSelection(store.getDefaultBoolean("com.perforce.team.ui.preferences.SHOW_CHANGELIST_IN_SYNC_VIEW"));
        this.unmanagedFilesButton.setSelection(store.getDefaultBoolean("pref_mark_unmanaged"));
        this.comboAdapter.widgetSelected(new SelectionEvent(new Event()));
        this.textListener.modifyText(new ModifyEvent(new Event()));
    }

    public boolean performOk() {
        IPreferenceStore store = this.getPreferenceStore();
        store.setValue("pref_file_open_icon", this.getPosition(this.openFilesCombo));
        store.setValue("pref_file_sync_icon", this.getPosition(this.notSyncedFilesCombo));
        store.setValue("pref_file_sync2_icon", this.getPosition(this.syncedFilesCombo));
        store.setValue("pref_file_unresolved_icon", this.getPosition(this.unresolvedFilesCombo));
        store.setValue("pref_file_lock_icon", this.getPosition(this.lockedFilesCombo));
        store.setValue("pref_file_other_icon", this.getPosition(this.openElsewhereFilesCombo));
        store.setValue("pref_project_icon", this.getPosition(this.sharedProjectsCombo));
        store.setValue("pref_ignored_icon", this.getPosition(this.ignoredFilesCombo));
        store.setValue("pref_stream_sandbox_icon", this.getPosition(this.streamSandboxCombo));
        store.setValue("pref_stream_sandbox_project_icon", this.getPosition(this.streamSandboxProjectCombo));
        store.setValue("com.perforce.team.ui.preferences.IGNORED_DECORATION", this.ignoreText.getText());
        store.setValue("com.perforce.team.ui.preferences.OUTGOING_CHANGE_DECORATION", this.outgoingChangeText.getText());
        store.setValue("com.perforce.team.ui.preferences.UNADDED_CHANGE_DECORATION", this.unaddedChangeText.getText());
        store.setValue("com.perforce.team.ui.preferences.PROJECT_DECORATION_TEXT", this.projectText.getText());
        store.setValue("com.perforce.team.ui.preferences.CONNECTION_DECORATION_TEXT", this.connectText.getText());
        store.setValue("com.perforce.team.ui.preferences.FILE_DECORATION_TEXT", this.fileText.getText());
        store.setValue("com.perforce.team.ui.preferences.SHOW_CHANGELIST_IN_SYNC_VIEW", this.showChangelistInSyncButton.getSelection());
        store.setValue("pref_ignored_text", this.ignoreButton.getSelection());
        store.setValue("pref_local_only_icon", this.getPosition(this.localFilesCombo));
        store.setValue("pref_mark_unmanaged", this.unmanagedFilesButton.getSelection());
        return super.performOk();
    }

    public boolean getChangelistInSyncSelection() {
        return this.showChangelistInSyncButton.getSelection();
    }

    public boolean getIgnoredTextSelection() {
        return this.ignoreButton.getSelection();
    }

    public String getIgnoredText() {
        return this.ignoreText.getText();
    }

    public String getOutgoingText() {
        return this.outgoingChangeText.getText();
    }

    public String getUnaddedText() {
        return this.unaddedChangeText.getText();
    }

    public String getConnectionText() {
        return this.connectText.getText();
    }

    public String getProjectText() {
        return this.projectText.getText();
    }

    public String getFileText() {
        return this.fileText.getText();
    }

    public String getOpenIconText() {
        return this.openFilesCombo.getText();
    }

    public String getSyncIconText() {
        return this.syncedFilesCombo.getText();
    }

    public String getNotSyncIconText() {
        return this.notSyncedFilesCombo.getText();
    }

    public String getUnresolvedIconText() {
        return this.unresolvedFilesCombo.getText();
    }

    public String getLockedIconText() {
        return this.lockedFilesCombo.getText();
    }

    public String getOpenedElsewhereIconText() {
        return this.openElsewhereFilesCombo.getText();
    }

    public String getIgnoredIconText() {
        return this.ignoredFilesCombo.getText();
    }

    public String getProjectIconText() {
        return this.sharedProjectsCombo.getText();
    }

    private static class Folder {
        String name;

        Folder(String name, IP4Connection connection) {
            this.name = name;
        }
    }

    private static class PageCache
    extends IconCache {
        private PageCache() {
        }

        void setOpenLocation(int location) {
            this.openLocation = location;
        }

        void setSyncLocation(int location) {
            this.syncLocation = location;
        }

        void setNotSyncLocation(int location) {
            this.notSyncLocation = location;
        }

        void setUnresolvedLocation(int location) {
            this.unresolvedLocation = location;
        }

        void setLockLocation(int location) {
            this.lockLocation = location;
        }

        void setOtherLocation(int location) {
            this.otherLocation = location;
        }

        void setMarkUnmanaged(boolean mark) {
            this.markUnmanaged = mark;
        }

        void setProjectLocation(int location) {
            this.projectLocation = location;
        }

        void setIgnoredLocation(int location) {
            this.ignoredLocation = location;
        }

        void setLocalLocation(int location) {
            this.localOnlyLocation = location;
        }

        void setStreamAndSandboxLocation(int location) {
            this.streamAndSandboxLocation = location;
        }

        void setStreamAndSandboxProjectLocation(int location) {
            this.streamAndSandboxProjectLocation = location;
        }
    }

    private class PageDecorator
    extends PerforceDecorator {
        protected Map<ImageDescriptor, Image> images;

        @Override
        public void dispose() {
            super.dispose();
            for (Image img : this.images.values()) {
                if (img == null || img.isDisposed()) continue;
                img.dispose();
            }
            this.images.clear();
            if (this.iconCache != null) {
                this.iconCache.dispose();
            }
        }

        public PageDecorator(IconCache cache) {
            super(true);
            this.images = new HashMap<ImageDescriptor, Image>();
            if (this.iconCache != null) {
                this.iconCache.clear();
            }
            this.iconCache = cache;
        }

        void setFileDecoration(String decoration) {
            this.fileDecoration = decoration;
        }

        void setProjectDecoration(String decoration) {
            this.projectDecoration = decoration;
        }

        void setConnectionDecoration(String decoration) {
            this.connectionDecoration = decoration;
        }

        void setOutgoingDecoration(String decoration) {
            this.outgoingChangeFlag = decoration;
        }

        void setUnaddedDecoration(String decoration) {
            this.unaddedChangeFlag = decoration;
        }

        void setIgnoredDecoration(String decoration) {
            this.ignoredText = decoration;
        }

        void decorateIgnored(boolean decorate) {
            this.decorateIgnored = decorate;
        }

        @Override
        public String decorateText(String text, Object o) {
            if (text != null) {
                if (o instanceof Project) {
                    return super.decorateProjectWithConnection(((Project)o).name, ((Project)o).connection);
                }
                if (o == LabelPreviewPreferencePage.this.ignoredFile && this.decorateIgnored) {
                    return super.decorateIgnoredResource(LabelPreviewPreferencePage.this.ignoredFile.getName());
                }
                if (o == LabelPreviewPreferencePage.this.ignoredFolder) {
                    if (this.decorateIgnored) {
                        return super.decorateIgnoredResource(((LabelPreviewPreferencePage)LabelPreviewPreferencePage.this).ignoredFolder.name);
                    }
                    return ((LabelPreviewPreferencePage)LabelPreviewPreferencePage.this).ignoredFolder.name;
                }
                if (o instanceof IP4File) {
                    IP4File file = (IP4File)o;
                    return super.getFileText(file.getName(), file, o == LabelPreviewPreferencePage.this.ignoredFile);
                }
                if (o instanceof IP4Connection) {
                    IP4Connection conn = (IP4Connection)o;
                    return super.decorateText(conn.getName(), conn);
                }
            }
            return super.decorateText(text, o);
        }

        @Override
        public Image decorateImage(Image image, Object o) {
            if (o == LabelPreviewPreferencePage.this.ignoredFile) {
                String text = o.toString();
                ImageDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(text);
                if (desc != null) {
                    image = this.images.get(desc);
                    if (image == null) {
                        image = desc.createImage();
                        this.images.put(desc, image);
                    }
                    return this.iconCache.getIgnoredImage(image);
                }
            } else {
                if (o instanceof IP4Connection) {
                    IP4Connection conn = (IP4Connection)o;
                    ImageDescriptor desc = PerforceUIPlugin.getPlugin().getImageDescriptor(conn.isOffline() ? "views/server_connection_offline.png" : "views/server_connection.png");
                    if (desc != null && (image = this.images.get(desc)) == null) {
                        image = desc.createImage();
                        this.images.put(desc, image);
                    }
                    return this.iconCache.getImage(image, conn);
                }
                if (o instanceof Project) {
                    return this.iconCache.decorateProjectImageBasedonConnection(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT"), ((Project)o).connection);
                }
                if (o instanceof Folder) {
                    return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
                }
                if (o instanceof IP4File) {
                    String text = o.toString();
                    ImageDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(text);
                    if (desc != null) {
                        image = this.images.get(desc);
                        if (image == null) {
                            image = desc.createImage();
                            this.images.put(desc, image);
                        }
                        return super.decorateImage(image, o);
                    }
                }
            }
            return super.decorateImage(image, o);
        }

        @Override
        public String getName() {
            return String.valueOf(LabelPreviewPreferencePage.class.getSimpleName()) + ":" + super.getName();
        }
    }

    private static class Project {
        String name;
        IP4Connection connection;

        Project(String name, IP4Connection connection) {
            this.name = name;
            this.connection = connection;
        }
    }
}

