/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.pending;

import com.perforce.team.core.Policy;
import com.perforce.team.core.Tracing;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.changelists.ChangelistFileWidget;
import com.perforce.team.ui.changelists.Folder;
import com.perforce.team.ui.changelists.FolderFileLabelProvider;
import com.perforce.team.ui.diff.DiffContentProvider;
import com.perforce.team.ui.diff.IFileDiffer;
import com.perforce.team.ui.pending.Messages;
import com.perforce.team.ui.pending.PendingFileContentProvider;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckable;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class PendingChangelistFileWidget
extends ChangelistFileWidget
implements ICheckable {
    private static final int DEFAULT_WIDTH = 500;
    private static final int DEFAULT_HEIGHT = 150;
    private boolean small = false;
    private boolean checkedOnly = false;
    private boolean settingInput = false;
    private int startingSize;
    private boolean includeFilesLabel;
    private Label filesLabel;
    private IP4Resource[] origChecked;

    public PendingChangelistFileWidget(boolean small) {
        this(small, false, false);
    }

    public PendingChangelistFileWidget(boolean small, boolean includeFilesLabel, boolean includeSelectButtons) {
        this.small = small;
        this.includeFilesLabel = includeFilesLabel;
        this.checkedOnly = PerforceUIPlugin.getPlugin().getPreferenceStore().getBoolean("com.perforce.team.ui.preferences.CHANGELIST_SHOW_CHECKED_ONLY");
    }

    public void selectAll() {
        if (this.checkedOnly) {
            this.checkedOnly = false;
            this.refresh();
            this.checkedOnly = true;
        }
        this.setAllChecked(true);
    }

    private void updateCheckedCount() {
        int checked = 0;
        Object[] objectArray = this.getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object check = objectArray[n2];
            if (check instanceof IP4File) {
                ++checked;
            }
            ++n2;
        }
        this.filesLabel.setText(MessageFormat.format(Messages.PendingChangelistFileWidget_FilesNumSelected, checked, this.startingSize));
    }

    @Override
    public void createControl(Composite parent) {
        this.createControl(parent, new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (PendingChangelistFileWidget.this.checkedOnly) {
                    if (!PendingChangelistFileWidget.this.settingInput) {
                        if (element instanceof IP4Resource) {
                            return PendingChangelistFileWidget.this.getChecked(element);
                        }
                    } else if (element instanceof IP4Resource) {
                        IP4Resource[] iP4ResourceArray = PendingChangelistFileWidget.this.origChecked;
                        int n = iP4ResourceArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IP4Resource file = iP4ResourceArray[n2];
                            if (element == file) {
                                return true;
                            }
                            ++n2;
                        }
                    }
                    return false;
                }
                return true;
            }
        });
        if (this.includeFilesLabel) {
            this.updateCheckedCount();
            this.getCheckViewer().addCheckStateListener(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent event) {
                    PendingChangelistFileWidget.this.updateCheckedCount();
                }
            });
        }
    }

    @Override
    protected void configureViewer(TreeViewer viewer) {
        super.configureViewer(viewer);
        GridData data = new GridData(4, 4, true, true);
        data.widthHint = 500;
        data.heightHint = this.small ? 75 : 150;
        viewer.getTree().setLayoutData((Object)data);
        this.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object checked = event.getElement();
                if (checked instanceof IP4Resource) {
                    IP4Resource resource = (IP4Resource)checked;
                    DiffContentProvider provider = (DiffContentProvider)PendingChangelistFileWidget.this.getViewer().getContentProvider();
                    IFileDiffer differ = provider.getDiffer(resource);
                    if (differ != null && differ.diffGenerated(resource)) {
                        PendingChangelistFileWidget.this.getCheckViewer().setSubtreeChecked(checked, event.getChecked());
                    }
                } else {
                    PendingChangelistFileWidget.this.getCheckViewer().setChecked(checked, !event.getChecked());
                }
            }
        });
        P4UIUtils.trackMovedFiles((ICheckable)this.getCheckViewer());
    }

    @Override
    protected void fillToolbar(ToolBar toolbar) {
        this.createExpandOptions(toolbar);
        final ToolItem showCheckedOnly = new ToolItem(toolbar, 32);
        showCheckedOnly.setToolTipText(Messages.PendingChangelistFileWidget_DisplayCheckedFilesOnly);
        this.checkedOnly = PerforceUIPlugin.getPlugin().getPreferenceStore().getBoolean("com.perforce.team.ui.preferences.CHANGELIST_SHOW_CHECKED_ONLY");
        showCheckedOnly.setSelection(this.checkedOnly);
        showCheckedOnly.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PendingChangelistFileWidget.this.checkedOnly = showCheckedOnly.getSelection();
                PendingChangelistFileWidget.this.refresh();
                PerforceUIPlugin.getPlugin().getPreferenceStore().setValue("com.perforce.team.ui.preferences.CHANGELIST_SHOW_CHECKED_ONLY", showCheckedOnly.getSelection());
            }
        });
        Image checkedImage = PerforceUIPlugin.getDescriptor("perforce/checked.png").createImage();
        P4UIUtils.registerDisposal((Widget)showCheckedOnly, (Resource)checkedImage);
        showCheckedOnly.setImage(checkedImage);
    }

    @Override
    protected TreeViewer createViewer(Composite parent) {
        return new CheckboxTreeViewer(parent, 2818);
    }

    @Override
    protected ITreeContentProvider createContentProvider(TreeViewer viewer) {
        return new PendingFileContentProvider((StructuredViewer)viewer, true, this){

            @Override
            protected void updateResource(IP4Resource resource) {
                super.updateResource(resource);
                PendingChangelistFileWidget.this.getCheckViewer().setSubtreeChecked((Object)resource, PendingChangelistFileWidget.this.getChecked(resource));
            }

            @Override
            public boolean hasChildren(Object element) {
                if (element instanceof IP4File) {
                    return false;
                }
                return super.hasChildren(element);
            }
        };
    }

    @Override
    protected FolderFileLabelProvider createLabelProvider(TreeViewer viewer) {
        return new PendingLabelProvider();
    }

    private CheckboxTreeViewer getCheckViewer() {
        return (CheckboxTreeViewer)this.getViewer();
    }

    public void setAllChecked(boolean checked) {
        TreeItem[] treeItemArray = this.getCheckViewer().getTree().getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            item.setChecked(checked);
            ++n2;
        }
        this.syncMovedFiles();
        this.updateCheckedCount();
    }

    private void syncMovedFiles() {
        Object[] objectArray = this.getCheckViewer().getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            P4UIUtils.syncMovedFile(this, element, true);
            ++n2;
        }
    }

    public void setCheckedElements(final Object[] elements) {
        Tracing.printExecTime((boolean)Policy.DEBUG, (String)"SUBMIT", (String)(String.valueOf(this.getClass().getSimpleName()) + ":setCheckedElement()"), (Runnable)new Runnable(){

            @Override
            public void run() {
                TreeItem[] items;
                TreeItem[] treeItemArray = items = PendingChangelistFileWidget.this.getCheckViewer().getTree().getItems();
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem item = treeItemArray[n2];
                    Object[] objectArray = elements;
                    int n3 = elements.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Object obj = objectArray[n4];
                        if (item.getData() == obj) {
                            item.setChecked(true);
                            break;
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
        });
        this.syncMovedFiles();
        this.updateCheckedCount();
    }

    public IP4File[] getCheckedFiles() {
        ArrayList<IP4File> files = new ArrayList<IP4File>();
        Object[] objectArray = this.getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object checked = objectArray[n2];
            if (checked instanceof IP4File) {
                files.add((IP4File)checked);
            }
            ++n2;
        }
        return files.toArray(new IP4File[files.size()]);
    }

    public IP4File[] getUncheckedFiles() {
        ArrayList<IP4File> files = new ArrayList<IP4File>();
        TreeItem[] treeItemArray = this.getCheckViewer().getTree().getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            if (!item.getChecked() && item.getData() instanceof IP4File) {
                files.add((IP4File)item.getData());
            }
            ++n2;
        }
        return files.toArray(new IP4File[files.size()]);
    }

    public Object[] getCheckedElements() {
        return this.getCheckViewer().getCheckedElements();
    }

    public void addCheckStateListener(ICheckStateListener listener) {
        this.getCheckViewer().addCheckStateListener(listener);
    }

    public boolean getChecked(Object element) {
        return this.getCheckViewer().getChecked(element);
    }

    public void removeCheckStateListener(ICheckStateListener listener) {
        this.getCheckViewer().removeCheckStateListener(listener);
    }

    public boolean setChecked(Object element, boolean state) {
        return this.getCheckViewer().setChecked(element, state);
    }

    public void setInput(IP4Resource[] files, IP4Resource[] checked) {
        this.settingInput = true;
        this.origChecked = checked;
        this.setFiles(files);
        this.refreshInput();
        this.settingInput = false;
        this.setCheckedElements(checked);
    }

    @Override
    public void setFiles(IP4Resource[] files) {
        this.startingSize = files.length;
        super.setFiles(files);
        this.updateCheckedCount();
    }

    @Override
    public void refreshInput() {
        if (!this.settingInput) {
            Object[] checked = this.getCheckedElements();
            this.settingInput = true;
            super.refreshInput();
            this.settingInput = false;
            this.setCheckedElements(checked);
            this.refresh();
        } else {
            super.refreshInput();
        }
    }

    @Override
    protected void createToolbar(Composite parent) {
        if (this.includeFilesLabel) {
            Composite barArea = new Composite(parent, 0);
            GridLayout baLayout = new GridLayout(2, false);
            baLayout.marginHeight = 0;
            baLayout.marginWidth = 0;
            barArea.setLayout((Layout)baLayout);
            barArea.setLayoutData((Object)new GridData(4, 4, true, false));
            this.filesLabel = new Label(barArea, 0);
            this.filesLabel.setLayoutData((Object)new GridData(4, 4, true, false));
            super.createToolbar(barArea);
        } else {
            super.createToolbar(parent);
        }
    }

    @Override
    public Folder.Type getTypePreference() {
        return Folder.Type.FLAT;
    }

    public class PendingLabelProvider
    extends FolderFileLabelProvider {
        @Override
        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof IP4File) {
                String path = null;
                path = PendingChangelistFileWidget.this.getType() == Folder.Type.FLAT ? ((IP4File)element).getActionPath(IP4Resource.Type.REMOTE) : ((IP4File)element).getName();
                String decorated = this.decorator.getLabelDecorator().decorateText(path, element);
                if (decorated != null) {
                    path = decorated;
                }
                return path;
            }
            return super.getColumnText(element, columnIndex);
        }
    }
}

