/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.p4java.dialogs;

import com.perforce.team.ui.p4java.dialogs.Messages;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;

public class VersionComboViewer
extends ComboViewer {
    public VersionComboViewer(Composite parent, int style) {
        super(parent, style);
        this.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof VersionType) {
                    return ((VersionType)((Object)element)).getLabel();
                }
                return super.getText(element);
            }
        });
        this.setInput(VersionType.values());
        this.select(VersionType.Revision);
    }

    public VersionType getSelectedObject() {
        IStructuredSelection sel = (IStructuredSelection)this.getSelection();
        return (VersionType)((Object)sel.getFirstElement());
    }

    public void select(VersionType type) {
        this.setSelection((ISelection)new StructuredSelection((Object)type));
    }

    public void setEnabled(boolean enabled) {
        this.getControl().setEnabled(enabled);
    }

    public void filter(final VersionType ... types) {
        ViewerFilter filter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                VersionType[] versionTypeArray = types;
                int n = types.length;
                int n2 = 0;
                while (n2 < n) {
                    VersionType t = versionTypeArray[n2];
                    if (t == element) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
        };
        this.setFilters(new ViewerFilter[]{filter});
    }

    public static enum VersionType {
        Revision(Messages.IntegrateDialog_Revision, "#"),
        ChangeList(Messages.IntegrateDialog_Changelist, "@"),
        Label(Messages.IntegrateDialog_Label, "@"),
        Datetime(Messages.IntegrateDialog_Datetime, "@");

        private String label;
        private String prefix;

        private VersionType(String label, String prefix) {
            this.label = label;
            this.prefix = prefix;
        }

        public String getLabel() {
            return this.label;
        }

        public String getPrefix() {
            return this.prefix;
        }
    }
}

