/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.p4java.dialogs;

import com.perforce.p4java.core.IStreamSummary;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.ui.p4java.dialogs.BrowseStreamDialog;
import com.perforce.team.ui.p4java.dialogs.IntegrateToStreamDialog;
import com.perforce.team.ui.p4java.dialogs.Messages;
import com.perforce.team.ui.streams.StreamsSuggestProvider;
import com.perforce.team.ui.streams.SuggestBox;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class SourceTargetStreamWidget2
extends Composite
implements IntegrateToStreamDialog.ISourceTargetWidget<IStreamSummary> {
    private SuggestBox sourceBox;
    private SuggestBox targetBox;
    private IStreamSummary sourcePath = null;
    private IStreamSummary targetPath = null;
    private IP4Resource resource;
    private StreamsSuggestProvider sourceProvider;
    private boolean showAll = false;
    private Button browseAllBtn;

    public SourceTargetStreamWidget2(Composite parent, int style, String title, IP4Resource resource, IStreamSummary source, IStreamSummary target) {
        super(parent, style);
        this.resource = resource;
        this.sourcePath = source;
        this.targetPath = target;
        this.sourceProvider = this.createSourceProvider(resource);
        this.createControl(this, title);
        this.addListeners();
        this.updateFromModel();
    }

    protected StreamsSuggestProvider createSourceProvider(IP4Resource resource) {
        return new StreamsSuggestProvider(resource.getConnection());
    }

    protected StreamsSuggestProvider createTargetProvider(IP4Resource resource) {
        return null;
    }

    protected void createControl(Composite parent, String title) {
        parent.setLayout((Layout)new FillLayout());
        Group filePathArea = new Group(parent, 0);
        filePathArea.setText(title);
        GridLayout fpaLayout = new GridLayout(3, false);
        filePathArea.setLayout((Layout)fpaLayout);
        Label sourceLabel = new Label((Composite)filePathArea, 16384);
        sourceLabel.setText(Messages.IntegrateDialog_SourceLabel);
        this.sourceBox = new SuggestBox((Composite)filePathArea, 0, this.sourceProvider);
        GridDataFactory.fillDefaults().grab(true, false).indent(10, -1).applyTo((Control)this.sourceBox);
        this.createBrowseForFileButton((Composite)filePathArea);
        Label targetLabel = new Label((Composite)filePathArea, 16384);
        targetLabel.setText(Messages.IntegrateDialog_TargetLabel);
        this.targetBox = new SuggestBox((Composite)filePathArea, 8, this.sourceProvider);
        GridDataFactory.fillDefaults().grab(true, false).indent(10, -1).applyTo((Control)this.targetBox);
    }

    private void createBrowseForFileButton(Composite parent) {
        this.browseAllBtn = new Button(parent, 8);
        this.browseAllBtn.setText(Messages.SourceTargetStreamWidget2_Browse);
        this.browseAllBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BrowseStreamDialog dlg = new BrowseStreamDialog(SourceTargetStreamWidget2.this.getShell(), SourceTargetStreamWidget2.this.resource.getConnection(), Messages.SourceTargetStreamWidget2_InformationText);
                if (dlg.open() == 0) {
                    SourceTargetStreamWidget2.this.sourceBox.updateModel(new SuggestBox.SelectionModel(null, dlg.getSelectedStream()));
                }
            }
        });
    }

    private void addListeners() {
    }

    public void updateFromModel() {
        if (this.resource != null) {
            SuggestBox.SelectionModel src = new SuggestBox.SelectionModel(null, this.sourcePath);
            this.sourceBox.updateModel(src);
            SuggestBox.SelectionModel dst = new SuggestBox.SelectionModel(null, this.targetPath);
            this.targetBox.updateModel(dst);
        }
    }

    public void updateToModel() {
        IStreamSummary dst;
        IStreamSummary src;
        this.sourcePath = src = (IStreamSummary)((SuggestBox.SelectionModel)this.sourceBox.getModel().getValue()).getSelection();
        this.targetPath = dst = (IStreamSummary)((SuggestBox.SelectionModel)this.targetBox.getModel().getValue()).getSelection();
    }

    @Override
    public IStatus validate() {
        SuggestBox.SelectionModel sModel = (SuggestBox.SelectionModel)this.sourceBox.getModel().getValue();
        if (sModel == null || sModel.getSelection() == null) {
            return ValidationStatus.error((String)Messages.IntegrateDialog_MustEnterSourcePath);
        }
        SuggestBox.SelectionModel tModel = (SuggestBox.SelectionModel)this.targetBox.getModel().getValue();
        if (tModel == null || tModel.getSelection() == null) {
            return ValidationStatus.error((String)Messages.IntegrateDialog_MustEnterTargetPath);
        }
        IStreamSummary source = (IStreamSummary)sModel.getSelection();
        IStreamSummary target = (IStreamSummary)tModel.getSelection();
        String ss = source.getStream();
        String ts = target.getStream();
        if (ss != null && ss.equals(ts)) {
            return ValidationStatus.error((String)Messages.SourceTargetStreamWidget2_SourceTargetSameError);
        }
        this.updateToModel();
        return ValidationStatus.ok();
    }

    @Override
    public IStreamSummary getSourcePath() {
        return this.sourcePath;
    }

    @Override
    public IStreamSummary getTargetPath() {
        return this.targetPath;
    }

    @Override
    public Composite getControl() {
        return this;
    }

    @Override
    public boolean isShowAllSource() {
        return this.showAll;
    }

    public void postInit() {
    }
}

