/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.p4java.dialogs;

import com.perforce.team.ui.p4java.dialogs.IntegrateToStreamDialog;
import com.perforce.team.ui.p4java.dialogs.Messages;
import com.perforce.team.ui.p4java.dialogs.VersionComboViewer;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class RevisionRangeWidget
extends Composite
implements IntegrateToStreamDialog.IRevisionRangeWidget {
    private Button startButton;
    private VersionComboViewer startCombo;
    private Text startText;
    private Label startHelp;
    private Button endButton;
    private VersionComboViewer endCombo;
    private Text endText;
    private Label endHelp;
    private String startOption = null;
    private String endOption = null;

    public RevisionRangeWidget(Composite parent, int style, String title) {
        super(parent, style);
        this.createControl(this, title);
        this.init();
        this.addListeners();
    }

    private void init() {
        boolean enabledStart = true;
        if (this.startOption == null) {
            enabledStart = false;
        }
        this.startButton.setSelection(enabledStart);
        this.startCombo.setEnabled(enabledStart);
        this.startText.setEnabled(enabledStart);
        this.startHelp.setVisible(enabledStart);
        boolean enableEnd = true;
        if (this.endOption == null) {
            enableEnd = false;
        }
        this.endButton.setSelection(enableEnd);
        this.endCombo.setEnabled(enableEnd);
        this.endText.setEnabled(enableEnd);
        this.endHelp.setVisible(enableEnd);
    }

    private void addListeners() {
        this.startButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = RevisionRangeWidget.this.startButton.getSelection();
                RevisionRangeWidget.this.startCombo.setEnabled(enabled);
                RevisionRangeWidget.this.startText.setEnabled(enabled);
                RevisionRangeWidget.this.startHelp.setVisible(enabled);
                if (!enabled) {
                    RevisionRangeWidget.this.startOption = null;
                }
            }
        });
        this.startCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                RevisionRangeWidget.this.startOption = String.valueOf(RevisionRangeWidget.this.getPrefix(RevisionRangeWidget.this.startCombo)) + RevisionRangeWidget.this.startText.getText();
            }
        });
        this.startText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String prefix = RevisionRangeWidget.this.getPrefix(RevisionRangeWidget.this.startCombo);
                RevisionRangeWidget.this.startOption = String.valueOf(prefix) + RevisionRangeWidget.this.startText.getText();
            }
        });
        this.endButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = RevisionRangeWidget.this.endButton.getSelection();
                RevisionRangeWidget.this.endCombo.setEnabled(enabled);
                RevisionRangeWidget.this.endText.setEnabled(enabled);
                RevisionRangeWidget.this.endHelp.setVisible(enabled);
                if (!enabled) {
                    RevisionRangeWidget.this.endOption = null;
                }
            }
        });
        this.endCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                RevisionRangeWidget.this.endOption = String.valueOf(RevisionRangeWidget.this.getPrefix(RevisionRangeWidget.this.endCombo)) + RevisionRangeWidget.this.endText.getText();
            }
        });
        this.endText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RevisionRangeWidget.this.endOption = String.valueOf(RevisionRangeWidget.this.getPrefix(RevisionRangeWidget.this.endCombo)) + RevisionRangeWidget.this.endText.getText();
            }
        });
    }

    private void createControl(Composite parent, String title) {
        parent.setLayout((Layout)new FillLayout());
        Group limitArea = new Group(parent, 0);
        limitArea.setText(title);
        GridLayout laLayout = new GridLayout(4, false);
        limitArea.setLayout((Layout)laLayout);
        this.startButton = new Button((Composite)limitArea, 32);
        this.startButton.setText(Messages.IntegrateDialog_Start);
        this.startCombo = new VersionComboViewer((Composite)limitArea, 8);
        this.startCombo.setEnabled(false);
        this.startText = new Text((Composite)limitArea, 2052);
        this.startText.setEnabled(false);
        GridDataFactory.swtDefaults().hint(50, -1).align(4, 0x1000000).grab(true, false).applyTo((Control)this.startText);
        this.startHelp = new Label((Composite)limitArea, 16384);
        this.startHelp.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.addComboListener(this.startCombo, this.startHelp);
        this.endButton = new Button((Composite)limitArea, 32);
        this.endButton.setText(Messages.IntegrateDialog_End);
        this.endCombo = new VersionComboViewer((Composite)limitArea, 8);
        this.endCombo.setEnabled(false);
        this.endText = new Text((Composite)limitArea, 2052);
        this.endText.setEnabled(false);
        GridDataFactory.swtDefaults().hint(50, -1).align(4, 0x1000000).grab(true, false).applyTo((Control)this.endText);
        this.endHelp = new Label((Composite)limitArea, 16384);
        this.endHelp.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.addComboListener(this.endCombo, this.endHelp);
        this.startHelp.setText(Messages.RevisionRangeWidget_SelectVersionTypeAndVersion);
        this.endHelp.setText(Messages.RevisionRangeWidget_SelectVersionTypeAndVersion);
    }

    private void addComboListener(final VersionComboViewer combo, final Label help) {
        combo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                VersionComboViewer.VersionType type = combo.getSelectedObject();
                if (type == VersionComboViewer.VersionType.Revision) {
                    help.setText(Messages.IntegrateDialog_EnterRevisionNumber);
                } else if (type == VersionComboViewer.VersionType.ChangeList) {
                    help.setText(Messages.IntegrateDialog_EnterChangelistNumber);
                } else if (type == VersionComboViewer.VersionType.Label) {
                    help.setText(Messages.IntegrateDialog_EnterLabel);
                } else {
                    help.setText(Messages.RevisionRangeWidget_SelectVersionTypeAndVersion);
                }
                help.setVisible(true);
                help.getParent().layout(true);
            }
        });
    }

    private String getPrefix(VersionComboViewer combo) {
        VersionComboViewer.VersionType type = combo.getSelectedObject();
        if (type != null) {
            return type.getPrefix();
        }
        return "";
    }

    @Override
    public IStatus validate() {
        boolean hasStart = this.startButton.getSelection();
        if (hasStart && this.startOption == null) {
            return ValidationStatus.error((String)Messages.RevisionRangeWidget_StartVersionEmptyError);
        }
        boolean hasEnd = this.endButton.getSelection();
        if (hasEnd && this.endOption == null) {
            return ValidationStatus.error((String)Messages.RevisionRangeWidget_EndVersionEmptyError);
        }
        return ValidationStatus.ok();
    }

    @Override
    public String getStart() {
        return this.startOption;
    }

    @Override
    public String getEnd() {
        return this.endOption;
    }

    @Override
    public Composite getControl() {
        return this;
    }
}

