/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.p4java.dialogs;

import com.perforce.p4java.option.client.ResolveFilesAutoOptions;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.P4Collection;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.core.p4java.P4Runner;
import com.perforce.team.ui.P4ConnectionManager;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.p4java.actions.ManualResolveAction;
import com.perforce.team.ui.p4java.dialogs.IResolveControlContainer;
import com.perforce.team.ui.p4java.dialogs.Messages;
import com.perforce.team.ui.p4java.dialogs.ResolveWizard;
import com.perforce.team.ui.p4merge.P4MergeResolveAction;
import java.text.MessageFormat;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.progress.UIJob;

public class ResolveInteractiveControl
extends Composite {
    private IResolveControlContainer container;
    private Button eclipseCompareButton;
    private Button p4MergeButton;
    private Button resolveButton;
    private TableViewer resolveTable;
    private int selectedItem;

    public ResolveInteractiveControl(Composite parent, int style, IResolveControlContainer container) {
        super(parent, style);
        this.container = container;
        this.createControl();
    }

    private void createControl() {
        this.setLayout((Layout)new GridLayout(1, false));
        this.createFilesGroup(this);
        this.createMiddleGroup(this);
        this.createOptionsGroup(this);
        this.createResolveButton(this);
        this.selectItem();
    }

    private void createFilesGroup(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText(Messages.ResolveWizardInteractivePage_FilesToResolve);
        this.createViewer(composite);
    }

    private void createMiddleGroup(Composite composite) {
        Composite fileButtons = new Composite(composite, 0);
        fileButtons.setLayout((Layout)new GridLayout(3, false));
        fileButtons.setLayoutData((Object)new GridData(4, 4, true, false));
    }

    void createOptionsGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Messages.ResolveWizardInteractivePage_ResolveOptions);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        Composite autoResolveChoices = new Composite((Composite)group, 0);
        autoResolveChoices.setLayout((Layout)new GridLayout(1, true));
        autoResolveChoices.setLayoutData((Object)new GridData(4, 4, true, false));
        this.eclipseCompareButton = new Button(autoResolveChoices, 16);
        this.eclipseCompareButton.setText(Messages.ResolveWizardInteractivePage_UseEclipse);
        this.p4MergeButton = new Button(autoResolveChoices, 145);
        this.p4MergeButton.setText(Messages.ResolveWizardInteractivePage_UseP4Merge);
        this.setDefaultSelection();
    }

    private void createResolveButton(Composite parent) {
        this.resolveButton = new Button(parent, 8);
        this.resolveButton.setText(Messages.ResolveWizardInteractivePage_ResolveFile);
        this.resolveButton.setLayoutData((Object)new GridData(131072, 1, false, false));
        this.resolveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResolveInteractiveControl.this.runResolve();
            }
        });
    }

    private void createViewer(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 160;
        comp.setLayoutData((Object)data);
        TableColumnLayout layout = new TableColumnLayout();
        comp.setLayout((Layout)layout);
        this.resolveTable = new TableViewer(comp, 67588);
        Table table = this.resolveTable.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.createColumns(comp, this.resolveTable, layout);
        this.resolveTable.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.resolveTable.setInput((Object)this.container.getResolveWizard().unresolved);
        this.resolveTable.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ResolveInteractiveControl.this.selectItem();
            }
        });
        this.updateColors();
        table.select(0);
    }

    private void updateColors() {
        ResolveWizard.ResolveItem item;
        Table table = this.resolveTable.getTable();
        HashMap<IP4File, Integer> startFromRevs = new HashMap<IP4File, Integer>();
        int i = 0;
        while (i < table.getItemCount()) {
            item = (ResolveWizard.ResolveItem)table.getItem(i).getData();
            if (!startFromRevs.containsKey(item.file) || (Integer)startFromRevs.get(item.file) > item.getStartFromRev()) {
                startFromRevs.put(item.file, item.getStartFromRev());
            }
            ++i;
        }
        i = 0;
        while (i < table.getItemCount()) {
            item = (ResolveWizard.ResolveItem)table.getItem(i).getData();
            if (item.getStartFromRev() > (Integer)startFromRevs.get(item.file) || !item.isContent()) {
                table.getItem(i).setForeground(this.getDisplay().getSystemColor(33));
            }
            ++i;
        }
    }

    protected void selectItem() {
        Table table = this.resolveTable.getTable();
        table.setFocus();
        int selectedIndex = table.getSelectionIndex();
        if (selectedIndex == -1) {
            this.updateButtons(false);
            return;
        }
        ResolveWizard.ResolveItem selectedItem = (ResolveWizard.ResolveItem)table.getItem(selectedIndex).getData();
        if (!selectedItem.isContent()) {
            this.container.setErrorMessage(Messages.ResolveWizardInteractivePage_ActionResolveMustBeAutoresolved);
            this.updateButtons(false);
            return;
        }
        int firstStep = selectedIndex;
        int i = 0;
        while (i < table.getItemCount()) {
            if (i != selectedIndex) {
                ResolveWizard.ResolveItem item = (ResolveWizard.ResolveItem)table.getItem(i).getData();
                if (item.file == selectedItem.file && item.getStartFromRev() < selectedItem.getStartFromRev()) {
                    firstStep = i;
                }
            }
            ++i;
        }
        if (selectedIndex != firstStep) {
            this.container.setErrorMessage(Messages.ResolveWizardInteractivePage_MustResolveEarlierStepsFirst);
            this.updateButtons(false);
        } else {
            this.container.setErrorMessage(null);
            this.updateButtons(true);
        }
    }

    private void updateButtons(boolean enabled) {
        this.resolveButton.setEnabled(enabled);
        this.eclipseCompareButton.setEnabled(enabled);
        this.p4MergeButton.setEnabled(enabled);
    }

    private void createColumns(Composite parent, TableViewer viewer, TableColumnLayout layout) {
        TableViewerColumn col = this.createTableViewerColumn(Messages.ResolveWizardInteractivePage_Resolve, 50, layout);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ResolveWizard.ResolveItem item = (ResolveWizard.ResolveItem)element;
                return item.file.getClientPath();
            }
        });
        col = this.createTableViewerColumn(Messages.ResolveWizardInteractivePage_ResolveWith, 40, layout);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ResolveWizard.ResolveItem item = (ResolveWizard.ResolveItem)element;
                if (item.isResolveShelvedChange()) {
                    return MessageFormat.format("{0}{1}}", item.getFromFile(), item.computeTheirRev());
                }
                return MessageFormat.format("{0} #{1}, #{2}", item.getFromFile(), Math.max(0, item.getStartFromRev()) + 1, item.getEndFromRev());
            }
        });
        col = this.createTableViewerColumn(Messages.ResolveWizardInteractivePage_ResolveType, 10, layout);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ResolveWizard.ResolveItem item = (ResolveWizard.ResolveItem)element;
                return item.getResolveType() == null ? "" : item.getResolveType();
            }
        });
    }

    private TableViewerColumn createTableViewerColumn(String title, int weight, TableColumnLayout layout) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.resolveTable, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        layout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(weight, true));
        return viewerColumn;
    }

    void setDefaultSelection() {
        IPreferenceStore store = PerforceUIPlugin.getPlugin().getPreferenceStore();
        String tool = store.getString("pref_resolve_interactive_merge_tool");
        if (tool.equals("eclipse_compare")) {
            this.eclipseCompareButton.setSelection(true);
        } else {
            this.p4MergeButton.setSelection(true);
        }
    }

    private void runResolve() {
        this.selectedItem = this.resolveTable.getTable().getSelectionIndex();
        if (this.selectedItem == -1) {
            return;
        }
        ResolveWizard.ResolveItem item = (ResolveWizard.ResolveItem)this.resolveTable.getTable().getItem(this.selectedItem).getData();
        P4Collection collection = P4ConnectionManager.getManager().createP4Collection();
        collection.setType(IP4Resource.Type.LOCAL);
        collection.add((IP4Resource)item.file);
        if (this.eclipseCompareButton.getSelection()) {
            this.runEclipseCompare(item);
        } else if (this.p4MergeButton.getSelection()) {
            this.runP4Merge(item);
        }
    }

    private void runEclipseCompare(ResolveWizard.ResolveItem item) {
        this.startResolve();
        this.stopResolve((IP4Resource)new ManualResolveAction().runManualResolve(item.file, item.index));
    }

    private void runP4Merge(final ResolveWizard.ResolveItem item) {
        this.startResolve();
        final P4MergeResolveAction p4mergeResolve = new P4MergeResolveAction();
        p4mergeResolve.setAsync(false);
        P4Runnable runnable = new P4Runnable(){

            public void run(IProgressMonitor monitor) {
                final IP4Resource resolved = p4mergeResolve.runResolve(item.file, item.index);
                UIJob job = new UIJob(Messages.ResolveWizardInteractivePage_UpdatingDialog){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        ResolveInteractiveControl.this.stopResolve(resolved);
                        return Status.OK_STATUS;
                    }
                };
                job.setSystem(true);
                job.schedule();
            }
        };
        P4Runner.schedule((IP4Runnable)runnable);
    }

    private void startResolve() {
        this.resolveTable.getTable().setEnabled(false);
        this.updateButtons(false);
    }

    private void stopResolve(IP4Resource resolved) {
        if (!P4UIUtils.okToUse((Viewer)this.resolveTable)) {
            return;
        }
        Table table = this.resolveTable.getTable();
        ResolveWizard.ResolveItem item = (ResolveWizard.ResolveItem)table.getItem(this.selectedItem).getData();
        P4ConnectionManager.getManager().createP4Collection(new IP4Resource[]{item.file}).resolve(new ResolveFilesAutoOptions().setShowActionsOnly(true).setShowBase(true));
        this.container.getResolveWizard().updateUnresolvedItems();
        this.resolveTable.setInput((Object)this.container.getResolveWizard().unresolved);
        this.updateColors();
        this.selectedItem = -1;
        int i = 0;
        while (i < table.getItemCount()) {
            ResolveWizard.ResolveItem rItem = (ResolveWizard.ResolveItem)table.getItem(i).getData();
            if (rItem.file == item.file) {
                if (rItem.index == item.index) {
                    this.selectedItem = i;
                } else if (this.selectedItem == -1) {
                    this.selectedItem = i;
                }
            }
            ++i;
        }
        table.select(this.selectedItem);
        table.setEnabled(true);
        this.selectItem();
    }

    public void init() {
        this.resolveTable.setInput((Object)this.container.getResolveWizard().unresolved);
    }
}

