/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.p4java.dialogs;

import com.perforce.p4java.server.IServerInfo;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.P4Event;
import com.perforce.team.core.p4java.P4Workspace;
import com.perforce.team.ui.dialogs.PerforceDialog;
import com.perforce.team.ui.p4java.dialogs.Messages;
import java.text.MessageFormat;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class PasswordDialog
extends PerforceDialog {
    private Text passwordControl;
    private Button saveCheck;
    private boolean showOffline = true;
    private IP4Connection connection;
    private String password = null;

    public PasswordDialog(Shell parent, IP4Connection connection) {
        this(parent, connection, true);
    }

    public PasswordDialog(Shell parent, IP4Connection connection, boolean showOffline) {
        super(parent, Messages.PasswordDialog_EnterPassword);
        this.connection = connection;
        this.showOffline = showOffline;
        this.setModalResizeStyle();
    }

    public String getPassword() {
        return this.password;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, Messages.PasswordDialog_Cancel, false);
        if (this.showOffline) {
            Button goOffline = this.createButton(parent, 7, Messages.PasswordDialog_WorkOffline, false);
            goOffline.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PasswordDialog.this.connection.setOffline(true);
                    P4Workspace.getWorkspace().notifyListeners(new P4Event(P4Event.EventType.CHANGED, (IP4Resource)PasswordDialog.this.connection));
                    PasswordDialog.this.close();
                }
            });
        }
    }

    protected Control createDialogArea(Composite parent) {
        IWorkbenchHelpSystem helpSystem;
        Composite composite = (Composite)super.createDialogArea(parent);
        Group conSettings = this.createGroup(composite, Messages.PasswordDialog_Connection, 1);
        this.createLabel((Composite)conSettings, MessageFormat.format(Messages.PasswordDialog_Server, this.connection.getAddress()));
        this.createBrokerServerLabelIfExist(conSettings);
        this.createLabel((Composite)conSettings, MessageFormat.format(Messages.PasswordDialog_User, this.connection.getUser()));
        this.createLabel((Composite)conSettings, MessageFormat.format(Messages.PasswordDialog_Client, this.connection.getClientName()));
        this.createLabel(composite, Messages.PasswordDialog_EnterPasswordLabel);
        this.passwordControl = new Text(composite, 0x400804);
        this.passwordControl.setLayoutData((Object)new GridData(4, 4, true, false));
        this.passwordControl.setEchoChar('*');
        this.passwordControl.setFocus();
        this.saveCheck = this.createCheck(composite, Messages.PasswordDialog_RememberPassword);
        this.saveCheck.setSelection(this.connection.getParameters().savePassword());
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null && (helpSystem = workbench.getHelpSystem()) != null) {
            helpSystem.setHelp((Control)this.saveCheck, "com.perforce.team.ui.auth_remember_password");
        }
        return composite;
    }

    private void createBrokerServerLabelIfExist(Group parent) {
        String brokerAddress;
        IServerInfo serverInfo = this.connection.getServerInfo();
        if (serverInfo != null && StringUtils.isNotBlank((CharSequence)(brokerAddress = serverInfo.getBrokerAddress()))) {
            this.createLabel((Composite)parent, MessageFormat.format(Messages.PasswordDialog_Broker_Server, brokerAddress));
        }
    }

    public Text getPasswordText() {
        return this.passwordControl;
    }

    protected void okPressed() {
        this.updatePassword();
        boolean save = this.saveCheck.getSelection();
        this.connection.getParameters().setSavePassword(save);
        super.okPressed();
    }

    public void updatePassword() {
        this.password = this.passwordControl.getText();
    }
}

