/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.p4java.dialogs;

import com.perforce.p4java.core.file.FileAction;
import com.perforce.p4java.core.file.FileSpecOpStatus;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.ui.dialogs.PerforceDialog;
import com.perforce.team.ui.p4java.dialogs.Messages;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class IntegrationPreviewDialog
extends PerforceDialog {
    private Composite displayArea;
    private TextViewer viewer;
    private StringBuffer text;

    public IntegrationPreviewDialog(Shell parent, IP4Resource[] resources) {
        this(parent, resources, Messages.IntegrationPreviewDialog_IntegrationPreview);
    }

    public IntegrationPreviewDialog(Shell parent, IP4Resource[] resources, String title) {
        super(parent, title);
        this.setModalResizeStyle();
        this.text = new StringBuffer();
        IP4Resource[] iP4ResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IP4Resource preview = iP4ResourceArray[n2];
            if (preview instanceof IP4File) {
                IP4File file = (IP4File)preview;
                if (file.getStatus() == FileSpecOpStatus.VALID) {
                    IFileSpec spec = file.getIntegrationSpec();
                    if (spec != null) {
                        this.text.append(spec.getDepotPath());
                        this.text.append("#");
                        this.text.append(spec.getWorkRev());
                        FileAction action1 = spec.getAction();
                        FileAction action2 = spec.getOtherAction();
                        this.text.append(" - ");
                        if (action1 != null) {
                            this.text.append(action1.toString().toLowerCase());
                        }
                        if (action2 != null) {
                            if (action1 != null) {
                                this.text.append("/");
                            }
                            this.text.append(action2.toString().toLowerCase());
                        }
                        this.text.append(Messages.IntegrationPreviewDialog_From);
                        this.text.append(spec.getFromFile());
                        this.text.append("#");
                        int start = spec.getStartFromRev();
                        if (start == -1) {
                            start = 1;
                        }
                        this.text.append(start);
                        this.text.append(",#");
                        this.text.append(spec.getEndFromRev());
                        this.text.append("\n");
                    }
                } else {
                    String message = file.getStatusMessage();
                    if (message != null) {
                        this.text.append(message);
                        this.text.append("\n");
                    }
                }
            }
            ++n2;
        }
    }

    public TextViewer getViewer() {
        return this.viewer;
    }

    protected Control createDialogArea(Composite parent) {
        Composite c = (Composite)super.createDialogArea(parent);
        this.displayArea = new Composite(c, 0);
        this.displayArea.setLayout((Layout)new GridLayout(1, true));
        this.displayArea.setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer = new TextViewer(this.displayArea, 2826);
        GridData vData = new GridData(4, 4, true, true);
        vData.heightHint = 250;
        vData.widthHint = 500;
        this.viewer.getTextWidget().setLayoutData((Object)vData);
        Document document = new Document(this.text.toString());
        this.viewer.setDocument((IDocument)document);
        return c;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, Messages.IntegrationPreviewDialog_Close, true);
    }
}

