/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.p4java.dialogs;

import com.perforce.p4java.core.IStream;
import com.perforce.p4java.core.IStreamSummary;
import com.perforce.p4java.option.Options;
import com.perforce.p4java.option.client.CopyFilesOptions;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4Stream;
import com.perforce.team.core.p4java.P4FileIntegration;
import com.perforce.team.ui.p4java.dialogs.IntegrateToStreamDialog;
import com.perforce.team.ui.p4java.dialogs.Messages;
import com.perforce.team.ui.p4java.dialogs.RevisionUptoWidget2;
import com.perforce.team.ui.p4java.dialogs.SourceTargetStreamWidget;
import com.perforce.team.ui.streams.StreamUtil;
import java.util.List;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class CopyToStreamDialog
extends IntegrateToStreamDialog {
    public CopyToStreamDialog(Shell parent, IP4Resource connection) {
        super(parent, connection, Messages.CopyToStreamDialog_Title);
    }

    @Override
    protected IntegrateToStreamDialog.IRevisionRangeWidget createRevisionRangeWidget(Composite parent) {
        return new RevisionUptoWidget2(parent, 0, Messages.CopyToStreamDialog_LimitRevisionRange, this.getConnection());
    }

    @Override
    protected List<IStreamSummary> getPreferredStreams(IP4Resource resource) {
        IStream stream = StreamUtil.getStream(resource.getConnection());
        return StreamUtil.getPreferredCopySources(stream, resource.getConnection());
    }

    @Override
    protected SourceTargetStreamWidget createSourceTargetWidget(Composite parent, final IP4Resource resource) {
        return new SourceTargetStreamWidget(parent, 0, Messages.CopyToStreamDialog_SourceTargetTitle, resource){

            @Override
            public Runnable getNonUIJob() {
                return new Runnable(){

                    @Override
                    public void run() {
                        targetStream = resource instanceof IP4Stream ? (IStream)resource.getAdapter(IStream.class) : StreamUtil.getStream(resource.getConnection());
                        preferredStreams.addAll(StreamUtil.getPreferredCopySources(targetStream, resource.getConnection()));
                    }
                };
            }
        };
    }

    protected CopyFilesOptions updatePreviewOptions() {
        CopyFilesOptions option = this.updateOptions();
        option.setNoUpdate(true);
        return option;
    }

    @Override
    protected Options updateNonPreviewOptions() {
        CopyFilesOptions option = this.updateOptions();
        option.setNoUpdate(false);
        return option;
    }

    private CopyFilesOptions updateOptions() {
        CopyFilesOptions option = new CopyFilesOptions();
        option.setBidirectional(false);
        option.setChangelistId(this.getChangelist());
        option.setForceStreamCopy(false);
        IStreamSummary source = this.pathWidget.getSourcePath();
        IStreamSummary target = this.pathWidget.getTargetPath();
        Object effectiveTarget = null;
        effectiveTarget = target.getType() == IStreamSummary.Type.VIRTUAL ? StreamUtil.getBaseParent(target, this.getConnection()) : this.getConnection().getStreamSummary(target.getStream());
        Object effectiveSource = null;
        effectiveSource = source.getType() == IStreamSummary.Type.VIRTUAL ? StreamUtil.getBaseParent(source, this.getConnection()) : this.getConnection().getStreamSummary(source.getStream());
        Assert.isNotNull((Object)effectiveSource);
        Assert.isNotNull((Object)effectiveTarget);
        if (effectiveTarget.getStream().equals(effectiveSource.getParent()) || effectiveTarget.getStream().equals(StreamUtil.getBaseParent((IStreamSummary)effectiveSource))) {
            option.setStream(source.getStream());
            option.setReverseMapping(false);
        } else if (effectiveSource.getStream().equals(effectiveTarget.getParent()) || effectiveSource.getStream().equals(StreamUtil.getBaseParent((IStreamSummary)effectiveTarget))) {
            option.setStream(target.getStream());
            option.setReverseMapping(true);
        } else if (effectiveTarget.getType() == IStreamSummary.Type.RELEASE && effectiveSource.getType() != IStreamSummary.Type.DEVELOPMENT || effectiveTarget.getType() == IStreamSummary.Type.DEVELOPMENT && effectiveSource.getType() == IStreamSummary.Type.MAINLINE) {
            option.setStream(target.getStream());
            option.setParentStream(source.getStream());
            option.setReverseMapping(true);
        } else {
            option.setStream(source.getStream());
            option.setParentStream(target.getStream());
            option.setReverseMapping(false);
        }
        return option;
    }

    @Override
    protected IP4Resource[] doIntegrate(IP4Connection connection, P4FileIntegration integration, String description, Options options) {
        if (options instanceof CopyFilesOptions) {
            return connection.copyStream(integration, description, (CopyFilesOptions)options);
        }
        return null;
    }

    @Override
    protected String getOkButtonText() {
        return Messages.CopyToStreamDialog_CopyButtonText;
    }

    @Override
    protected IStatus validateTaskStreamOp() {
        IStreamSummary source = this.pathWidget.getSourcePath();
        IStreamSummary target = this.pathWidget.getTargetPath();
        if (target.getType() == IStreamSummary.Type.TASK && !target.getStream().equals(source.getParent())) {
            String msg = Messages.CopyToStreamDialog_TaskStreamCannotCopyToNonParent;
            return ValidationStatus.error((String)msg);
        }
        return ValidationStatus.ok();
    }
}

