/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.p4java.actions;

import com.perforce.p4java.core.ChangelistStatus;
import com.perforce.p4java.core.IChangelist;
import com.perforce.team.core.P4CoreUtils;
import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.p4java.IP4Changelist;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4PendingChangelist;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4Revision;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.IP4ShelvedChangelist;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.ui.P4ConnectionManager;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.changelists.ChangelistEditorInput;
import com.perforce.team.ui.p4java.actions.Messages;
import com.perforce.team.ui.p4java.actions.P4Action;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;

public class ViewChangelistAction
extends P4Action {
    public void view(final int id, final IP4Connection connection, final IChangelist.Type type) {
        if (connection == null || type == null || id <= 0) {
            return;
        }
        P4Runnable runnable = new P4Runnable(){

            public String getTitle() {
                return MessageFormat.format(Messages.ViewChangelistAction_OpeningChangelist, id);
            }

            public void run(IProgressMonitor monitor) {
                if (connection != null) {
                    ChangelistStatus status = null;
                    switch (type) {
                        case PENDING: 
                        case SHELVED: {
                            status = ChangelistStatus.PENDING;
                            break;
                        }
                        default: {
                            status = ChangelistStatus.SUBMITTED;
                        }
                    }
                    IP4Changelist list = connection.getChangelistById(id, null, true, false);
                    if (list != null) {
                        if (status == ChangelistStatus.SUBMITTED && list.getStatus() == ChangelistStatus.PENDING) {
                            ViewChangelistAction.this.showPendingError(id);
                        } else if (type == IChangelist.Type.SHELVED) {
                            ViewChangelistAction.this.viewShelved(list, id);
                        } else {
                            ViewChangelistAction.this.view(list);
                        }
                    }
                }
            }
        };
        this.runRunnable((IP4Runnable)runnable);
    }

    private void showPendingError(int id) {
        final String message = MessageFormat.format(Messages.ViewChangelistAction_ChangelistIsPendingMessage, id);
        PerforceUIPlugin.syncExec(new Runnable(){

            @Override
            public void run() {
                P4ConnectionManager.getManager().openError(P4UIUtils.getDialogShell(), Messages.ViewChangelistAction_ChangelistIsPendingTitle, message);
            }
        });
    }

    private void viewShelved(IP4Changelist list, int id) {
        boolean showError = false;
        if (list instanceof IP4PendingChangelist) {
            IP4PendingChangelist pending = (IP4PendingChangelist)list;
            IP4ShelvedChangelist shelved = pending.getShelvedChanges();
            if (shelved != null) {
                shelved.refresh();
                if (shelved.members().length > 0) {
                    this.view((IP4Changelist)shelved);
                } else {
                    showError = true;
                }
            } else {
                showError = true;
            }
        } else {
            showError = true;
        }
        if (showError) {
            final String message = MessageFormat.format(Messages.ViewChangelistAction_NoShelvedFilesMessage, id);
            PerforceUIPlugin.syncExec(new Runnable(){

                @Override
                public void run() {
                    P4ConnectionManager.getManager().openError(P4UIUtils.getDialogShell(), Messages.ViewChangelistAction_NoShelvedFilesTitle, message);
                }
            });
        }
    }

    public void view(int id, IP4Connection connection) {
        this.view(id, connection, IChangelist.Type.SUBMITTED);
    }

    protected void view(final IP4Changelist changelist) {
        if (changelist == null || changelist.getConnection().isOffline()) {
            return;
        }
        IP4Resource[] files = changelist.getFiles();
        if (files == null || files.length == 0) {
            changelist.refresh();
            files = changelist.getFiles();
        }
        if (files != null && files.length > 0) {
            PerforceUIPlugin.syncExec(new Runnable(){

                @Override
                public void run() {
                    ChangelistEditorInput input = new ChangelistEditorInput(changelist);
                    try {
                        IDE.openEditor((IWorkbenchPage)PerforceUIPlugin.getActivePage(), (IEditorInput)input, (String)"com.perforce.team.ui.changelists.ChangelistEditor");
                    }
                    catch (PartInitException e) {
                        PerforceProviderPlugin.logError((Throwable)e);
                    }
                }
            });
        }
    }

    @Override
    protected void runAction() {
        Object[] resources = null;
        if (this.getSelection() != null) {
            resources = this.getSelection().toArray();
        } else if (this.collection != null) {
            resources = this.collection.members();
        }
        if (resources != null) {
            Object[] objectArray = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                Object resource = objectArray[n2];
                IP4Changelist list = (IP4Changelist)P4CoreUtils.convert((Object)resource, IP4Changelist.class);
                if (list != null) {
                    this.view(list);
                } else {
                    IP4Revision revision = (IP4Revision)P4CoreUtils.convert((Object)resource, IP4Revision.class);
                    if (revision != null) {
                        this.view(revision.getChangelist(), revision.getConnection());
                    }
                }
                ++n2;
            }
        }
    }
}

