/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.p4java.actions;

import com.perforce.team.core.Policy;
import com.perforce.team.core.Tracing;
import com.perforce.team.core.p4java.IP4Changelist;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Container;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4Job;
import com.perforce.team.core.p4java.IP4PendingChangelist;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.P4Collection;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.ui.P4ConnectionManager;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.changelists.ISubmitMessageProvider;
import com.perforce.team.ui.p4java.actions.Messages;
import com.perforce.team.ui.p4java.actions.P4Action;
import com.perforce.team.ui.p4java.dialogs.ChangeSpecDialog;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class SubmitAction
extends P4Action {
    private P4Collection collectionSelection = new P4Collection();
    private String description = null;
    private boolean reopen = false;
    private String status = null;
    private ISubmitMessageProvider messageProvider = null;

    public ISubmitMessageProvider getMessageProvider() {
        return this.messageProvider;
    }

    public void setMessageProvider(ISubmitMessageProvider messageProvider) {
        this.messageProvider = messageProvider;
    }

    @Override
    public boolean isEnabledEx() {
        boolean enabled = this.containsOnlineConnection();
        if (enabled && !(enabled = this.containsContainers())) {
            P4Collection collection = this.getResourceSelection();
            IP4Resource[] iP4ResourceArray = collection.members();
            int n = iP4ResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IP4Resource resource = iP4ResourceArray[n2];
                if (resource instanceof IP4PendingChangelist) {
                    IP4PendingChangelist list = (IP4PendingChangelist)resource;
                    if (list.isOnClient() && list.getFiles().length > 0) {
                        enabled = true;
                        break;
                    }
                } else {
                    IP4File file;
                    if (resource instanceof IP4Container) {
                        enabled = true;
                        break;
                    }
                    if (resource instanceof IP4File && (file = (IP4File)resource).isOpened()) {
                        enabled = true;
                        break;
                    }
                }
                ++n2;
            }
        }
        return enabled;
    }

    public P4Collection getSelected() {
        return this.collectionSelection;
    }

    private void resetStateValidation() {
        if (this.collectionSelection != null && !this.collectionSelection.isEmpty()) {
            this.collectionSelection.resetStateValidation();
        }
    }

    public void submit(final IP4PendingChangelist list, final IP4Job[] uncheckedJobs, final IP4Job[] checkedJobs, final IP4File[] files, final String description, final boolean reopen, final String status) {
        if (files != null) {
            IP4File[] iP4FileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                IP4File file = iP4FileArray[n2];
                this.collectionSelection.add((IP4Resource)file);
                ++n2;
            }
            WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

                protected void execute(final IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                    monitor.beginTask("", 1000);
                    monitor.setTaskName(Messages.SubmitAction_SubmittingChangelist);
                    try {
                        if (uncheckedJobs != null && uncheckedJobs.length > 0) {
                            SubmitAction.this.createCollection((IP4Resource[])uncheckedJobs).unfix((IP4Changelist)list);
                        }
                        monitor.worked(100);
                        final int[] ids = new int[1];
                        try {
                            Tracing.printExecTime2((boolean)Policy.DEBUG_TIME, (String)"SUBMIT", (String)"Submitting pendinglist...", (Tracing.IRunnable)new Tracing.IRunnable(){

                                public void run() throws Throwable {
                                    ids[0] = list.submit(reopen, description, files, checkedJobs, status, (IProgressMonitor)new SubProgressMonitor(monitor, 700));
                                }
                            });
                        }
                        catch (Throwable e) {
                            if (e instanceof CoreException) {
                                throw (CoreException)e;
                            }
                            if (e instanceof InvocationTargetException) {
                                throw (InvocationTargetException)e;
                            }
                            if (e instanceof InterruptedException) {
                                throw (InterruptedException)e;
                            }
                            e.printStackTrace();
                        }
                        int id = ids[0];
                        monitor.setTaskName(Messages.SubmitAction_RefreshingSubmittedFiles);
                        monitor.worked(100);
                        SubmitAction.this.createCollection((IP4Resource[])files).refreshLocalResources(1);
                        monitor.worked(100);
                        if (id > 0) {
                            monitor.setTaskName(MessageFormat.format(Messages.SubmitAction_ChangelistSubmitted, id));
                        }
                    }
                    finally {
                        monitor.done();
                    }
                    SubmitAction.this.updateActionState();
                }
            };
            this.run((IRunnableWithProgress)operation, Messages.SubmitAction_SubmittingChangelist, Messages.SubmitAction_SubmitFailed, 3);
        }
    }

    private Map<IP4Connection, List<IP4Resource>> getConnectionMapping(P4Collection collection) {
        HashMap<IP4Connection, List<IP4Resource>> connectionResources = new HashMap<IP4Connection, List<IP4Resource>>();
        IP4Resource[] iP4ResourceArray = collection.members();
        int n = iP4ResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IP4Resource resource = iP4ResourceArray[n2];
            IP4Connection connection = resource.getConnection();
            if (connection != null) {
                connection.getJobSpec();
                ArrayList<IP4Resource> connResources = (ArrayList<IP4Resource>)connectionResources.get(connection);
                if (connResources == null) {
                    connResources = new ArrayList<IP4Resource>();
                    connectionResources.put(connection, connResources);
                }
                connResources.add(resource);
            }
            ++n2;
        }
        return connectionResources;
    }

    private void submitListsFromCollection(final P4Collection collection, final boolean showDialog) {
        P4Runnable runnable = new P4Runnable(){

            public void run(IProgressMonitor monitor) {
                Map connectionResources = SubmitAction.this.getConnectionMapping(collection);
                HashMap<IP4PendingChangelist, List> initialCheckedMap = new HashMap<IP4PendingChangelist, List>();
                for (Map.Entry entry : connectionResources.entrySet()) {
                    IP4Connection connection = (IP4Connection)entry.getKey();
                    List resources = (List)entry.getValue();
                    IP4PendingChangelist[] allLists = connection.getCachedPendingChangelists();
                    for (IP4Resource resource : resources) {
                        IP4PendingChangelist list;
                        if (resource instanceof IP4PendingChangelist) {
                            list = (IP4PendingChangelist)resource;
                            if (!initialCheckedMap.containsKey(list) && list.needsRefresh()) {
                                list.refresh();
                            }
                            initialCheckedMap.put(list, Arrays.asList(list.getPendingFiles()));
                            continue;
                        }
                        if (resource instanceof IP4File) {
                            ArrayList<IP4File> files;
                            IP4File file = (IP4File)resource;
                            IP4PendingChangelist changelist = file.getChangelist(true);
                            if (changelist == null) continue;
                            if (!initialCheckedMap.containsKey(changelist) && changelist.needsRefresh()) {
                                changelist.refresh();
                            }
                            if ((files = (ArrayList<IP4File>)initialCheckedMap.get(changelist)) == null) {
                                files = new ArrayList<IP4File>();
                                initialCheckedMap.put(changelist, files);
                            }
                            if (files.contains(file)) continue;
                            files.add(file);
                            continue;
                        }
                        if (!(resource instanceof IP4Container)) continue;
                        IP4PendingChangelist[] iP4PendingChangelistArray = allLists;
                        int n = allLists.length;
                        int n2 = 0;
                        while (n2 < n) {
                            list = iP4PendingChangelistArray[n2];
                            List existing = (List)initialCheckedMap.get(list);
                            if (list.needsRefresh()) {
                                list.refresh();
                            }
                            List files = SubmitAction.this.findCheckedFiles((IP4Container)resource, list);
                            if (existing == null) {
                                if (files.size() > 0) {
                                    initialCheckedMap.put(list, files);
                                }
                            } else {
                                existing.addAll(files);
                            }
                            ++n2;
                        }
                    }
                }
                SubmitAction.this.showSubmitDialogs(initialCheckedMap, showDialog);
            }

            public String getTitle() {
                return Messages.SubmitAction_SubmittingChangelistTitle;
            }
        };
        this.runRunnable((IP4Runnable)runnable);
    }

    private List<IP4File> findCheckedFiles(IP4Container container, IP4PendingChangelist list) {
        ArrayList<IP4File> files;
        block5: {
            String cPath;
            block4: {
                files = new ArrayList<IP4File>();
                cPath = container.getLocalPath();
                if (cPath == null) break block4;
                cPath = cPath.toUpperCase();
                IP4Resource[] iP4ResourceArray = list.members();
                int n = iP4ResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String localPath;
                    IP4Resource file = iP4ResourceArray[n2];
                    if (file instanceof IP4File && (localPath = file.getLocalPath()) != null && (localPath = localPath.toUpperCase()).startsWith(cPath)) {
                        files.add((IP4File)file);
                    }
                    ++n2;
                }
                break block5;
            }
            cPath = container.getRemotePath();
            if (cPath == null) break block5;
            IP4Resource[] iP4ResourceArray = list.members();
            int n = iP4ResourceArray.length;
            int n3 = 0;
            while (n3 < n) {
                String remotePath;
                IP4Resource file = iP4ResourceArray[n3];
                if (file instanceof IP4File && (remotePath = file.getRemotePath()) != null && (remotePath = remotePath.toUpperCase()).startsWith(cPath)) {
                    files.add((IP4File)file);
                }
                ++n3;
            }
        }
        return files;
    }

    private boolean validateList(IP4PendingChangelist list) {
        boolean valid = false;
        if (!list.isDefault() && list.isShelved()) {
            if (P4ConnectionManager.getManager().openQuestion(P4UIUtils.getDialogShell(), Messages.SubmitAction_ChangelistHasShelvedFilesTitle, MessageFormat.format(Messages.SubmitAction_ChangelistHasShelvedFilesMessage, list.getId()))) {
                list.deleteShelved();
                valid = !list.isShelved();
            }
        } else {
            valid = true;
        }
        return valid;
    }

    private void showSubmitDialogs(final Map<IP4PendingChangelist, List<IP4File>> lists, final boolean showDialog) {
        PerforceUIPlugin.syncExec(new Runnable(){

            @Override
            public void run() {
                if (!lists.isEmpty()) {
                    for (final IP4PendingChangelist list : lists.keySet()) {
                        final IP4File[] files = ((List)lists.get(list)).toArray(new IP4File[0]);
                        Tracing.printExecTime3((boolean)Policy.DEBUG, (String)"SUBMIT", (String)"SubmitAction.saveDirtyResources()", (Tracing.IRunnable)new Tracing.IRunnable(){

                            public void run() throws Throwable {
                                PerforceUIPlugin.saveDirtyResources(SubmitAction.this.getTargetPage(), files);
                            }
                        });
                        if (showDialog) {
                            boolean listValid = SubmitAction.this.validateList(list);
                            if (!listValid) continue;
                            String description = null;
                            if (SubmitAction.this.messageProvider != null) {
                                description = SubmitAction.this.messageProvider.getDescription(list);
                            }
                            Tracing.printTrace((boolean)Policy.DEBUG, (String)"SUBMIT", (String)"create ChangeSpecDialog");
                            ChangeSpecDialog dialog = new ChangeSpecDialog(list, (IP4Resource[])files, SubmitAction.this.getShell(), true, description);
                            Tracing.printTrace((boolean)Policy.DEBUG, (String)"SUBMIT", (String)"poping up ChangeSpecDialog");
                            if (dialog.open() != 0) continue;
                            IP4Job[] checkedJobs = dialog.getCheckedJobs();
                            IP4Job[] uncheckedJobs = dialog.getUncheckedJobs();
                            SubmitAction.this.submit(list, uncheckedJobs, checkedJobs, dialog.getCheckedFiles(), dialog.getDescription(), dialog.reopenFiles(), dialog.getStatus());
                            continue;
                        }
                        if (SubmitAction.this.description == null) continue;
                        Tracing.printExecTime3((boolean)Policy.DEBUG, (String)"SUBMIT", (String)"SubmitAction.submit()", (Tracing.IRunnable)new Tracing.IRunnable(){

                            public void run() throws Throwable {
                                SubmitAction.this.submit(list, null, null, files, SubmitAction.this.description, SubmitAction.this.reopen, SubmitAction.this.status);
                            }
                        });
                    }
                    Tracing.printExecTime3((boolean)Policy.DEBUG, (String)"SUBMIT", (String)"SubmitAction.resetStateValidation()", (Tracing.IRunnable)new Tracing.IRunnable(){

                        public void run() throws Throwable {
                            SubmitAction.this.resetStateValidation();
                        }
                    });
                } else {
                    P4ConnectionManager.getManager().openInformation(SubmitAction.this.getShell(), Messages.SubmitAction_NoFilesToSubmitTitle, Messages.SubmitAction_NoFilesToSubmitMessage);
                }
            }
        });
    }

    public void runAction(boolean showDialog) {
        P4Collection collection = this.getResourceSelection();
        this.submitListsFromCollection(collection, showDialog);
    }

    @Override
    public void runAction() {
        this.runAction(true);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isReopen() {
        return this.reopen;
    }

    public void setReopen(boolean reopen) {
        this.reopen = reopen;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }
}

