/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.p4java.actions;

import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4PendingChangelist;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.P4Collection;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.dialogs.ConfirmRevertDialog;
import com.perforce.team.ui.p4java.actions.Messages;
import com.perforce.team.ui.p4java.actions.P4Action;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;

public class RevertUnchangedAction
extends P4Action {
    private P4Collection collectionSelection = null;

    public void runAction(final boolean showDialog) {
        final P4Collection collection = this.getResourceSelection();
        P4Runnable runnable = new P4Runnable(){

            public void run(IProgressMonitor monitor) {
                monitor.beginTask(this.getTitle(), 1);
                monitor.setTaskName(RevertUnchangedAction.this.generateTitle(null, collection));
                P4Collection reverts = collection.previewUnchangedRevert();
                final ArrayList<IP4File> files = new ArrayList<IP4File>();
                IP4Resource[] iP4ResourceArray = reverts.allMembers();
                int n = iP4ResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IP4Resource resource = iP4ResourceArray[n2];
                    if (resource instanceof IP4File) {
                        files.add((IP4File)resource);
                    }
                    ++n2;
                }
                monitor.worked(1);
                monitor.done();
                PerforceUIPlugin.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (files.size() > 0) {
                            IP4File[] selected = null;
                            if (showDialog) {
                                ConfirmRevertDialog dialog = new ConfirmRevertDialog(RevertUnchangedAction.this.getShell(), files.toArray(new IP4File[0]));
                                if (dialog.open() == 0) {
                                    selected = dialog.getSelected();
                                }
                            } else {
                                selected = files.toArray(new IP4File[0]);
                            }
                            if (selected != null && selected.length > 0) {
                                RevertUnchangedAction.this.collectionSelection = RevertUnchangedAction.this.createCollection((IP4Resource[])selected);
                                RevertUnchangedAction.this.revert(RevertUnchangedAction.this.collectionSelection, collection);
                            }
                        } else if (showDialog) {
                            MessageDialog.openInformation((Shell)RevertUnchangedAction.this.getShell(), (String)Messages.RevertUnchangedAction_RevertUnchangedTitle, (String)Messages.RevertUnchangedAction_RevertUnchangedMessage);
                        }
                    }
                });
            }

            public String getTitle() {
                return Messages.RevertUnchangedAction_RevertingUnchanged;
            }
        };
        this.runRunnable((IP4Runnable)runnable);
    }

    @Override
    public void runAction() {
        this.runAction(true);
    }

    private void revert(final P4Collection collectionSelection, final P4Collection resourceCollection) {
        P4Runnable runnable = new P4Runnable(){

            public void run(IProgressMonitor monitor) {
                monitor.beginTask(this.getTitle(), 2);
                monitor.setTaskName(RevertUnchangedAction.this.generateTitle(null, collectionSelection));
                collectionSelection.revert();
                monitor.worked(1);
                monitor.setTaskName(Messages.RevertUnchangedAction_RefreshingLocalResources);
                resourceCollection.refreshLocalResources(2);
                collectionSelection.resetStateValidation();
                monitor.worked(1);
                monitor.done();
                RevertUnchangedAction.this.updateActionState();
            }

            public String getTitle() {
                return Messages.RevertUnchangedAction_RevertingFiles;
            }
        };
        this.runRunnable((IP4Runnable)runnable);
    }

    public P4Collection getSelected() {
        return this.collectionSelection;
    }

    @Override
    protected boolean isEnabledEx() throws TeamException {
        P4Collection collection;
        IP4Resource[] resources;
        int size;
        boolean enabled = this.containsOnlineConnection();
        if (enabled && !(enabled = this.containsContainers()) && (size = (resources = (collection = super.getResourceSelection()).members()).length) > 0) {
            IP4Resource[] iP4ResourceArray = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IP4Resource resource = iP4ResourceArray[n2];
                if (resource instanceof IP4File) {
                    IP4PendingChangelist list;
                    IP4File file = (IP4File)resource;
                    if (file.getAction() != null && (list = file.getChangelist()) != null && list.isOnClient() && !list.isReadOnly()) {
                        enabled = true;
                        break;
                    }
                } else {
                    enabled = true;
                    break;
                }
                ++n2;
            }
        }
        return enabled;
    }
}

