/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.p4java.actions;

import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4PendingChangelist;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.P4Collection;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.core.p4java.P4Runner;
import com.perforce.team.ui.dialogs.ConfirmRevertDialog;
import com.perforce.team.ui.p4java.actions.DeleteChangelistAction;
import com.perforce.team.ui.p4java.actions.Messages;
import com.perforce.team.ui.p4java.actions.P4Action;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;

public class RevertAction
extends P4Action {
    private P4Collection collectionSelection = null;

    public RevertAction() {
        this.setAsync(false);
    }

    protected P4Collection getCollection(P4Collection collection) {
        P4Collection changelistCollection = this.createCollection();
        IP4Resource[] iP4ResourceArray = collection.members();
        int n = iP4ResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IP4Resource resource = iP4ResourceArray[n2];
            if (resource instanceof IP4PendingChangelist) {
                IP4Resource[] resources;
                IP4PendingChangelist list = (IP4PendingChangelist)resource;
                if (list.needsRefresh()) {
                    list.refresh();
                }
                IP4Resource[] iP4ResourceArray2 = resources = list.members();
                int n3 = resources.length;
                int n4 = 0;
                while (n4 < n3) {
                    IP4Resource file = iP4ResourceArray2[n4];
                    changelistCollection.add(file);
                    ++n4;
                }
            } else {
                changelistCollection.add(resource);
            }
            ++n2;
        }
        return changelistCollection;
    }

    protected ConfirmRevertDialog createDialog(List<IP4File> files) {
        return new ConfirmRevertDialog(this.getShell(), files.toArray(new IP4File[files.size()]), false);
    }

    protected void deleteEmpties(final P4Collection collection) {
        P4Runner.schedule((IP4Runnable)new P4Runnable(){

            public String getTitle() {
                return Messages.RevertAction_DeletingEmptyChangelists;
            }

            public void run(IProgressMonitor monitor) {
                P4Collection delete = RevertAction.this.createCollection();
                IP4Resource[] iP4ResourceArray = collection.members();
                int n = iP4ResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IP4Resource resource = iP4ResourceArray[n2];
                    if (resource instanceof IP4PendingChangelist) {
                        IP4PendingChangelist list = (IP4PendingChangelist)resource;
                        if (list.needsRefresh()) {
                            list.refresh();
                        }
                        if (list.isDeleteable() && !list.isShelved()) {
                            delete.add(resource);
                        }
                    }
                    ++n2;
                }
                DeleteChangelistAction deleteAction = new DeleteChangelistAction();
                deleteAction.setAsync(false);
                deleteAction.setCollection(delete);
                deleteAction.run(null);
            }
        });
    }

    public void runAction(boolean showDialog) {
        P4Collection collection = this.getResourceSelection();
        P4Collection changelistCollection = this.getCollection(collection);
        P4Collection reverts = changelistCollection.previewRevert();
        ArrayList<IP4File> files = new ArrayList<IP4File>();
        IP4Resource[] iP4ResourceArray = reverts.allMembers();
        int n = iP4ResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IP4Resource resource = iP4ResourceArray[n2];
            if (resource instanceof IP4File) {
                files.add((IP4File)resource);
            }
            ++n2;
        }
        if (files.size() > 0) {
            IP4File[] selected = null;
            P4Collection deleteCollection = null;
            boolean deleteShelved = false;
            boolean deleteEmpties = false;
            if (showDialog) {
                ConfirmRevertDialog dialog = this.createDialog(files);
                if (dialog.open() == 0) {
                    selected = dialog.getSelected();
                    deleteShelved = dialog.deleteShelvedFiles();
                    deleteEmpties = dialog.deleteEmptyChangelists();
                    if (deleteShelved || deleteEmpties) {
                        deleteCollection = changelistCollection;
                    }
                }
            } else {
                selected = files.toArray(new IP4File[0]);
            }
            if (selected != null && selected.length > 0) {
                this.collectionSelection = this.createCollection((IP4Resource[])selected);
                this.collectionSelection.setType(collection.getType());
                this.revert(this.collectionSelection, deleteCollection, deleteEmpties, deleteShelved);
            }
        } else if (showDialog) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.RevertAction_NoFilesToRevertTitle, (String)Messages.RevertAction_NoFilesToRevertMessage);
        }
    }

    @Override
    public void runAction() {
        this.runAction(true);
    }

    private void deleteShelved(Map<IP4PendingChangelist, List<IP4Resource>> shelvedCollection) {
        for (Map.Entry<IP4PendingChangelist, List<IP4Resource>> entry : shelvedCollection.entrySet()) {
            List<IP4Resource> files = entry.getValue();
            if (files == null || files.size() <= 0) continue;
            entry.getKey().deleteShelve(files.toArray(new IP4Resource[files.size()]));
        }
    }

    private void revert(final P4Collection collectionSelection, final P4Collection deleteCollection, final boolean deleteEmpties, final boolean deleteShelved) {
        P4Runnable runnable = new P4Runnable(){

            public String getTitle() {
                return Messages.RevertAction_Reverting;
            }

            public void run(IProgressMonitor monitor) {
                IP4Resource resource;
                int n;
                int n2;
                IP4Resource[] iP4ResourceArray;
                int work = 1;
                if (deleteCollection != null) {
                    if (deleteShelved) {
                        ++work;
                    }
                    if (deleteEmpties) {
                        ++work;
                    }
                }
                monitor.beginTask(this.getTitle(), work);
                monitor.subTask(RevertAction.this.generateTitle(null, collectionSelection));
                HashMap deleteShelvedCollection = null;
                if (deleteShelved) {
                    deleteShelvedCollection = new HashMap();
                    iP4ResourceArray = collectionSelection.members();
                    n2 = iP4ResourceArray.length;
                    n = 0;
                    while (n < n2) {
                        IP4File file;
                        IP4PendingChangelist list;
                        resource = iP4ResourceArray[n];
                        if (resource instanceof IP4File && (list = (file = (IP4File)resource).getChangelist()) != null) {
                            List<IP4File> files = null;
                            if (deleteShelvedCollection.containsKey(list)) {
                                files = (List)deleteShelvedCollection.get(list);
                            } else {
                                files = new ArrayList();
                                deleteShelvedCollection.put(list, files);
                            }
                            files.add(file);
                        }
                        ++n;
                    }
                }
                collectionSelection.revert();
                monitor.worked(1);
                if (deleteCollection != null) {
                    if (deleteShelved) {
                        monitor.subTask(Messages.RevertAction_DeletingShelvedFilesSubtask);
                        RevertAction.this.deleteShelved(deleteShelvedCollection);
                        monitor.worked(1);
                    }
                    if (deleteEmpties) {
                        monitor.subTask(Messages.RevertAction_DeletingEmptyChangelistsSubtask);
                        RevertAction.this.deleteEmpties(deleteCollection);
                        monitor.worked(1);
                    }
                    iP4ResourceArray = deleteCollection.members();
                    n2 = iP4ResourceArray.length;
                    n = 0;
                    while (n < n2) {
                        IP4PendingChangelist list;
                        resource = iP4ResourceArray[n];
                        if (resource instanceof IP4PendingChangelist && (list = (IP4PendingChangelist)resource).getId() > 0 && list.needsRefresh()) {
                            list.refresh();
                        }
                        ++n;
                    }
                }
                monitor.done();
                collectionSelection.refreshLocalResources(2);
                collectionSelection.resetStateValidation();
                RevertAction.this.updateActionState();
            }
        };
        this.runRunnable((IP4Runnable)runnable);
    }

    public P4Collection getSelected() {
        return this.collectionSelection;
    }

    @Override
    protected boolean isEnabledEx() throws TeamException {
        P4Collection collection;
        IP4Resource[] resources;
        int size;
        boolean enabled = this.containsOnlineConnection();
        if (enabled && !(enabled = this.containsContainers()) && (size = (resources = (collection = super.getResourceSelection()).members()).length) > 0) {
            IP4Resource[] iP4ResourceArray = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IP4Resource resource = iP4ResourceArray[n2];
                if (resource instanceof IP4File) {
                    IP4PendingChangelist list;
                    IP4File file = (IP4File)resource;
                    if (file.getAction() != null && (list = file.getChangelist()) != null && list.isOnClient() && !list.isReadOnly()) {
                        enabled = true;
                        break;
                    }
                } else {
                    enabled = true;
                    break;
                }
                ++n2;
            }
        }
        return enabled;
    }
}

