/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.p4java.actions;

import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.team.core.P4CoreUtils;
import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Container;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.P4Collection;
import com.perforce.team.core.p4java.P4Runner;
import com.perforce.team.ui.IgnoredFiles;
import com.perforce.team.ui.P4ConnectionManager;
import com.perforce.team.ui.actions.PerforceTeamAction;
import com.perforce.team.ui.p4java.actions.Messages;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public abstract class P4Action
extends PerforceTeamAction
implements IWorkbenchWindowActionDelegate {
    protected boolean quietMode = false;
    public static final String ACTION_EXTENSION_POINT = "com.perforce.team.ui.action";
    private boolean async = true;
    protected P4Collection collection = null;
    private IProgressMonitor monitor = null;

    protected boolean isQuietMode() {
        return this.quietMode;
    }

    protected boolean isResourceIgnored(IResource resource) {
        return PerforceProviderPlugin.isIgnoredHint((IResource)resource) || IgnoredFiles.isIgnored(resource);
    }

    protected void runRunnable(IP4Runnable runnable) {
        if (runnable != null) {
            if (this.isAsync()) {
                P4Runner.schedule((IP4Runnable)runnable);
            } else {
                runnable.run(this.getMonitor());
            }
        }
    }

    protected IProgressMonitor getMonitor() {
        IProgressMonitor current = this.monitor;
        if (current == null) {
            current = new NullProgressMonitor();
        }
        return current;
    }

    protected void updateActionState() {
        PerforceTeamAction.refreshActionState();
    }

    protected boolean containsContainers() {
        if (this.getSelection() != null) {
            Object[] selected;
            Object[] objectArray = selected = this.getSelection().toArray();
            int n = selected.length;
            int n2 = 0;
            while (n2 < n) {
                Object select = objectArray[n2];
                if ((select = this.getResource(select)) instanceof IContainer) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    protected P4Collection createCollection() {
        return P4ConnectionManager.getManager().createP4Collection();
    }

    protected P4Collection createCollection(IP4Resource[] resources) {
        return P4ConnectionManager.getManager().createP4Collection(resources);
    }

    protected boolean containsOnlineConnection() {
        boolean contains = false;
        if (this.getSelection() != null) {
            Object[] selected;
            Object[] objectArray = selected = this.getSelection().toArray();
            int n = selected.length;
            int n2 = 0;
            while (n2 < n) {
                Object select = objectArray[n2];
                IP4Connection connection = null;
                if (select instanceof IP4Resource && !((IP4Resource)select).isReadOnly()) {
                    connection = ((IP4Resource)select).getConnection();
                } else {
                    IResource resource = this.getResource(select);
                    if (resource != null) {
                        IProject project = resource.getProject();
                        connection = P4ConnectionManager.getManager().getConnection(project, false);
                    }
                }
                if (connection != null && !connection.isOffline()) {
                    contains = true;
                    break;
                }
                ++n2;
            }
        }
        return contains;
    }

    protected boolean revisionExists(IP4File file) {
        boolean enabled = false;
        if (file != null) {
            IFileSpec spec;
            enabled = file.getHeadRevision() > 0 ? true : (spec = file.getP4JFile()) != null && spec.getEndRevision() > 0;
        }
        return enabled;
    }

    protected boolean containsSingleOnlineConnection() {
        IP4Connection first = null;
        if (this.getSelection() != null) {
            Object[] selected;
            Object[] objectArray = selected = this.getSelection().toArray();
            int n = selected.length;
            int n2 = 0;
            while (n2 < n) {
                Object select = objectArray[n2];
                IP4Connection connection = null;
                if (select instanceof IP4Resource && !((IP4Resource)select).isReadOnly()) {
                    connection = ((IP4Resource)select).getConnection();
                } else {
                    IResource resource = this.getResource(select);
                    if (resource != null) {
                        IProject project = resource.getProject();
                        connection = P4ConnectionManager.getManager().getConnection(project, false);
                    }
                }
                if (first == null) {
                    first = connection;
                } else if (!first.equals(connection)) {
                    first = null;
                    break;
                }
                ++n2;
            }
        }
        return first != null && !first.isOffline();
    }

    @Override
    protected boolean isEnabledEx() throws TeamException {
        return true;
    }

    protected List<IFile> getAllChildren(IContainer container) {
        ArrayList<IFile> files = new ArrayList<IFile>();
        try {
            IResource[] resources;
            IResource[] iResourceArray = resources = container.members(4);
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                if (resource instanceof IContainer) {
                    files.addAll(this.getAllChildren((IContainer)resource));
                } else if (resource instanceof IFile) {
                    files.add((IFile)resource);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            PerforceProviderPlugin.logError((Throwable)e);
        }
        return files;
    }

    protected P4Collection getFileSelection() {
        if (this.collection == null) {
            Object[] selected = this.getSelection().toArray();
            P4Collection collection = this.createCollection();
            Object[] objectArray = selected;
            int n = selected.length;
            int n2 = 0;
            while (n2 < n) {
                Object select = objectArray[n2];
                if (select instanceof IP4Resource) {
                    collection.add((IP4Resource)select);
                } else {
                    select = this.getResource(select);
                }
                if (select instanceof IContainer) {
                    collection.setType(IP4Resource.Type.LOCAL);
                    List<IFile> files = this.getAllChildren((IContainer)select);
                    for (IFile file : files) {
                        if (PerforceProviderPlugin.isIgnoredHint((IResource)file)) continue;
                        IP4Resource resource = P4ConnectionManager.getManager().getResource((IResource)file);
                        collection.add(resource);
                    }
                } else if (select instanceof IResource) {
                    collection.setType(IP4Resource.Type.LOCAL);
                    if (!PerforceProviderPlugin.isIgnoredHint((IResource)((IResource)select))) {
                        IP4Resource resource = P4ConnectionManager.getManager().getResource((IResource)select);
                        collection.add(resource);
                    }
                }
                ++n2;
            }
            return collection;
        }
        return this.collection;
    }

    protected IP4Resource getSingleResourceSelection() {
        IP4Resource resource = null;
        if (this.collection == null) {
            IResource r;
            Object select;
            Object[] selected = this.getSelection().toArray();
            if (selected.length == 1 && (resource = (IP4Resource)P4CoreUtils.convert((Object)(select = selected[0]), IP4Resource.class)) == null && (r = this.getResource(select)) != null && !PerforceProviderPlugin.isIgnoredHint((IResource)r)) {
                resource = P4ConnectionManager.getManager().getResource(r);
            }
        } else {
            IP4Resource[] members = this.collection.members();
            if (members.length == 1) {
                resource = members[0];
            }
        }
        return resource;
    }

    protected IP4Resource getSingleOnlineResourceSelection() {
        IP4Resource resource = this.getSingleResourceSelection();
        return resource != null && !resource.getConnection().isOffline() ? resource : null;
    }

    protected IP4File getSingleFileSelection() {
        return (IP4File)P4CoreUtils.convert((Object)this.getSingleResourceSelection(), IP4File.class);
    }

    protected IP4Connection getSingleConnectionSelection() {
        IP4Resource resource = this.getSingleResourceSelection();
        if (resource instanceof IP4Connection) {
            return (IP4Connection)resource;
        }
        return null;
    }

    protected IP4Connection getSingleOnlineConnectionSelection() {
        IP4Connection connection = this.getSingleConnectionSelection();
        return connection != null && !connection.isOffline() ? connection : null;
    }

    protected P4Collection getResourceSelection() {
        if (this.collection == null) {
            Object[] selected = this.getSelection().toArray();
            return this.getCollection(selected);
        }
        return this.collection;
    }

    public P4Collection getCollection(Object[] selected) {
        P4Collection collection = this.createCollection();
        Object[] objectArray = selected;
        int n = selected.length;
        int n2 = 0;
        while (n2 < n) {
            Object select = objectArray[n2];
            if (select instanceof IP4Resource) {
                collection.add((IP4Resource)select);
            } else {
                select = this.getResource(select);
            }
            if (select instanceof IResource) {
                IP4Resource resource;
                collection.setType(IP4Resource.Type.LOCAL);
                if (!PerforceProviderPlugin.isIgnoredHint((IResource)((IResource)select)) && (resource = P4ConnectionManager.getManager().getResource((IResource)select)) != null) {
                    collection.add(resource);
                }
            }
            ++n2;
        }
        return collection;
    }

    protected P4Collection getConnectionSelection() {
        if (this.collection == null) {
            Object[] selected = this.getSelection().toArray();
            P4Collection collection = this.createCollection();
            Object[] objectArray = selected;
            int n = selected.length;
            int n2 = 0;
            while (n2 < n) {
                Object select = objectArray[n2];
                if (select instanceof IP4Connection) {
                    collection.add((IP4Resource)((IP4Connection)select));
                } else {
                    select = this.getResource(select);
                }
                if (select instanceof IProject) {
                    IP4Connection connection = P4ConnectionManager.getManager().getConnection((IProject)select, false);
                    collection.add((IP4Resource)connection);
                }
                ++n2;
            }
            return collection;
        }
        return this.collection;
    }

    protected P4Collection getDirectFileSelection() {
        P4Collection fileCollection = this.createCollection();
        if (this.collection == null) {
            Object[] selected = this.getSelection().toArray();
            P4Collection collection = this.createCollection();
            Object[] objectArray = selected;
            int n = selected.length;
            int n2 = 0;
            while (n2 < n) {
                Object select = objectArray[n2];
                if (select instanceof IP4File) {
                    collection.add((IP4Resource)((IP4File)select));
                } else {
                    IP4File adapted = this.getP4File(select);
                    if (adapted != null) {
                        collection.add((IP4Resource)adapted);
                    } else {
                        IP4Resource p4resource;
                        IResource resource = this.getResource(select);
                        if (resource != null && !PerforceProviderPlugin.isIgnoredHint((IResource)resource) && (p4resource = P4ConnectionManager.getManager().getResource(resource)) instanceof IP4File) {
                            collection.add(p4resource);
                        }
                    }
                }
                ++n2;
            }
            return collection;
        }
        IP4Resource[] iP4ResourceArray = this.collection.members();
        int n = iP4ResourceArray.length;
        int n3 = 0;
        while (n3 < n) {
            IP4Resource resource = iP4ResourceArray[n3];
            IP4File file = this.getP4File(resource);
            if (file != null) {
                fileCollection.add((IP4Resource)file);
            }
            ++n3;
        }
        return fileCollection;
    }

    protected List<IResource> getLocalResourceSelection() {
        ArrayList<IResource> resources = null;
        if (this.collection == null) {
            resources = new ArrayList<IResource>();
            Hashtable<RepositoryProvider, List<IResource>> providerResources = this.getProviderMapping();
            for (Map.Entry<RepositoryProvider, List<IResource>> entry : providerResources.entrySet()) {
                IResource[] resourceArray;
                List<IResource> resourceList = entry.getValue();
                IResource[] iResourceArray = resourceArray = resourceList.toArray(new IResource[resourceList.size()]);
                int n = resourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource resource = iResourceArray[n2];
                    resources.add(resource);
                    ++n2;
                }
            }
        }
        return resources;
    }

    protected Map<IP4Connection, List<IResource>> getProviderMap() {
        HashMap<IP4Connection, List<IResource>> providerMap = new HashMap<IP4Connection, List<IResource>>();
        Hashtable<RepositoryProvider, List<IResource>> providerResources = this.getProviderMapping();
        for (Map.Entry<RepositoryProvider, List<IResource>> entry : providerResources.entrySet()) {
            List<IResource> resourceList = entry.getValue();
            if (resourceList.size() <= 0) continue;
            IResource firstResource = resourceList.get(0);
            IP4Connection connection = P4ConnectionManager.getManager().getConnection(firstResource.getProject());
            if (connection == null || connection.isOffline()) continue;
            ArrayList<IResource> resources = (ArrayList<IResource>)providerMap.get(connection);
            if (resources == null) {
                resources = new ArrayList<IResource>();
                providerMap.put(connection, resources);
            }
            resources.addAll(resourceList);
        }
        return providerMap;
    }

    @Override
    public void run(IAction action) {
        if (this.collection != null || this.getSelection() != null && !this.getSelection().isEmpty()) {
            this.runAction();
        }
    }

    protected abstract void runAction();

    @Override
    public void init(IWorkbenchWindow window) {
    }

    public boolean isAsync() {
        return this.async;
    }

    public void setAsync(boolean async) {
        this.async = async;
    }

    public void setCollection(P4Collection collection) {
        this.collection = collection;
    }

    public void setMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    protected String generateTitle(String command, IP4Resource[] resources, IP4Resource.Type type) {
        StringBuilder title = new StringBuilder();
        if (command != null) {
            title.append(command);
        }
        if (resources.length == 1) {
            String path = resources[0].getActionPath(type);
            if (path != null) {
                title.append(' ');
                title.append(path);
            }
        } else if (resources.length > 1) {
            int fileCount = 0;
            int folderCount = 0;
            IP4Resource[] iP4ResourceArray = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IP4Resource resource = iP4ResourceArray[n2];
                if (resource instanceof IP4File) {
                    ++fileCount;
                } else if (resource instanceof IP4Container) {
                    ++folderCount;
                }
                ++n2;
            }
            if (fileCount > 0 || folderCount > 0) {
                if (folderCount > 0) {
                    title.append(MessageFormat.format(Messages.P4Action_NumFolders, folderCount));
                }
                if (fileCount > 0) {
                    title.append(", ");
                }
            }
            if (fileCount > 0) {
                title.append(MessageFormat.format(Messages.P4Action_NumFiles, fileCount));
            }
        }
        return title.toString();
    }

    protected String generateTitle(String command, P4Collection collection) {
        return this.generateTitle(command, collection.members(), collection.getType());
    }

    protected int getSelectionSize() {
        int size = 0;
        if (this.collection != null) {
            size = this.collection.members().length;
        } else if (this.getSelection() != null) {
            size = this.getSelection().size();
        }
        return size;
    }
}

