/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.p4java.actions;

import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Label;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.P4Collection;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.ui.P4ConnectionManager;
import com.perforce.team.ui.labels.LabelFilesDialog;
import com.perforce.team.ui.p4java.actions.Messages;
import com.perforce.team.ui.p4java.actions.P4Action;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;

public class LabelFilesAction
extends P4Action {
    @Override
    public boolean isEnabledEx() {
        boolean enabled = this.containsOnlineConnection();
        if (enabled && !(enabled = this.containsContainers())) {
            enabled = !this.getResourceSelection().isEmpty();
        }
        return enabled;
    }

    private boolean labelExists(IP4Connection connection, String name) {
        boolean exists = false;
        IP4Label label = connection.getLabel(name);
        exists = label != null && label.getUpdateTime() != null && label.getAccessTime() != null;
        return exists;
    }

    private boolean confirmLabel(IP4Connection connection, String name) {
        boolean confirmed = this.labelExists(connection, name);
        if (!confirmed) {
            confirmed = P4ConnectionManager.getManager().openConfirm(Messages.LabelFilesAction_LabelDoesNotExistTitle, MessageFormat.format(Messages.LabelFilesAction_LabelDoesNotExistMessage, name));
        }
        return confirmed;
    }

    public void label(final String labelName, final String revision, final boolean delete) {
        P4Collection collection;
        if (labelName != null && !(collection = this.getResourceSelection()).isEmpty()) {
            P4Runnable runnable = new P4Runnable(){

                public void run(IProgressMonitor monitor) {
                    collection.tag(labelName, revision, delete, false);
                }

                public String getTitle() {
                    return MessageFormat.format(Messages.LabelFilesAction_LabelingResources, labelName);
                }
            };
            this.runRunnable((IP4Runnable)runnable);
        }
    }

    @Override
    protected void runAction() {
        LabelFilesDialog dialog;
        P4Collection collection = this.getResourceSelection();
        if (!collection.isEmpty() && (dialog = new LabelFilesDialog(this.getShell(), collection)).open() == 0) {
            final IP4Connection connection = collection.members()[0].getConnection();
            final String label = dialog.getSelectedLabel();
            final String revision = dialog.getRevision();
            final boolean delete = dialog.deleteFromLabel();
            P4Runnable runnable = new P4Runnable(){

                public void run(IProgressMonitor monitor) {
                    if (LabelFilesAction.this.confirmLabel(connection, label)) {
                        LabelFilesAction.this.label(label, revision, delete);
                    }
                }
            };
            this.runRunnable((IP4Runnable)runnable);
        }
    }
}

