/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.p4java.actions;

import com.perforce.p4java.client.IClient;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.team.core.P4ClientUtil;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.P4Event;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.ui.P4ConnectionManager;
import com.perforce.team.ui.P4TeamUtils;
import com.perforce.team.ui.p4java.actions.Messages;
import com.perforce.team.ui.p4java.actions.P4Action;
import com.perforce.team.ui.server.EditClientDialog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.ui.progress.UIJob;

public class EditClientAction
extends P4Action {
    @Override
    protected void runAction() {
        IP4Connection connection;
        IP4Resource resource = this.getSingleResourceSelection();
        if (resource instanceof IP4Connection && !(connection = (IP4Connection)resource).isOffline()) {
            P4Runnable runnable = new P4Runnable(){

                public void run(IProgressMonitor monitor) {
                    connection.refreshClient();
                    UIJob job = new UIJob(Messages.EditClientAction_EditingPerforceClient){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            EditClientAction.this.editClient(connection);
                            return Status.OK_STATUS;
                        }
                    };
                    job.schedule();
                }

                public String getTitle() {
                    return Messages.EditClientAction_RefreshingPerforceClient;
                }
            };
            this.runRunnable((IP4Runnable)runnable);
        }
    }

    private void editClient(IP4Connection connection) {
        try {
            IClient oldClient = connection.getClient();
            EditClientDialog dialog = new EditClientDialog(this.getShell(), connection);
            if (dialog.open() == 0) {
                connection.markForRefresh();
                P4ConnectionManager.getManager().notifyListeners(new P4Event(P4Event.EventType.REFRESHED, (IP4Resource)connection));
                if (P4ClientUtil.shouldSyncClient((IClient)oldClient, (IClient)connection.getClient())) {
                    P4TeamUtils.processClientChange(connection, this.getShell(), false, null);
                }
            }
        }
        catch (P4JavaException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.EditClientAction_ClientNotFoundTitle, (String)Messages.EditClientAction_ClientNotFoundMessage);
        }
    }

    @Override
    protected boolean isEnabledEx() throws TeamException {
        return this.getSelection() != null && this.getSelection().size() == 1 && this.containsOnlineConnection();
    }
}

